/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.EGLPathContainerInitializer;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLModelStatusConstants;
import org.eclipse.edt.ide.core.model.IEGLPathContainer;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;

public class EGLModelStatus
extends Status
implements IEGLModelStatus,
IEGLModelStatusConstants,
IResourceStatus {
    protected IEGLElement[] fElements = new IEGLElement[0];
    protected IPath fPath;
    protected String fString;
    protected static final IStatus[] fgEmptyChildren = new IStatus[0];
    protected IStatus[] fChildren = fgEmptyChildren;
    public static final IEGLModelStatus VERIFIED_OK = new EGLModelStatus(0, 0, EGLModelResources.statusOK);

    public EGLModelStatus() {
        super(4, EGLCore.PLUGIN_ID, 0, "EGLModelStatus", null);
    }

    public EGLModelStatus(int code) {
        super(4, EGLCore.PLUGIN_ID, code, "EGLModelStatus", null);
        this.fElements = EGLElementInfo.fgEmptyChildren;
    }

    public EGLModelStatus(int code, IEGLElement[] elements) {
        super(4, EGLCore.PLUGIN_ID, code, "EGLModelStatus", null);
        this.fElements = elements;
        this.fPath = null;
    }

    public EGLModelStatus(int code, String string) {
        this(4, code, string);
    }

    public EGLModelStatus(int severity, int code, String string) {
        super(severity, EGLCore.PLUGIN_ID, code, "EGLModelStatus", null);
        this.fElements = EGLElementInfo.fgEmptyChildren;
        this.fPath = null;
        this.fString = string;
    }

    public EGLModelStatus(int code, Throwable throwable) {
        super(4, EGLCore.PLUGIN_ID, code, "EGLModelStatus", throwable);
        this.fElements = EGLElementInfo.fgEmptyChildren;
    }

    public EGLModelStatus(int code, IPath path) {
        super(4, EGLCore.PLUGIN_ID, code, "EGLModelStatus", null);
        this.fElements = EGLElementInfo.fgEmptyChildren;
        this.fPath = path;
    }

    public EGLModelStatus(int code, IEGLElement element) {
        this(code, new IEGLElement[]{element});
    }

    public EGLModelStatus(int code, IEGLElement element, String string) {
        this(code, new IEGLElement[]{element});
        this.fString = string;
    }

    public EGLModelStatus(int code, IEGLElement element, IPath path) {
        this(code, new IEGLElement[]{element});
        this.fPath = path;
    }

    public EGLModelStatus(CoreException coreException) {
        super(4, EGLCore.PLUGIN_ID, 966, "EGLModelStatus", (Throwable)coreException);
        this.fElements = EGLElementInfo.fgEmptyChildren;
    }

    protected int getBits() {
        int severity = 1 << this.getCode() % 100 / 33;
        int category = 1 << this.getCode() / 100 + 3;
        return severity | category;
    }

    public IStatus[] getChildren() {
        return this.fChildren;
    }

    @Override
    public IEGLElement[] getElements() {
        return this.fElements;
    }

    public String getMessage() {
        Throwable exception = this.getException();
        if (exception == null) {
            switch (this.getCode()) {
                case 966: {
                    return EGLModelResources.statusCoreException;
                }
                case 990: {
                    return EGLModelResources.buildInitializationError;
                }
                case 991: {
                    return EGLModelResources.buildSerializationError;
                }
                case 973: {
                    return EGLModelResources.bind((String)EGLModelResources.statusCannotUseDeviceOnPath, (Object)this.getPath().toString());
                }
                case 969: {
                    return EGLModelResources.bind((String)EGLModelResources.elementDoesNotExist, (Object)((EGLElement)this.fElements[0]).toStringWithAncestors());
                }
                case 992: {
                    return EGLModelResources.bind((String)EGLModelResources.statusEvaluationError, (Object)this.fString);
                }
                case 980: {
                    return EGLModelResources.statusIndexOutOfBounds;
                }
                case 984: {
                    return EGLModelResources.statusInvalidContents;
                }
                case 978: {
                    return EGLModelResources.bind((String)EGLModelResources.statusInvalidDestination, (Object)((EGLElement)this.fElements[0]).toStringWithAncestors());
                }
                case 967: {
                    StringBuffer buff = new StringBuffer(EGLModelResources.operationNotSupported);
                    int i = 0;
                    while (i < this.fElements.length) {
                        if (i > 0) {
                            buff.append(", ");
                        }
                        buff.append(((EGLElement)this.fElements[i]).toStringWithAncestors());
                        ++i;
                    }
                    return buff.toString();
                }
                case 983: {
                    return EGLModelResources.bind((String)EGLModelResources.statusInvalidName, (Object)this.fString);
                }
                case 998: {
                    return EGLModelResources.bind((String)EGLModelResources.statusInvalidPackage, (Object)this.fString);
                }
                case 979: {
                    if (this.fString != null) {
                        return this.fString;
                    }
                    return EGLModelResources.bind((String)EGLModelResources.statusInvalidPath, (Object)(this.getPath() == null ? "null" : this.getPath().toString()));
                }
                case 997: {
                    return EGLModelResources.bind((String)EGLModelResources.statusInvalidProject, (Object)this.fString);
                }
                case 995: {
                    return EGLModelResources.bind((String)EGLModelResources.statusInvalidResource, (Object)this.fString);
                }
                case 996: {
                    return EGLModelResources.bind((String)EGLModelResources.statusInvalidResourceType, (Object)this.fString);
                }
                case 993: {
                    if (this.fString != null) {
                        return EGLModelResources.bind((String)EGLModelResources.statusInvalidSibling, (Object)this.fString);
                    }
                    return EGLModelResources.bind((String)EGLModelResources.statusInvalidSibling, (Object)((EGLElement)this.fElements[0]).toStringWithAncestors());
                }
                case 985: {
                    return EGLModelResources.statusIOException;
                }
                case 977: {
                    if (this.fElements != null && this.fElements.length > 0) {
                        IEGLElement element = this.fElements[0];
                        String name = element.getElementName();
                        if (element instanceof IPackageFragment && name.equals("")) {
                            return EGLModelResources.operationCannotRenameDefaultPackage;
                        }
                    }
                    if (this.fString != null) {
                        return this.fString;
                    }
                    return EGLModelResources.bind((String)EGLModelResources.statusNameCollision, (Object)"");
                }
                case 968: {
                    return EGLModelResources.operationNeedElements;
                }
                case 982: {
                    return EGLModelResources.operationNeedName;
                }
                case 970: {
                    return EGLModelResources.operationNeedPath;
                }
                case 974: {
                    return EGLModelResources.operationNeedString;
                }
                case 971: {
                    return EGLModelResources.bind((String)EGLModelResources.operationPathOutsideProject, (Object)this.fString, (Object)((EGLElement)this.fElements[0]).toStringWithAncestors());
                }
                case 976: {
                    IEGLElement element = this.fElements[0];
                    String name = element.getElementName();
                    if (element instanceof IPackageFragment && name.equals("")) {
                        return EGLModelResources.statusDefaultPackeReadOnly;
                    }
                    return EGLModelResources.bind((String)EGLModelResources.statusReadOnly, (Object)name);
                }
                case 972: {
                    return EGLModelResources.bind((String)EGLModelResources.operationNeedAbsolutePath, (Object)this.getPath().toString());
                }
                case 987: {
                    return EGLModelResources.statusTargetException;
                }
                case 981: {
                    return EGLModelResources.statusUpdateConflict;
                }
                case 999: {
                    return EGLModelResources.bind((String)EGLModelResources.statusNoLocalContents, (Object)this.getPath().toString());
                }
                case 963: {
                    IPath path = this.fPath;
                    IEGLProject EGLProject2 = (IEGLProject)this.fElements[0];
                    EGLPathContainerInitializer initializer = EGLCore.getEGLPathContainerInitializer(path.segment(0));
                    String description = null;
                    if (initializer != null) {
                        description = initializer.getDescription(path, EGLProject2);
                    }
                    if (description == null) {
                        description = path.makeRelative().toString();
                    }
                    return EGLModelResources.bind((String)EGLModelResources.eglpathUnboundContainerPath, (Object)description);
                }
                case 962: {
                    IPath path = this.fPath;
                    IEGLProject EGLProject3 = (IEGLProject)this.fElements[0];
                    IEGLPathContainer container = null;
                    String description = null;
                    try {
                        container = EGLCore.getEGLPathContainer(path, EGLProject3);
                    }
                    catch (EGLModelException eGLModelException) {}
                    if (container == null) {
                        EGLPathContainerInitializer initializer = EGLCore.getEGLPathContainerInitializer(path.segment(0));
                        if (initializer != null) {
                            description = initializer.getDescription(path, EGLProject3);
                        }
                    } else {
                        description = container.getDescription();
                    }
                    if (description == null) {
                        description = path.makeRelative().toString();
                    }
                    return EGLModelResources.bind((String)EGLModelResources.eglpathInvalidContainer, (Object)description);
                }
                case 965: {
                    IPath path = this.fPath;
                    return EGLModelResources.bind((String)EGLModelResources.eglpathUnboundVariablePath, (Object)path.makeRelative().toString());
                }
                case 1001: {
                    IEGLProject EGLProject4 = (IEGLProject)this.fElements[0];
                    return EGLModelResources.bind((String)EGLModelResources.eglpathCycle, (Object)EGLProject4.getElementName());
                }
                case 1002: {
                    IPath path = this.fPath;
                    return EGLModelResources.bind((String)EGLModelResources.eglpathDisabledExclusionPatterns, (Object)path.makeRelative().toString());
                }
                case 1003: {
                    IPath path = this.fPath;
                    return EGLModelResources.bind((String)EGLModelResources.eglpathDisabledMultipleOutputLocations, (Object)path.makeRelative().toString());
                }
            }
            if (this.fString != null) {
                return this.fString;
            }
            return "";
        }
        String message = exception.getMessage();
        if (message != null) {
            return message;
        }
        return exception.toString();
    }

    @Override
    public IPath getPath() {
        return this.fPath;
    }

    public int getSeverity() {
        if (this.fChildren == fgEmptyChildren) {
            return super.getSeverity();
        }
        int severity = -1;
        int i = 0;
        int max = this.fChildren.length;
        while (i < max) {
            int childrenSeverity = this.fChildren[i].getSeverity();
            if (childrenSeverity > severity) {
                severity = childrenSeverity;
            }
            ++i;
        }
        return severity;
    }

    @Override
    public String getString() {
        return this.fString;
    }

    @Override
    public boolean isDoesNotExist() {
        return this.getCode() == 969;
    }

    public boolean isMultiStatus() {
        return this.fChildren != fgEmptyChildren;
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public boolean matches(int mask) {
        if (!this.isMultiStatus()) {
            return this.matches(this, mask);
        }
        int i = 0;
        int max = this.fChildren.length;
        while (i < max) {
            if (this.matches((EGLModelStatus)this.fChildren[i], mask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matches(EGLModelStatus status, int mask) {
        int severityMask = mask & 7;
        int categoryMask = mask & 0xFFFFFFF8;
        int bits = status.getBits();
        return !(severityMask != 0 && (bits & severityMask) == 0 || categoryMask != 0 && (bits & categoryMask) == 0);
    }

    public static IEGLModelStatus newMultiStatus(IEGLModelStatus[] children) {
        EGLModelStatus jms = new EGLModelStatus();
        jms.fChildren = children;
        return jms;
    }

    public String toString() {
        if (this == VERIFIED_OK) {
            return "EGLModelStatus[OK]";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("EGL Model Status [");
        buffer.append(this.getMessage());
        buffer.append("]");
        return buffer.toString();
    }
}

