/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.builder.IFileSystemObjectStore;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfoManager;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class WorkingCopyProjectBuildPathEntryManager {
    private static final WorkingCopyProjectBuildPathEntryManager INSTANCE = new WorkingCopyProjectBuildPathEntryManager();
    private Map<IProject, WorkingCopyProjectBuildPathEntry> projectBuildPathEntries;

    private WorkingCopyProjectBuildPathEntryManager() {
        this.init();
    }

    private void init() {
        this.projectBuildPathEntries = new HashMap<IProject, WorkingCopyProjectBuildPathEntry>();
    }

    public static WorkingCopyProjectBuildPathEntryManager getInstance() {
        return INSTANCE;
    }

    public WorkingCopyProjectBuildPathEntry getProjectBuildPathEntry(IProject project) {
        WorkingCopyProjectBuildPathEntry result = this.projectBuildPathEntries.get(project);
        if (result == null) {
            result = new WorkingCopyProjectBuildPathEntry(WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project));
            this.projectBuildPathEntries.put(project, result);
            WorkingCopyProjectBuildPath buildPath = WorkingCopyProjectBuildPathManager.getInstance().getProjectBuildPath(project);
            IPath path = buildPath.getOutputLocation().getFullPath();
            ProjectIREnvironment irEnv = WorkingCopyProjectEnvironmentManager.getInstance().getIREnvironment(project);
            result.setObjectStores(new ObjectStore[]{new IFileSystemObjectStore(path, (IEnvironment)irEnv, "XML"), new IFileSystemObjectStore(path, (IEnvironment)irEnv, "XML", ".eglxml")});
            result.setDeclaringEnvironment(WorkingCopyProjectEnvironmentManager.getInstance().getProjectEnvironment(project));
        }
        return result;
    }

    public void clear() {
        for (WorkingCopyProjectBuildPathEntry entry : this.projectBuildPathEntries.values()) {
            entry.clear();
        }
    }

    public void remove(IProject project) {
        this.projectBuildPathEntries.remove(project);
    }
}

