/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.javascript.internal.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.debug.javascript.EDTJavaScriptDebugPlugin;
import org.eclipse.edt.ide.debug.javascript.internal.server.DebugContext;
import org.eclipse.edt.ide.debug.javascript.internal.utils.RUIDebugUtil;
import org.eclipse.edt.ide.rui.server.IContext;
import org.eclipse.edt.ide.rui.server.IContextResolver;

public class RUIDebugContextResolver
implements IContextResolver {
    private static final int maxToRemember = 20;
    private static final RUIDebugContextResolver INSTANCE = new RUIDebugContextResolver();
    private final Map<Integer, DebugContext> contextMap = new HashMap<Integer, DebugContext>();
    private final Map<Integer, DebugContext> terminatedContextMap = new LinkedHashMap<Integer, DebugContext>(20, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() >= 20;
        }
    };

    private RUIDebugContextResolver() {
    }

    public static RUIDebugContextResolver getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContext findContext(Integer contextKey) {
        Map<Integer, DebugContext> map = this.contextMap;
        synchronized (map) {
            DebugContext context = this.contextMap.get(contextKey);
            if (context != null) {
                return context;
            }
            context = this.terminatedContextMap.get(contextKey);
            if (context != null) {
                try {
                    RUIDebugUtil.relaunchContext(context);
                    return (IContext)this.contextMap.get(contextKey);
                }
                catch (CoreException e) {
                    EDTJavaScriptDebugPlugin.log(e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContext(DebugContext context) {
        Map<Integer, DebugContext> map = this.contextMap;
        synchronized (map) {
            this.contextMap.put(context.getKey(), context);
            this.terminatedContextMap.remove(context.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(DebugContext context) {
        Map<Integer, DebugContext> map = this.contextMap;
        synchronized (map) {
            this.contextMap.remove(context.getKey());
            this.terminatedContextMap.put(context.getKey(), context);
            context.clear();
        }
    }
}

