/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.codegen.java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.codegen.api.TemplateException;
import org.eclipse.edt.mof.codegen.api.TemplateFactory;
import org.eclipse.edt.mof.codegen.java.EFactoryImplTemplate;
import org.eclipse.edt.mof.codegen.java.MofImplTemplateFactory;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.FileSystemObjectStore;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class EGL2MofImplGenerator {
    IEnvironment env = Environment.getCurrentEnv();
    File outputDir;
    String pathFromRoot;
    String[][] packageMappings;
    List<EClassifier> processed;

    public static void main(String[] args) {
        String eglroot = null;
        String javaroot = null;
        String fileName = null;
        String factoryName = null;
        boolean factoryOnly = false;
        String[][] packageMappings = null;
        if (args.length < 2) {
            return;
        }
        eglroot = args[0];
        if (args.length > 1) {
            javaroot = args[1];
        }
        if (args.length > 2 && (fileName = args[2]).equals("null")) {
            fileName = null;
        }
        if (args.length > 3) {
            factoryName = args[3];
        }
        factoryOnly = args.length > 4;
        EGL2MofImplGenerator generator = new EGL2MofImplGenerator(eglroot, javaroot, packageMappings);
        if (fileName == null) {
            generator.generateFiles(new File(eglroot));
        } else {
            String filePath = String.valueOf(eglroot) + "/" + fileName.replace('.', '/');
            File file = new File(filePath);
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().endsWith(".mofxml")) {
                        String partName = f.getName().split("[.]")[0];
                        String typeSignature = (String.valueOf(fileName) + "." + partName).toLowerCase();
                        if (factoryOnly) {
                            generator.readClassifier(typeSignature);
                        } else {
                            generator.generate(typeSignature, new File(javaroot));
                        }
                    }
                    ++n2;
                }
                if (factoryName != null) {
                    generator.generateFactory(factoryName, new File(javaroot));
                }
            } else if (factoryOnly && fileName != null) {
                generator.readClassifier(fileName);
                generator.generateFactory(factoryName, new File(javaroot));
            } else if (fileName != null) {
                generator.generate(fileName, new File(javaroot));
            }
        }
    }

    EGL2MofImplGenerator(String irPaths, String javaSrc, String[][] packageMappings) {
        String[] roots;
        String[] stringArray = roots = irPaths.split("[;]");
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            File dir = new File(root);
            FileSystemObjectStore store = new FileSystemObjectStore(dir, this.env, "XML");
            this.env.registerObjectStore("mof", store);
            ++n2;
        }
        this.outputDir = new File(javaSrc);
        this.pathFromRoot = "";
        this.packageMappings = packageMappings;
        this.processed = new ArrayList<EClassifier>();
    }

    void generateFiles(File parentDir) {
        File[] fileArray = parentDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                if (!this.pathFromRoot.startsWith("/azure")) {
                    String previousPath = this.pathFromRoot;
                    this.pathFromRoot = String.valueOf(this.pathFromRoot) + "/" + f.getName();
                    this.generateFiles(f);
                    this.pathFromRoot = previousPath;
                }
            } else {
                String fileName = f.getName();
                if (fileName.endsWith(".eglbin")) {
                    fileName = fileName.split("[.]")[0];
                    String path = String.valueOf(this.pathFromRoot) + "/" + fileName;
                    path = path.replace('/', '.').substring(1);
                    this.generate(path, this.outputDir);
                }
            }
            ++n2;
        }
    }

    void generate(String typeSignature, File root) {
        try {
            Template template;
            TemplateFactory factory = this.getTemplateFactory();
            TemplateContext ctx = new TemplateContext();
            if (this.packageMappings != null) {
                String[][] stringArray = this.packageMappings;
                int n = this.packageMappings.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] mapping = stringArray[n2];
                    ctx.put(mapping[0], mapping[1]);
                    ++n2;
                }
            }
            ctx.setTemplateFactory(factory);
            EClassifier eClass = (EClassifier)this.env.findType(typeSignature);
            String packageName = (String)ctx.get(eClass.getPackageName());
            String path = packageName == null ? eClass.getPackageName().replace('.', '/') : packageName.replace('.', '/');
            if (eClass.getEClass().getName().equals("EEnum")) {
                template = ctx.getTemplateFor(eClass.getEClass());
                this.genTemplate(template, "genImpl", eClass, root, path, String.valueOf(eClass.getName()) + ".java", ctx);
            } else if (eClass instanceof EClass) {
                template = ctx.getTemplateFor(eClass.getEClass());
                this.genTemplate(template, "genInterface", eClass, root, path, String.valueOf(eClass.getName()) + ".java", ctx);
                if (!((EClass)eClass).isInterface()) {
                    if (!((EClass)eClass).getEFunctions().isEmpty()) {
                        File outDir = new File(root, String.valueOf(path) + "/impl");
                        File file = new File(outDir, String.valueOf(eClass.getName()) + "Base.java");
                        this.genTemplate(template, "genImplBase", eClass, root, String.valueOf(path) + "/impl", String.valueOf(eClass.getName()) + "ImplBase.java", ctx);
                        outDir = new File(root, String.valueOf(path) + "/impl");
                        file = new File(outDir, String.valueOf(eClass.getName()) + "Impl.java");
                        if (!file.exists()) {
                            this.genTemplate(template, "genImplExtendsBase", eClass, root, String.valueOf(path) + "/impl", String.valueOf(eClass.getName()) + "Impl.java", ctx);
                        }
                    } else {
                        new File(root, String.valueOf(path) + "impl");
                        this.genTemplate(template, "genImpl", eClass, root, String.valueOf(path) + "/impl", String.valueOf(eClass.getName()) + "Impl.java", ctx);
                    }
                }
            }
            this.processed.add(eClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void generateFactory(String factoryName, File root) {
        try {
            String path;
            TemplateContext ctx = new TemplateContext();
            EFactoryImplTemplate template = new EFactoryImplTemplate();
            EClassifier classifier = this.processed.get(0);
            String packageName = (String)ctx.get(classifier.getPackageName());
            if (packageName == null) {
                packageName = classifier.getPackageName();
                path = classifier.getPackageName().replace('.', '/');
            } else {
                path = packageName.replace('.', '/');
            }
            String name = factoryName;
            if (factoryName.equals("default")) {
                String[] names = packageName.split("[.]");
                name = names[names.length - 1].substring(0, 1).toUpperCase();
                name = String.valueOf(name) + names[names.length - 1].substring(1);
                name = String.valueOf(name) + "Factory";
            }
            StringWriter writer = new StringWriter();
            TabbedWriter out = new TabbedWriter(writer);
            template.genFactory(this.processed, ctx, out);
            out.flush();
            this.writeToFile(root, path, String.valueOf(name) + ".java", writer.toString());
            writer = new StringWriter();
            out = new TabbedWriter(writer);
            template.genFactoryImpl(this.processed, ctx, out);
            out.flush();
            this.writeToFile(root, String.valueOf(path) + "/impl", String.valueOf(name) + "Base.java", writer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void readClassifier(String typeSignature) {
        try {
            EClassifier classifier = (EClassifier)this.env.findType(typeSignature);
            this.processed.add(classifier);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void genTemplate(Template template, String genMethod, EObject obj, File root, String path, String fileName, TemplateContext ctx) throws TemplateException {
        StringWriter writer = new StringWriter();
        TabbedWriter out = new TabbedWriter(writer);
        out.setAutoIndent(false);
        template.gen(genMethod, obj, ctx, out, new Object[0]);
        out.flush();
        this.writeToFile(root, path, fileName, writer.toString());
    }

    private void writeToFile(File parent, String path, String fileName, String content) {
        File outDir = new File(parent, path);
        File file = new File(outDir, fileName);
        try {
            outDir.mkdirs();
            FileOutputStream out = new FileOutputStream(file);
            out.write(content.getBytes());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected TemplateFactory getTemplateFactory() throws TemplateException {
        return new MofImplTemplateFactory();
    }
}

