/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java.variables;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.java.IEGLJavaStackFrame;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.core.java.variables.VariableUtil;
import org.eclipse.edt.debug.internal.core.java.EGLJavaValue;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class BytesVariable
extends EGLJavaVariable {
    public BytesVariable(IDebugTarget target, IJavaVariable javaVariable, SMAPVariableInfo variableInfo, IEGLJavaStackFrame frame, IEGLJavaValue parent) {
        super(target, javaVariable, variableInfo, frame, parent);
    }

    @Override
    protected IEGLJavaValue createEGLValue(IJavaValue javaValue) {
        return new EGLJavaValue(this.getDebugTarget(), javaValue, this){

            @Override
            public String getValueString() throws DebugException {
                if (this.javaValue.isNull()) {
                    return "null";
                }
                if (this.javaValue instanceof IJavaArray) {
                    IJavaValue[] elements = ((IJavaArray)this.javaValue).getValues();
                    StringBuilder buf = new StringBuilder(100);
                    if (elements.length > 0) {
                        buf.append("0x");
                        IJavaValue[] iJavaValueArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IJavaValue next = iJavaValueArray[n2];
                            String nextValue = Long.toHexString(Long.parseLong(next.getValueString()) & 0xFFL).toUpperCase();
                            if (nextValue.length() % 2 != 0) {
                                buf.append('0');
                            }
                            buf.append(nextValue);
                            ++n2;
                        }
                    }
                    return buf.toString();
                }
                return this.javaValue.getValueString();
            }

            @Override
            public IVariable[] getVariables() {
                return VariableUtil.EMPTY_VARIABLES;
            }

            @Override
            public boolean hasVariables() {
                return false;
            }

            @Override
            public String computeDetail() {
                try {
                    return this.getValueString();
                }
                catch (DebugException e) {
                    return e.getLocalizedMessage();
                }
            }
        };
    }

    @Override
    protected boolean shouldCheckJavaElementAdapter() {
        return false;
    }
}

