/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class AnimatedBusyPainter
extends Composite
implements DisposeListener {
    protected GC _gc = null;
    protected int _iCurrentIndex = 0;
    protected AnimationTimer _timer = null;
    protected static Color _color1 = null;
    protected static Color _color2 = null;
    protected static Color _color3 = null;
    protected static Point[] _ptLOCATIONS = null;

    public AnimatedBusyPainter(Composite compositeParent) {
        super(compositeParent, 0);
        if (_ptLOCATIONS == null) {
            _ptLOCATIONS = new Point[8];
            AnimatedBusyPainter._ptLOCATIONS[0] = new Point(6, 0);
            AnimatedBusyPainter._ptLOCATIONS[1] = new Point(10, 2);
            AnimatedBusyPainter._ptLOCATIONS[2] = new Point(12, 6);
            AnimatedBusyPainter._ptLOCATIONS[3] = new Point(10, 10);
            AnimatedBusyPainter._ptLOCATIONS[4] = new Point(6, 12);
            AnimatedBusyPainter._ptLOCATIONS[5] = new Point(2, 10);
            AnimatedBusyPainter._ptLOCATIONS[6] = new Point(0, 6);
            AnimatedBusyPainter._ptLOCATIONS[7] = new Point(2, 2);
        }
        if (_color1 == null) {
            _color1 = this.getDisplay().getSystemColor(15);
        }
        if (_color2 == null) {
            _color2 = this.getDisplay().getSystemColor(16);
        }
        if (_color3 == null) {
            _color3 = this.getDisplay().getSystemColor(2);
        }
        this._gc = new GC((Drawable)this);
        this.addDisposeListener(this);
    }

    public void animationStart() {
        if (this._gc == null || this._gc.isDisposed()) {
            return;
        }
        if (this._timer == null) {
            this.setVisible(true);
            this._timer = new AnimationTimer();
            this._timer.start();
        }
    }

    public void animationStop() {
        if (this._gc == null || this._gc.isDisposed()) {
            return;
        }
        this.setVisible(false);
        this.stopTimer();
    }

    protected void paintCircle(int iIndex, Color colorCircle, Color colorCenter) {
        Point ptLocation = _ptLOCATIONS[iIndex];
        this._gc.setForeground(colorCircle);
        this._gc.drawPoint(ptLocation.x + 1, ptLocation.y + 0);
        this._gc.drawPoint(ptLocation.x + 2, ptLocation.y + 0);
        this._gc.drawPoint(ptLocation.x + 0, ptLocation.y + 1);
        this._gc.drawPoint(ptLocation.x + 3, ptLocation.y + 1);
        this._gc.drawPoint(ptLocation.x + 0, ptLocation.y + 2);
        this._gc.drawPoint(ptLocation.x + 3, ptLocation.y + 2);
        this._gc.drawPoint(ptLocation.x + 1, ptLocation.y + 3);
        this._gc.drawPoint(ptLocation.x + 2, ptLocation.y + 3);
        this._gc.setForeground(colorCenter);
        this._gc.drawPoint(ptLocation.x + 1, ptLocation.y + 1);
        this._gc.drawPoint(ptLocation.x + 2, ptLocation.y + 1);
        this._gc.drawPoint(ptLocation.x + 1, ptLocation.y + 2);
        this._gc.drawPoint(ptLocation.x + 2, ptLocation.y + 2);
    }

    protected void stopTimer() {
        if (this._timer != null) {
            this._timer._bRun = false;
        }
        this._timer = null;
    }

    protected void tick() {
        if (this._gc == null || this._gc.isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AnimatedBusyPainter.this.tickAsync();
            }
        });
    }

    protected void tickAsync() {
        if (this._gc == null || this._gc.isDisposed()) {
            return;
        }
        this._gc.setBackground(this.getBackground());
        this._gc.fillRectangle(0, 0, 16, 16);
        int i = 0;
        while (i < _ptLOCATIONS.length) {
            if (i != this._iCurrentIndex) {
                this.paintCircle(i, _color2, _color3);
            }
            ++i;
        }
        this.paintCircle(this._iCurrentIndex, _color1, _color1);
        if (++this._iCurrentIndex >= _ptLOCATIONS.length) {
            this._iCurrentIndex = 0;
        }
        this.paintCircle(this._iCurrentIndex, _color1, _color2);
    }

    public synchronized void widgetDisposed(DisposeEvent e) {
        if (this._gc != null && !this._gc.isDisposed()) {
            this._gc.dispose();
        }
    }

    protected class AnimationTimer
    extends Thread {
        public boolean _bRun;

        public AnimationTimer() {
            super("Image Animator");
            this._bRun = true;
        }

        @Override
        public void run() {
            while (this._bRun) {
                try {
                    AnimatedBusyPainter.this.tick();
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

