/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.generator.egl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.CommandParameter;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.egl.EglGenerator;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;

public class Java2EGL
extends AbstractGeneratorCommand {
    public static void main(String[] args) {
        Java2EGL genPart = new Java2EGL();
        genPart.generate(args, new EglGenerator((AbstractGeneratorCommand)genPart), null);
    }

    public void generate(String[] args, EglGenerator generator, IEnvironment environment) {
        if (this.initialize(args, (Generator)generator)) {
            try {
                block11: {
                    if (environment != null) {
                        Environment.pushEnv((IEnvironment)environment);
                    }
                    try {
                        List<Class<?>> clazzes = this.loadClasses();
                        for (Class<?> clazz : clazzes) {
                            generator.generate(clazz);
                            try {
                                if (generator.getResult() == null) continue;
                                this.writeFile(clazz, generator);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (generator == null) break block11;
                        System.out.print(generator.getResult());
                    }
                }
                generator.dumpErrorMessages();
            }
            finally {
                if (environment != null) {
                    Environment.popEnv();
                }
            }
        }
    }

    protected void writeFile(Class<?> clazz, EglGenerator generator) throws Exception {
        IEnvironment env = Environment.getCurrentEnv();
        if (env != null && generator.getResult() != null) {
            env.save((MofSerializable)generator.getResult());
        }
    }

    protected List<Class<?>> loadClasses() throws Exception {
        ArrayList parts = new ArrayList();
        String rootName = (String)((CommandParameter)this.getParameterMapping().get("root")).getValue();
        String partName = (String)((CommandParameter)this.getParameterMapping().get("part")).getValue();
        if (partName.indexOf("*") >= 0) {
            String totalName = rootName.endsWith(File.separator) ? rootName : String.valueOf(rootName) + File.separator;
            totalName = partName.startsWith(File.separator) ? String.valueOf(totalName) + partName.substring(File.separator.length()) : String.valueOf(totalName) + partName;
            totalName = totalName.replace('\\', File.separatorChar);
            totalName = totalName.replace('/', File.separatorChar);
            totalName = totalName.replace('.', File.separatorChar);
            File classRootDirFile = new File(rootName);
            ArrayList<File> classfiles = new ArrayList<File>();
            this.listAllFiles(classRootDirFile, classfiles, totalName);
            for (File classfile : classfiles) {
                String classFileRelativePath = classfile.getAbsolutePath().substring(classRootDirFile.getAbsolutePath().length());
                if (classFileRelativePath.startsWith(File.separator)) {
                    classFileRelativePath = classFileRelativePath.substring(File.separator.length());
                }
                parts.add(this.getClassLoader().loadClass(classFileRelativePath.substring(0, classFileRelativePath.lastIndexOf(".")).replace(File.separatorChar, '.')));
            }
        } else {
            parts.add(this.getClassLoader().loadClass(partName));
        }
        return parts;
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    private void listAllFiles(File parent, List<File> files, String pattern) {
        if (parent.isDirectory()) {
            File[] children;
            File[] fileArray = children = parent.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile() && child.getName().toLowerCase(Locale.ENGLISH).endsWith(".class")) {
                    String name = child.getPath();
                    int prefixLength = pattern.indexOf("*");
                    if (name.length() >= prefixLength && name.substring(0, prefixLength).equalsIgnoreCase(pattern.substring(0, prefixLength)) && (pattern.length() <= prefixLength + 1 || name.toLowerCase(Locale.ENGLISH).endsWith(String.valueOf(pattern.substring(prefixLength + 1)) + ".class"))) {
                        files.add(child);
                    }
                }
                this.listAllFiles(child, files, pattern);
                ++n2;
            }
        }
    }
}

