/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.utils.AbsolutePathUtility;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;

public class ProjectPathUtility {
    public static void addEglPathOfProject(IProject project, Collection eglPath, IWorkspaceRoot root, Set visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        if (EGLProject.hasEGLNature(project)) {
            try {
                EGLProject eglProject = (EGLProject)EGLCore.create(project);
                IEGLPathEntry[] entries = eglProject.getResolvedEGLPath(true);
                int i = 0;
                while (i < entries.length) {
                    IResource member;
                    IEGLPathEntry entry = entries[i];
                    if (entry.getEntryKind() == 3) {
                        member = root.findMember(entry.getPath());
                        if (member != null && member.getLocation() != null) {
                            eglPath.add(member.getLocation().toOSString());
                        }
                    } else if (entry.getEntryKind() == 1) {
                        eglPath.add(ProjectPathUtility.resolvePathString(entry.getPath()));
                    } else if (entry.getEntryKind() == 2 && (member = root.findMember(entry.getPath())) != null && member.getType() == 4) {
                        ProjectPathUtility.addEglPathOfProject((IProject)member, eglPath, root, visited);
                    }
                    ++i;
                }
            }
            catch (EGLModelException eGLModelException) {}
        }
        eglPath.add(project.getLocation().toOSString());
    }

    public static String getEglPathString(IProject[] projects) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList eglPathSet = new ArrayList();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            ProjectPathUtility.addEglPathOfProject(project, eglPathSet, root, new HashSet());
            ++i;
        }
        String eglProjectPathString = "";
        HashSet<String> paths = new HashSet<String>();
        for (String s : eglPathSet) {
            if (paths.contains(s)) continue;
            paths.add(s);
            eglProjectPathString = String.valueOf(eglProjectPathString) + s;
            eglProjectPathString = String.valueOf(eglProjectPathString) + File.pathSeparator;
        }
        return eglProjectPathString;
    }

    private static String resolvePathString(IPath path) {
        return AbsolutePathUtility.getAbsolutePathString(path);
    }
}

