/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.internal.model.EGLElementDelta;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.util.EGLProjectFileUtilityLocator;
import org.eclipse.edt.ide.core.internal.model.util.IEGLProjectFileUtility;
import org.eclipse.edt.ide.core.internal.model.util.ObjectVector;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModelStatus;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public class SetEGLPathOperation
extends EGLModelOperation {
    IEGLPathEntry[] oldResolvedPath;
    IEGLPathEntry[] newResolvedPath;
    IEGLPathEntry[] newRawPath;
    boolean canChangeResource;
    boolean needCycleCheck;
    boolean needValidation;
    boolean needSave;
    IPath newOutputLocation;
    public static final IEGLPathEntry[] ReuseEGLPath = new IEGLPathEntry[0];
    public static final IEGLPathEntry[] UpdateEGLPath = new IEGLPathEntry[0];
    public static final IPath ReuseOutputLocation = new Path("Reuse Existing Output Location");

    public SetEGLPathOperation(IEGLProject project, IEGLPathEntry[] oldResolvedPath, IEGLPathEntry[] newRawPath, IPath newOutputLocation, boolean canChangeResource, boolean needValidation, boolean needSave) {
        super(new IEGLElement[]{project});
        this.oldResolvedPath = oldResolvedPath;
        this.newRawPath = newRawPath;
        this.newOutputLocation = newOutputLocation;
        this.canChangeResource = canChangeResource;
        this.needValidation = needValidation;
        this.needSave = needSave;
    }

    protected void addEGLPathDeltas(IPackageFragmentRoot[] roots, int flag, EGLElementDelta delta) {
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            delta.changed(root, flag);
            if ((flag & 0x80) != 0) {
                try {
                    root.close();
                }
                catch (EGLModelException eGLModelException) {}
            }
            ++i;
        }
    }

    protected int[] eglpathContains(IEGLPathEntry[] list, IEGLPathEntry entry) {
        int[] temp = new int[list.length];
        int index = 0;
        int i = 0;
        while (i < list.length) {
            IEGLPathEntry other = list[i];
            if (other.equals(entry)) {
                temp[index++] = i;
            }
            ++i;
        }
        if (index == 0) {
            return new int[0];
        }
        int[] ret = new int[index];
        System.arraycopy(temp, 0, ret, 0, index);
        return ret;
    }

    private boolean foundIndex(int index, int[] indexes) {
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            if (value == index) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void collectAllSubfolders(IFolder folder, ArrayList collection) throws EGLModelException {
        try {
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource r = members[i];
                if (r.getType() == 2) {
                    collection.add(r);
                    this.collectAllSubfolders((IFolder)r, collection);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    protected ArrayList determineAffectedPackageFragments(IPath location) throws EGLModelException {
        ArrayList<IPackageFragment> fragments = new ArrayList<IPackageFragment>();
        EGLProject project = this.getProject();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResource resource = null;
        if (location != null) {
            resource = workspace.getRoot().findMember(location);
        }
        if (resource != null && resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            IEGLPathEntry[] eglpath = project.getExpandedEGLPath(true);
            int i = 0;
            while (i < eglpath.length) {
                IEGLPathEntry entry = eglpath[i];
                IPath path = eglpath[i].getPath();
                if (entry.getEntryKind() != 2 && path.isPrefixOf(location) && !path.equals((Object)location)) {
                    IPackageFragmentRoot[] roots = project.computePackageFragmentRoots(eglpath[i]);
                    IPackageFragmentRoot root = roots[0];
                    ArrayList<IFolder> folders = new ArrayList<IFolder>();
                    folders.add(folder);
                    this.collectAllSubfolders(folder, folders);
                    Iterator elements = folders.iterator();
                    int segments = path.segmentCount();
                    while (elements.hasNext()) {
                        IFolder f = (IFolder)elements.next();
                        IPath relativePath = f.getFullPath().removeFirstSegments(segments);
                        String name = relativePath.toOSString();
                        if ((name = name.replace(File.pathSeparatorChar, '.')).endsWith(".")) {
                            name = name.substring(0, name.length() - 1);
                        }
                        IPackageFragment pkg = root.getPackageFragment(name);
                        fragments.add(pkg);
                    }
                }
                ++i;
            }
        }
        return fragments;
    }

    @Override
    protected void executeOperation() throws EGLModelException {
        this.updateProjectReferencesIfNecessary();
        this.saveEGLPathIfNecessary();
        EGLModelException originalException = null;
        try {
            try {
                EGLProject project = this.getProject();
                if (this.newRawPath == UpdateEGLPath) {
                    this.newRawPath = project.getRawEGLPath();
                }
                if (this.newRawPath != ReuseEGLPath) {
                    this.updateEGLPath();
                    project.updatePackageFragmentRoots();
                    EGLModelManager.getEGLModelManager().deltaProcessor.addForRefresh(project);
                }
            }
            catch (EGLModelException e) {
                originalException = e;
                throw e;
            }
        }
        finally {
            try {
                if (this.newOutputLocation != ReuseOutputLocation) {
                    this.updateOutputLocation();
                }
            }
            catch (EGLModelException e) {
                if (originalException != null) {
                    throw originalException;
                }
                throw e;
            }
        }
        this.done();
    }

    protected void generateEGLPathChangeDeltas(IEGLPathEntry[] oldResolvedPath, IEGLPathEntry[] newResolvedPath, EGLProject project) {
        int[] index;
        EGLModelManager manager = EGLModelManager.getEGLModelManager();
        boolean needToUpdateDependents = false;
        EGLElementDelta delta = new EGLElementDelta(this.getEGLModel());
        boolean hasDelta = false;
        int oldLength = oldResolvedPath.length;
        int newLength = newResolvedPath.length;
        Object indexManager = null;
        HashMap<IPath, IPackageFragmentRoot> oldRoots = null;
        IPackageFragmentRoot[] roots = null;
        if (project.isOpen()) {
            try {
                roots = project.getPackageFragmentRoots();
            }
            catch (EGLModelException eGLModelException) {}
        } else {
            Map allRemovedRoots = manager.deltaProcessor.removedRoots;
            if (allRemovedRoots != null) {
                roots = (IPackageFragmentRoot[])allRemovedRoots.get(project);
            }
        }
        if (roots != null) {
            oldRoots = new HashMap<IPath, IPackageFragmentRoot>();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                oldRoots.put(root.getPath(), root);
                ++i;
            }
        }
        int i = 0;
        while (i < oldLength) {
            index = this.eglpathContains(newResolvedPath, oldResolvedPath[i]);
            if (index.length == 0) {
                if (oldResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    IPackageFragmentRoot oldRoot;
                    Object[] pkgFragmentRoots = null;
                    if (oldRoots != null && (oldRoot = (IPackageFragmentRoot)oldRoots.get(oldResolvedPath[i].getPath())) != null) {
                        pkgFragmentRoots = new IPackageFragmentRoot[]{oldRoot};
                    }
                    if (pkgFragmentRoots == null) {
                        try {
                            ObjectVector accumulatedRoots = new ObjectVector();
                            HashSet<String> rootIDs = new HashSet<String>(5);
                            rootIDs.add(project.rootID());
                            project.computePackageFragmentRoots(oldResolvedPath[i], accumulatedRoots, rootIDs, true, false, false);
                            pkgFragmentRoots = new IPackageFragmentRoot[accumulatedRoots.size()];
                            accumulatedRoots.copyInto(pkgFragmentRoots);
                        }
                        catch (EGLModelException eGLModelException) {
                            pkgFragmentRoots = new IPackageFragmentRoot[]{};
                        }
                    }
                    this.addEGLPathDeltas((IPackageFragmentRoot[])pkgFragmentRoots, 128, delta);
                    int changeKind = oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3 || oldResolvedPath[i].isExported();
                    hasDelta = true;
                }
            } else if (oldResolvedPath[i].getEntryKind() == 2) {
                this.needCycleCheck |= oldResolvedPath[i].isExported() ^ newResolvedPath[index[0]].isExported();
            } else {
                needToUpdateDependents |= oldResolvedPath[i].isExported() ^ newResolvedPath[index[0]].isExported();
                if (!this.foundIndex(i, index)) {
                    this.addEGLPathDeltas(project.computePackageFragmentRoots(oldResolvedPath[i]), 256, delta);
                    int changeKind = oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3;
                    hasDelta = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < newLength) {
            index = this.eglpathContains(oldResolvedPath, newResolvedPath[i]);
            if (index.length == 0) {
                if (newResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    this.addEGLPathDeltas(project.computePackageFragmentRoots(newResolvedPath[i]), 64, delta);
                    int changeKind = newResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3 || newResolvedPath[i].isExported();
                    hasDelta = true;
                }
            }
            ++i;
        }
        if (hasDelta) {
            this.addDelta(delta);
        }
        if (needToUpdateDependents) {
            this.updateAffectedProjects(project.getProject().getFullPath());
        }
    }

    protected EGLProject getProject() {
        return (EGLProject)this.getElementsToProcess()[0];
    }

    @Override
    public boolean isReadOnly() {
        return !this.canChangeResource;
    }

    protected void saveEGLPathIfNecessary() throws EGLModelException {
        if (!this.canChangeResource || !this.needSave) {
            return;
        }
        EGLProject project = this.getProject();
        IEGLPathEntry[] eglpathForSave = this.newRawPath == ReuseEGLPath || this.newRawPath == UpdateEGLPath ? project.getRawEGLPath() : this.newRawPath;
        Object outputLocationForSave = this.newOutputLocation == ReuseOutputLocation ? (this.isProjectBinary(project) ? null : project.getOutputLocation(true)) : this.newOutputLocation;
        if (project.saveEGLPath(eglpathForSave, (IPath)outputLocationForSave)) {
            this.setAttribute("hasModifiedResource", "true");
        }
    }

    private boolean isProjectBinary(EGLProject proj) {
        IEGLProjectFileUtility util = EGLProjectFileUtilityLocator.INSTANCE.getUtil();
        if (util != null) {
            return util.isBinaryProject(proj.getProject());
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SetEGLPathOperation\n");
        buffer.append(" - eglpath : ");
        if (this.newRawPath == ReuseEGLPath) {
            buffer.append("<Reuse Existing EGLPath>");
        } else {
            buffer.append("{");
            int i = 0;
            while (i < this.newRawPath.length) {
                if (i > 0) {
                    buffer.append(",");
                }
                IEGLPathEntry element = this.newRawPath[i];
                buffer.append(" ").append(element.toString());
                ++i;
            }
        }
        buffer.append("\n - output location : ");
        if (this.newOutputLocation == ReuseOutputLocation) {
            buffer.append("<Reuse Existing Output Location>");
        } else {
            buffer.append(this.newOutputLocation.toString());
        }
        return buffer.toString();
    }

    private void updateEGLPath() throws EGLModelException {
        EGLProject project = (EGLProject)this.getElementsToProcess()[0];
        this.beginTask(EGLModelResources.bind((String)EGLModelResources.eglpathSettingProgress, (Object)project.getElementName()), 2);
        project.setRawEGLPath0(this.newRawPath);
        if (this.newResolvedPath == null) {
            this.newResolvedPath = project.getResolvedEGLPath(true, this.canChangeResource);
        }
        if (this.oldResolvedPath != null) {
            this.generateEGLPathChangeDeltas(this.oldResolvedPath, this.newResolvedPath, project);
        } else {
            this.needCycleCheck = true;
            this.updateAffectedProjects(project.getProject().getFullPath());
        }
        this.updateCycleMarkersIfNecessary(this.newResolvedPath);
    }

    protected void updateAffectedProjects(IPath prerequisiteProjectPath) {
        try {
            EGLModel model = EGLModelManager.getEGLModelManager().getEGLModel();
            EGLProject originatingProject = this.getProject();
            IEGLProject[] projects = model.getEGLProjects();
            int i = 0;
            int projectCount = projects.length;
            while (i < projectCount) {
                block7: {
                    try {
                        EGLProject project = (EGLProject)projects[i];
                        if (project.equals(originatingProject)) break block7;
                        IEGLPathEntry[] eglpath = project.getExpandedEGLPath(true);
                        int j = 0;
                        int entryCount = eglpath.length;
                        while (j < entryCount) {
                            IEGLPathEntry entry = eglpath[j];
                            if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)prerequisiteProjectPath)) {
                                project.setRawEGLPath(UpdateEGLPath, ReuseOutputLocation, this.fMonitor, this.canChangeResource, project.getResolvedEGLPath(true), false, false);
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (EGLModelException eGLModelException) {}
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
    }

    protected void updateCycleMarkersIfNecessary(IEGLPathEntry[] newResolvedPath) {
        if (!this.needCycleCheck) {
            return;
        }
        if (!this.canChangeResource) {
            return;
        }
        try {
            EGLProject project = this.getProject();
            if (!project.hasCycleMarker() && !project.hasEGLPathCycle(project.getResolvedEGLPath(true))) {
                return;
            }
            this.postAction(new EGLModelOperation.IPostAction(){

                @Override
                public String getID() {
                    return "updateCycleMarkers";
                }

                @Override
                public void run() throws EGLModelException {
                    EGLProject.updateAllCycleMarkers();
                }
            }, 2);
        }
        catch (EGLModelException eGLModelException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOutputLocation() throws EGLModelException {
        EGLModelManager.PerProjectInfo perProjectInfo;
        EGLProject project = (EGLProject)this.getElementsToProcess()[0];
        this.beginTask(EGLModelResources.bind((String)EGLModelResources.eglpathSettingProgress, (Object)project.getElementName()), 2);
        IPath oldLocation = project.getOutputLocation();
        boolean deltaToFire = false;
        EGLElementDelta delta = this.newEGLElementDelta();
        ArrayList added = this.determineAffectedPackageFragments(oldLocation);
        for (IPackageFragment frag : added) {
            ((IPackageFragmentRoot)frag.getParent()).close();
            if (Util.isExcluded(frag)) continue;
            delta.added(frag);
            deltaToFire = true;
        }
        ArrayList removed = this.determineAffectedPackageFragments(this.newOutputLocation);
        for (IPackageFragment frag : removed) {
            ((IPackageFragmentRoot)frag.getParent()).close();
            if (Util.isExcluded(frag)) continue;
            delta.removed(frag);
            deltaToFire = true;
        }
        EGLModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo = EGLModelManager.getEGLModelManager().getPerProjectInfoCheckExistence(project.getProject());
        synchronized (perProjectInfo2) {
            perProjectInfo.outputLocation = this.newOutputLocation;
        }
        if (deltaToFire) {
            this.addDelta(delta);
        }
        this.worked(1);
    }

    protected void updateProjectReferencesIfNecessary() throws EGLModelException {
        if (!this.canChangeResource) {
            return;
        }
        if (this.newRawPath == ReuseEGLPath || this.newRawPath == UpdateEGLPath) {
            return;
        }
        EGLProject jproject = this.getProject();
        String[] oldRequired = jproject.projectPrerequisites(this.oldResolvedPath);
        if (this.newResolvedPath == null) {
            this.newResolvedPath = jproject.getResolvedEGLPath(this.newRawPath, null, true, this.needValidation, null);
        }
        String[] newRequired = jproject.projectPrerequisites(this.newResolvedPath);
        try {
            int newSize;
            HashSet newReferences;
            IProjectDescription description;
            IProject project;
            block13: {
                String projectName;
                project = jproject.getProject();
                description = project.getDescription();
                IProject[] projectReferences = description.getReferencedProjects();
                HashSet<String> oldReferences = new HashSet<String>(projectReferences.length);
                int i = 0;
                while (i < projectReferences.length) {
                    String projectName2 = projectReferences[i].getName();
                    oldReferences.add(projectName2);
                    ++i;
                }
                newReferences = (HashSet)oldReferences.clone();
                int i2 = 0;
                while (i2 < oldRequired.length) {
                    projectName = oldRequired[i2];
                    newReferences.remove(projectName);
                    ++i2;
                }
                i2 = 0;
                while (i2 < newRequired.length) {
                    projectName = newRequired[i2];
                    newReferences.add(projectName);
                    ++i2;
                }
                newSize = newReferences.size();
                if (oldReferences.size() == newSize) {
                    Iterator iter = newReferences.iterator();
                    while (iter.hasNext()) {
                        if (oldReferences.contains(iter.next())) {
                            continue;
                        }
                        break block13;
                    }
                    return;
                }
            }
            String[] requiredProjectNames = new String[newSize];
            int index = 0;
            Iterator iter = newReferences.iterator();
            while (iter.hasNext()) {
                requiredProjectNames[index++] = (String)iter.next();
            }
            Util.sort(requiredProjectNames);
            IProject[] requiredProjectArray = new IProject[newSize];
            IWorkspaceRoot wksRoot = project.getWorkspace().getRoot();
            int i = 0;
            while (i < newSize) {
                requiredProjectArray[i] = wksRoot.getProject(requiredProjectNames[i]);
                ++i;
            }
            description.setReferencedProjects(requiredProjectArray);
            project.setDescription(description, this.fMonitor);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    @Override
    public IEGLModelStatus verify() {
        IEGLModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.needValidation) {
            IPath outputLocation;
            IEGLProject project = (IEGLProject)this.getElementToProcess();
            IEGLPathEntry[] entries = this.newRawPath;
            if (entries == ReuseEGLPath) {
                try {
                    entries = project.getRawEGLPath();
                }
                catch (EGLModelException e) {
                    return e.getEGLModelStatus();
                }
            }
            if ((outputLocation = this.newOutputLocation) == ReuseOutputLocation) {
                try {
                    outputLocation = project.getOutputLocation();
                }
                catch (EGLModelException e) {
                    return e.getEGLModelStatus();
                }
            }
            return EGLConventions.validateEGLPath(project, entries, outputLocation);
        }
        return EGLModelStatus.VERIFIED_OK;
    }
}

