/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.ui.internal.deployment.Bindings;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingProviderRegistry;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardProvider;
import org.eclipse.edt.ide.ui.wizards.BindingBaseConfiguration;
import org.eclipse.edt.ide.ui.wizards.BindingEGLConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPartConfiguration;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IWorkbench;

public class EGLDDBindingConfiguration
extends EGLPartConfiguration {
    private int fBindingType;
    private BindingEGLConfiguration fBindingEGLConfig;
    private IWorkbench fWorkbench;
    private IProject fProj;
    private EGLDeploymentRoot fDeploymentRoot;

    public void init(IWorkbench workbench, IProject proj, EGLDeploymentRoot root) {
        this.fWorkbench = workbench;
        this.fProj = proj;
        this.fDeploymentRoot = root;
    }

    public int getBindingType() {
        return this.fBindingType;
    }

    public void setBindingType(int bindingType) {
        this.fBindingType = bindingType;
    }

    public EGLDeploymentRoot getDeploymentRoot() {
        return this.fDeploymentRoot;
    }

    public BindingEGLConfiguration getBindingEGLConfiguration() {
        if (this.fBindingEGLConfig == null) {
            this.fBindingEGLConfig = new BindingEGLConfiguration(this.fDeploymentRoot, this.fProj);
        }
        return this.fBindingEGLConfig;
    }

    public BindingBaseConfiguration getConfiguration(String providerId) {
        EGLDDBindingWizardProvider[] providers = EGLDDBindingProviderRegistry.singleton.getEGLDDBindingWizardProviders();
        int i = 0;
        while (i < providers.length) {
            if (providers[i].id.equals(providerId)) {
                return providers[i].bindingconfigurationClass;
            }
            ++i;
        }
        return null;
    }

    private Bindings getBindings() {
        Deployment deployment = this.fDeploymentRoot.getDeployment();
        Bindings bindings = deployment.getBindings();
        if (bindings == null) {
            bindings = DeploymentFactory.eINSTANCE.createBindings();
            deployment.setBindings(bindings);
        }
        return bindings;
    }

    public Object executeAddBinding(IRunnableContext runnableContext) throws InvocationTargetException, InterruptedException {
        Bindings bindings = this.getBindings();
        Object newBinding = null;
        EGLDDBindingWizardProvider[] fproviders = EGLDDBindingProviderRegistry.singleton.getEGLDDBindingWizardProviders();
        int i = 0;
        while (i < fproviders.length) {
            if (fproviders[i].bindingId == this.fBindingType) {
                newBinding = fproviders[i].bindingconfigurationClass.executeAddBinding(bindings);
                break;
            }
            ++i;
        }
        return newBinding;
    }
}

