/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.templates.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.edt.ide.ui.internal.project.wizards.WizardNode;
import org.eclipse.edt.ide.ui.templates.ITemplate;
import org.eclipse.edt.ide.ui.templates.wizards.ITemplateWizard;
import org.eclipse.jface.wizard.IWizard;

public class TemplateWizardNode
extends WizardNode {
    private IConfigurationElement configElement;
    private IWizard parentWizard;
    private ITemplate template;

    public TemplateWizardNode(ITemplate template, IConfigurationElement configElement) {
        this.template = template;
        this.configElement = configElement;
    }

    @Override
    protected IWizard createWizard() throws CoreException {
        try {
            IWizard wiz = (IWizard)this.configElement.createExecutableExtension("wizardClass");
            if (wiz instanceof ITemplateWizard) {
                ((ITemplateWizard)wiz).setParentWizard(this.parentWizard);
                ((ITemplateWizard)wiz).setTemplate(this.template);
            }
            return wiz;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public IWizard getParentWizard() {
        return this.parentWizard;
    }

    public void setParentWizard(IWizard parentWizard) {
        this.parentWizard = parentWizard;
        if (this.isContentCreated()) {
            ((ITemplateWizard)this.getWizard()).setParentWizard(parentWizard);
        }
    }

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    public ITemplate getTemplate() {
        return this.template;
    }
}

