/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring;

import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DeleteRefactoringWizard
extends RefactoringWizard {
    Object[] elements;
    String pageTitle = "";
    String elementMessage = "";

    public DeleteRefactoringWizard(DeleteRefactoring refactoring, Object[] elements) {
        super((Refactoring)refactoring, 92);
        this.elements = elements;
    }

    protected void addUserInputPages() {
        this.setStrings();
        this.setDefaultPageTitle(this.pageTitle);
        this.addPage((IWizardPage)new DeleteInputPage(this.elementMessage));
    }

    private void setStrings() {
        String elementType = "";
        if (this.elements[0] instanceof IEGLElement) {
            switch (((IEGLElement)this.elements[0]).getElementType()) {
                case 6: {
                    elementType = UINlsStrings.EGLDeleteDialogElementTypeEGLFile;
                    break;
                }
                case 4: {
                    elementType = UINlsStrings.EGLDeleteDialogElementTypeEGLPackage;
                    break;
                }
                case 3: {
                    elementType = UINlsStrings.EGLDeleteDialogElementTypeEGLSourceFolder;
                    break;
                }
                default: {
                    elementType = UINlsStrings.EGLDeleteDialogElementTypeResource;
                }
            }
            this.elementMessage = this.elements.length == 1 ? NewWizardMessages.bind((String)UINlsStrings.EGLDeleteDialogMessageSingular, (Object)((IEGLElement)this.elements[0]).getElementName()) : NewWizardMessages.bind((String)UINlsStrings.EGLDeleteDialogMessagePlural, (Object)String.valueOf(this.elements.length));
        } else {
            elementType = UINlsStrings.EGLDeleteDialogElementTypeResource;
        }
        this.pageTitle = NewWizardMessages.bind((String)UINlsStrings.EGLDeleteDialogAction, (Object)elementType);
    }

    public boolean needsProgressMonitor() {
        return super.needsProgressMonitor();
    }

    private static class DeleteInputPage
    extends UserInputWizardPage {
        String labelText;

        public DeleteInputPage(String labelText) {
            super("EGL Delete");
            this.labelText = labelText;
        }

        public void createControl(Composite parent) {
            Composite composite = this.createRootComposite(parent);
            this.setControl((Control)composite);
            this.createLabel(composite);
        }

        private Composite createRootComposite(Composite parent) {
            Composite result = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 10;
            gridLayout.marginHeight = 10;
            result.setLayout((Layout)gridLayout);
            this.initializeDialogUnits((Control)result);
            Dialog.applyDialogFont((Control)result);
            return result;
        }

        private void createLabel(Composite composite) {
            Image image = Display.getCurrent().getSystemImage(4);
            Label label = new Label(composite, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
            Label lblNewName = new Label(composite, 0);
            lblNewName.setText(this.labelText);
        }
    }
}

