/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizardMessages;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizardPage;
import org.eclipse.edt.ide.ui.internal.record.RecordConfiguration;
import org.eclipse.edt.ide.ui.internal.record.RecordOperation;
import org.eclipse.edt.ide.ui.internal.wizards.EGLFileWizard;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizardNode;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.edt.ide.ui.wizards.PartTemplateException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class NewRecordWizard
extends EGLFileWizard {
    private static final String WIZPAGENAME_RecordWizardPage = "WIZPAGENAME_RecordWizardPage";
    private NewRecordWizardPage mainPage;
    private ISelection selection;
    private Object contentObj;

    public NewRecordWizard() {
        this.setWindowTitle(NewRecordWizardMessages.NewRecordWizard_title);
    }

    @Override
    public void addPages() {
        this.mainPage = new NewRecordWizardPage(this.selection, WIZPAGENAME_RecordWizardPage);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    @Override
    public boolean performFinish() {
        TemplateWizardNode twn;
        IWizardNode node;
        if (!super.performFinish()) {
            return false;
        }
        IWizard wizard = this.getContainer().getCurrentPage().getWizard();
        if (wizard instanceof NewRecordWizard && (node = this.mainPage.getSelectedNode()) instanceof TemplateWizardNode && (twn = (TemplateWizardNode)node).getTemplate().hasWizard() && !twn.getWizard().performFinish()) {
            return false;
        }
        IRunnableWithProgress operation = this.getOperation();
        try {
            this.getContainer().run(false, true, operation);
        }
        catch (InterruptedException e) {
            boolean dialogResult = false;
            if (e.getMessage().indexOf(58) != -1) {
                PartTemplateException pe = new PartTemplateException(e.getMessage());
                if (pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_NOT_FOUND) == 0) {
                    dialogResult = ((EGLPartWizardPage)this.getPage(WIZPAGENAME_RecordWizardPage)).handleTemplateError(pe.getPartType(), pe.getPartDescription());
                } else if (pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_DISABLED) != 0 && pe.getTemplateExcpetion().compareTo(EGLFileConfiguration.TEMPLATE_CORRUPTED) == 0) {
                    dialogResult = ((EGLPartWizardPage)this.getPage(WIZPAGENAME_RecordWizardPage)).handleTemplateError(pe.getPartType(), pe.getPartDescription());
                }
                if (dialogResult) {
                    return this.performFinish();
                }
                return false;
            }
            EGLLogger.log((Object)this, e);
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                EGLLogger.log((Object)this, e);
            }
            return false;
        }
        this.openResource(this.configuration.getFile());
        return true;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.getConfiguration().init(workbench, selection);
    }

    public void setContentObj(Object obj) {
        this.contentObj = obj;
    }

    @Override
    public EGLPackageConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new RecordConfiguration();
        }
        return this.configuration;
    }

    protected IRunnableWithProgress getOperation() {
        TemplateWizardNode twn;
        String codeTemplateId = null;
        IWizardNode node = this.mainPage.getSelectedNode();
        if (node instanceof TemplateWizardNode && !(twn = (TemplateWizardNode)node).getTemplate().hasWizard() && twn.getTemplate().getCodeTemplateId() != null) {
            codeTemplateId = twn.getTemplate().getCodeTemplateId();
        }
        return new RecordOperation((RecordConfiguration)this.getConfiguration(), codeTemplateId, this.contentObj);
    }
}

