/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Category;
import org.eclipse.edt.ide.ui.internal.formatting.profile.DefaultProfile;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Preference;
import org.eclipse.edt.ide.ui.internal.formatting.profile.ProfilePackage;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ModifyDialog;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ModifyDialogTabPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.part.PageBook;

public class WhiteSpaceTabPage
extends ModifyDialogTabPage {
    private final SwitchComponent fSwitchComponent;
    protected final IDialogSettings fDialogSettings = EDTUIPlugin.getDefault().getDialogSettings();

    public WhiteSpaceTabPage(ModifyDialog modifyDialog, DefaultProfile defaultProfile, Category category, Map allPreferenceSettings) {
        super(modifyDialog, defaultProfile, category, allPreferenceSettings);
        this.fSwitchComponent = new SwitchComponent();
    }

    @Override
    protected void initializePage() {
        this.fSwitchComponent.initialize();
    }

    @Override
    protected void createTreePref(Preference pref) {
        this.fSwitchComponent.populatePreferenceMapData(pref);
    }

    @Override
    protected ModifyDialogTabPage.ComboPreference createComboPref(Composite composite, int numColumns, String labelText, String categoryID, String prefID, String[] values, String[] items, String previewTextPerPreference) {
        ModifyDialogTabPage.ComboPreference comboPref = super.createComboPref(composite, numColumns, labelText, categoryID, prefID, values, items, previewTextPerPreference);
        this.fSwitchComponent.createContents(numColumns, composite, (Combo)comboPref.getControl());
        return comboPref;
    }

    private final class SwitchComponent
    extends SelectionAdapter {
        private Combo fSwitchCombo;
        private PageBook fPageBook;
        private final WSOptionNodeComponent fWSPosComponent;
        private final WSOptionNodeComponent fEGLSyntaxElemComponent;
        private static final String PREF_WSPos_KEY = "org.eclipse.edt.ide.uiformatter_page.white_space_wspos_view.node";
        private static final String PREF_EGLSyn_KEY = "org.eclipse.edt.ide.uiformatter_page.white_space_egl_view.node";

        public SwitchComponent() {
            this.fWSPosComponent = new WSOptionNodeComponent(PREF_WSPos_KEY);
            this.fEGLSyntaxElemComponent = new WSOptionNodeComponent(PREF_EGLSyn_KEY);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.fSwitchCombo.getSelectionIndex();
            switch (index) {
                case 0: {
                    this.fWSPosComponent.refreshState();
                    this.fPageBook.showPage(this.fWSPosComponent.getControl());
                    break;
                }
                case 1: {
                    this.fEGLSyntaxElemComponent.refreshState();
                    this.fPageBook.showPage(this.fEGLSyntaxElemComponent.getControl());
                }
            }
        }

        public void createContents(int numColumns, Composite parent, Combo switchCombo) {
            this.fPageBook = new PageBook(parent, 0);
            this.fPageBook.setLayoutData((Object)WhiteSpaceTabPage.createGridData(numColumns, 1808, -1));
            this.fWSPosComponent.createContents(numColumns, (Composite)this.fPageBook);
            this.fEGLSyntaxElemComponent.createContents(numColumns, (Composite)this.fPageBook);
            this.fSwitchCombo = switchCombo;
        }

        public void initialize() {
            this.fSwitchCombo.addSelectionListener((SelectionListener)this);
            this.fWSPosComponent.initialize();
            this.fEGLSyntaxElemComponent.initialize();
            this.restoreSelection();
        }

        public void populatePreferenceMapData(Preference pref) {
            this.fWSPosComponent.populatePreferenceMapData(pref, ProfilePackage.eINSTANCE.getPreference_Display());
            this.fEGLSyntaxElemComponent.populatePreferenceMapData(pref, ProfilePackage.eINSTANCE.getPreference_AltDisplay());
        }

        private void restoreSelection() {
            int selectWSPos = Integer.parseInt(WhiteSpaceTabPage.this.getCurrentValue("whiteSpace.sortBy"));
            this.fSwitchCombo.select(selectWSPos);
            switch (selectWSPos) {
                case 0: {
                    this.fWSPosComponent.refreshState();
                    this.fPageBook.showPage(this.fWSPosComponent.getControl());
                    break;
                }
                case 1: {
                    this.fEGLSyntaxElemComponent.refreshState();
                    this.fPageBook.showPage(this.fEGLSyntaxElemComponent.getControl());
                }
            }
        }
    }

    private class WSOptionNodeComponent
    extends ModifyDialogTabPage.TreeControlPreference
    implements ICheckStateListener {
        private Composite fComposite;

        public WSOptionNodeComponent(String dlgSettingKey) {
            super(WhiteSpaceTabPage.this.fDialogSettings, dlgSettingKey);
        }

        @Override
        public void createContents(int numColumns, Composite parent) {
            this.fComposite = new Composite(parent, 0);
            this.fComposite.setLayoutData((Object)WhiteSpaceTabPage.createGridData(numColumns, 256, -1));
            this.fComposite.setLayout((Layout)WhiteSpaceTabPage.this.createGridLayout(numColumns, false));
            super.createContents(numColumns, this.fComposite);
        }

        @Override
        protected TreeViewer createTreeViewer(Composite composite, int numColumns) {
            return new ContainerCheckedTreeViewer(this.fComposite, 2564);
        }

        @Override
        public void initialize() {
            ((ContainerCheckedTreeViewer)this.fTreeViewer).addCheckStateListener((ICheckStateListener)this);
            super.initialize();
            this.refreshState();
        }

        public void refreshState() {
            ContainerCheckedTreeViewer checkedTreeViewer = (ContainerCheckedTreeViewer)this.fTreeViewer;
            List checked = this.getCheckElements(this.fOptionNodePreferenceTreeMap);
            checkedTreeViewer.setGrayedElements(new Object[0]);
            checkedTreeViewer.setCheckedElements(checked.toArray());
            WhiteSpaceTabPage.this.fPreview.setPreviewText("");
            if (this.fLastSelected != null) {
                WhiteSpaceTabPage.this.fPreview.setPreviewText(this.getPreviewText(this.fLastSelected));
            }
            WhiteSpaceTabPage.this.doUpdatePreview();
        }

        private List getCheckElements(Map map) {
            ArrayList<ModifyDialogTabPage.OptionLeafNode> checked = new ArrayList<ModifyDialogTabPage.OptionLeafNode>(100);
            for (Object val : map.values()) {
                if (val instanceof ModifyDialogTabPage.OptionTreeNode) {
                    ModifyDialogTabPage.OptionTreeNode wsnode = (ModifyDialogTabPage.OptionTreeNode)val;
                    checked.addAll(this.getCheckElements(wsnode.getChildren()));
                    continue;
                }
                if (!(val instanceof ModifyDialogTabPage.OptionLeafNode)) continue;
                ModifyDialogTabPage.OptionLeafNode optionLeafNode = (ModifyDialogTabPage.OptionLeafNode)val;
                if (!Boolean.parseBoolean(WhiteSpaceTabPage.this.getCurrentValue(optionLeafNode.fPreferenceKey))) continue;
                checked.add(optionLeafNode);
            }
            return checked;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object obj = event.getElement();
            String currValue = Boolean.toString(event.getChecked());
            this.changeCheckState(obj, currValue);
            WhiteSpaceTabPage.this.doUpdatePreview();
            WhiteSpaceTabPage.this.notifyValuesModified();
        }

        private void changeCheckState(Object obj, String currStateValue) {
            if (obj instanceof ModifyDialogTabPage.OptionTreeNode) {
                ModifyDialogTabPage.OptionTreeNode wsnode = (ModifyDialogTabPage.OptionTreeNode)obj;
                Iterator it = wsnode.getChildren().values().iterator();
                while (it.hasNext()) {
                    this.changeCheckState(it.next(), currStateValue);
                }
            } else if (obj instanceof ModifyDialogTabPage.OptionLeafNode) {
                ModifyDialogTabPage.OptionLeafNode optNode = (ModifyDialogTabPage.OptionLeafNode)obj;
                WhiteSpaceTabPage.this.setCurrentValue(optNode.fPreferenceKey, currStateValue);
            }
        }

        public Control getControl() {
            return this.fComposite;
        }
    }
}

