/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting.ui;

import java.util.List;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Profile;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ProfileManager;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateProfileDialog
extends StatusDialog {
    private static final String PREF_OPEN_EDIT_DIALOG = "org.eclipse.edt.ide.ui.codeformatter.create_profile_dialog.open_edit";
    private Text fNameText;
    private Combo fProfileCombo;
    private Button fEditCheckbox;
    private static final StatusInfo fOk = new StatusInfo();
    private static final StatusInfo fEmpty = new StatusInfo(4, NewWizardMessages.Err_EmptyFormatProfileName);
    private static final StatusInfo fDuplicate = new StatusInfo(4, NewWizardMessages.Err_DuplicateFormatProfileName);
    private final ProfileManager fProfileManager;
    private final List fSortedProfiles;
    private final String[] fSortedNames;
    private Profile fCreatedProfile;
    protected boolean fOpenEditDialog;

    public CreateProfileDialog(Shell parentShell, ProfileManager profileManager) {
        super(parentShell);
        this.fProfileManager = profileManager;
        this.fSortedProfiles = this.fProfileManager.getAllProfiles();
        this.fSortedNames = this.fProfileManager.getAllProfileDisplayNames();
    }

    public void create() {
        super.create();
        this.setTitle(NewWizardMessages.NewCodeFormatterProfile);
    }

    public Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Label nameLabel = new Label(composite, 64);
        nameLabel.setText(NewWizardMessages.ProfileName);
        nameLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fNameText = new Text(composite, 2052);
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateProfileDialog.this.doValidation();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        Label profileLabel = new Label(composite, 64);
        profileLabel.setText(NewWizardMessages.InitProfileSetting);
        profileLabel.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProfileCombo = new Combo(composite, 12);
        this.fProfileCombo.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fEditCheckbox = new Button(composite, 32);
        this.fEditCheckbox.setText(NewWizardMessages.OpenEditDlg);
        this.fEditCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateProfileDialog.this.fOpenEditDialog = ((Button)e.widget).getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        IDialogSettings dialogSettings = EDTUIPlugin.getDefault().getDialogSettings();
        this.fOpenEditDialog = dialogSettings.get(PREF_OPEN_EDIT_DIALOG) != null ? dialogSettings.getBoolean(PREF_OPEN_EDIT_DIALOG) : true;
        this.fEditCheckbox.setSelection(this.fOpenEditDialog);
        this.fProfileCombo.setItems(this.fSortedNames);
        this.fProfileCombo.setText(this.fSortedNames[0]);
        this.updateStatus(fEmpty);
        CreateProfileDialog.applyDialogFont((Control)composite);
        this.fNameText.setFocus();
        return composite;
    }

    protected void doValidation() {
        String name = this.fNameText.getText().trim();
        if (this.fProfileManager.containsProfile(name)) {
            this.updateStatus(fDuplicate);
            return;
        }
        if (name.length() == 0) {
            this.updateStatus(fEmpty);
            return;
        }
        this.updateStatus(fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        EDTUIPlugin.getDefault().getDialogSettings().put(PREF_OPEN_EDIT_DIALOG, this.fOpenEditDialog);
        String newProfileName = this.fNameText.getText();
        Object baseProfile = this.fSortedProfiles.get(this.fProfileCombo.getSelectionIndex());
        this.fCreatedProfile = this.fProfileManager.createNewProfile(newProfileName, baseProfile, true);
        super.okPressed();
    }

    public final Profile getCreatedProfile() {
        return this.fCreatedProfile;
    }

    public final boolean openEditDialog() {
        return this.fOpenEditDialog;
    }
}

