/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.externaltype.wizards.javatype;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusUtil;
import org.eclipse.edt.ide.ui.internal.externaltype.NewExternalTypeWizardMessages;
import org.eclipse.edt.ide.ui.internal.externaltype.conversion.javatype.JavaTypeConstants;
import org.eclipse.edt.ide.ui.internal.externaltype.util.ReflectionUtil;
import org.eclipse.edt.ide.ui.internal.externaltype.wizards.javatype.ExternalTypeFromJavaWizardConfiguration;
import org.eclipse.edt.ide.ui.internal.externaltype.wizards.javatype.JavaType;
import org.eclipse.edt.ide.ui.internal.util.SWTUtil;
import org.eclipse.edt.ide.ui.internal.util.ViewerPane;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPackageWizard;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizard;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ExternalTypeFromJavaPage
extends WizardPage
implements ICheckStateListener {
    private static final String WIZPAGENAME_ExternalTypeWizardPage = "WIZPAGENAME_ExternalTypeFromJavaPage";
    private IStatus fCurrStatus;
    private boolean fPageVisible;
    private StatusInfo memberStatus;
    private Button generatedAllSuperTypesCheckbox;
    private Button generatedAllReferencedTypesCheckbox;
    private StringButtonDialogField fSelectedClassDialogField;
    private CheckboxTreeViewer javaTypeViewer;
    private Object fInput;
    private ITreeContentProvider fContentProvider;
    private ExternalTypeFromJavaWizardConfiguration configuration;
    private IJavaProject javaProject;
    private URLClassLoader urlClassLoader;
    private ExternalTypeCustomValidator fValidator = new ExternalTypeCustomValidator();

    public ExternalTypeFromJavaPage(ExternalTypeFromJavaWizardConfiguration config) {
        super(WIZPAGENAME_ExternalTypeWizardPage);
        this.setTitle(NewExternalTypeWizardMessages.ExternalTypeFromJavaTypePage_Title);
        this.setDescription(NewExternalTypeWizardMessages.ExternalTypeFromJavaTypePage_Description);
        this.setPageComplete(false);
        this.configuration = config;
        TypeFieldsAdapter adapter = new TypeFieldsAdapter();
        this.fSelectedClassDialogField = new StringButtonDialogField(adapter);
        this.fSelectedClassDialogField.setDialogFieldListener(adapter);
        this.fSelectedClassDialogField.setLabelText(this.getSuperClassLabel());
        this.fSelectedClassDialogField.setButtonLabel(NewExternalTypeWizardMessages.NewExternalTypeWizardPage_selectedclass_button);
        this.fInput = null;
        this.fPageVisible = false;
        this.fCurrStatus = new StatusInfo();
        this.memberStatus = new StatusInfo();
    }

    private IJavaProject getJavaProject() {
        if (this.javaProject == null) {
            TemplateWizard wizard = (TemplateWizard)this.getWizard();
            EGLPackageWizard parentWizard = (EGLPackageWizard)wizard.getParentWizard();
            String projectName = parentWizard.getConfiguration().getProjectName();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            this.javaProject = JavaCore.create((IProject)project);
        }
        return this.javaProject;
    }

    private ClassLoader getURLClassLoader() {
        if (this.urlClassLoader == null) {
            ArrayList<URL> classPathURLs = new ArrayList<URL>();
            try {
                IPackageFragmentRoot[] roots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = this.javaProject.getAllPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot pRoot = iPackageFragmentRootArray[n2];
                    IJavaProject refProject = pRoot.getParent().getJavaProject();
                    IPath proRoot = refProject.getProject().getLocation();
                    if (pRoot.isArchive() && pRoot.isExternal()) {
                        classPathURLs.add(pRoot.getResolvedClasspathEntry().getPath().toFile().toURI().toURL());
                    } else if (pRoot.isArchive() && pRoot.getResource() != null) {
                        classPathURLs.add(proRoot.append(pRoot.getResource().getProjectRelativePath()).toFile().toURI().toURL());
                    } else {
                        IPath outputRelPath = refProject.getOutputLocation().removeFirstSegments(1);
                        classPathURLs.add(proRoot.append(outputRelPath).toFile().toURI().toURL());
                    }
                    ++n2;
                }
            }
            catch (Throwable ee) {
                ee.printStackTrace();
            }
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            URL[] urlPaths = new URL[classPathURLs.size()];
            this.urlClassLoader = new URLClassLoader(classPathURLs.toArray(urlPaths), parent);
        }
        return this.urlClassLoader;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createSelectedClassControls(composite, nColumns);
        this.createTreeViewer(composite, 3);
        this.createSelectionButtons(composite, 1);
        this.generatedAllSuperTypesCheckbox = new Button(composite, 32);
        this.generatedAllSuperTypesCheckbox.setText(NewExternalTypeWizardMessages.NewExternalTypeWizardPage_GeneratedAllSuperTypes_message);
        GridData data = new GridData();
        data.horizontalSpan = nColumns;
        this.generatedAllSuperTypesCheckbox.setLayoutData((Object)data);
        this.generatedAllSuperTypesCheckbox.setSelection(true);
        this.generatedAllSuperTypesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.widget).getSelection();
                ExternalTypeFromJavaPage.this.configuration.setAllSuperTypesGenerated(isSelected);
            }
        });
        this.generatedAllReferencedTypesCheckbox = new Button(composite, 32);
        this.generatedAllReferencedTypesCheckbox.setText(NewExternalTypeWizardMessages.NewExternalTypeWizardPage_GeneratedAllReferencedTypes_message);
        data = new GridData();
        data.horizontalSpan = nColumns;
        this.generatedAllReferencedTypesCheckbox.setLayoutData((Object)data);
        this.generatedAllReferencedTypesCheckbox.setSelection(true);
        this.generatedAllReferencedTypesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.widget).getSelection();
                ExternalTypeFromJavaPage.this.configuration.setAllReferencedTypesGenerated(isSelected);
            }
        });
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
        this.getJavaProject();
    }

    protected void createSelectedClassControls(Composite composite, int nColumns) {
        this.fSelectedClassDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fSelectedClassDialogField.getTextControl(null);
        text.setEnabled(false);
        LayoutUtil.setWidthHint((Control)text, this.getMaxFieldWidth());
    }

    protected String getSuperClassLabel() {
        return NewExternalTypeWizardMessages.ExternalTypeFromJavaPage_SelectedClass_label;
    }

    public ExternalTypeCustomValidator getValidator() {
        return this.fValidator;
    }

    private void typePageChangeControlPressed(DialogField field) {
        IType type;
        if (field == this.fSelectedClassDialogField && (type = this.chooseSelectedClass()) != null) {
            String fullPath = type.getFullyQualifiedName();
            if (JavaTypeConstants.JavaToEglMapping.containsKey(fullPath)) {
                this.memberStatus.setError(NewExternalTypeWizardMessages.bind((String)NewExternalTypeWizardMessages.ExternalTypeFromJavaPage_Validation_EGLBuiltinType, (Object[])new String[]{fullPath}));
                this.updateStatus(this.memberStatus);
            } else {
                this.fSelectedClassDialogField.setText(fullPath);
                this.configuration.setSelectedClazz(ReflectionUtil.getClass(this.getURLClassLoader(), fullPath));
                this.javaTypeViewer.setInput((Object)fullPath);
                this.storeSelectedClass();
                this.validatePage();
            }
        }
    }

    private void typePageDialogFieldChanged(DialogField field) {
    }

    protected IType chooseSelectedClass() {
        if (this.getJavaProject() == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{this.javaProject};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        TypeSelectionExtension fExtension = new TypeSelectionExtension(){

            public ISelectionStatusValidator getSelectionValidator() {
                return ExternalTypeFromJavaPage.this.getValidator();
            }
        };
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 10, fExtension);
        dialog.setTitle(NewExternalTypeWizardMessages.NewExternalTypeWizardPage_SelectedClassDialog_title);
        dialog.setMessage(NewExternalTypeWizardMessages.NewExternalTypeWizardPage_SelectedClassDialog_message);
        dialog.setInitialPattern(this.getSelectedClass());
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    public String getSelectedClass() {
        return this.fSelectedClassDialogField.getText();
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(40);
    }

    protected void createTreeViewer(Composite parent, int nColumns) {
        this.initializeDialogUnits((Control)parent);
        ViewerPane pane = new ViewerPane(parent, 0x800800);
        pane.setText(NewExternalTypeWizardMessages.NewExternalTypeWizardPage_PaneTitle_message);
        this.javaTypeViewer = new CheckboxTreeViewer((Composite)pane);
        this.fContentProvider = new ExternalTypeContentProvider();
        this.javaTypeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.javaTypeViewer.setLabelProvider((IBaseLabelProvider)new ExternalTypeLabelProvider());
        this.javaTypeViewer.setInput(this.fInput);
        pane.setContent(this.javaTypeViewer.getControl());
        this.javaTypeViewer.addCheckStateListener((ICheckStateListener)this);
        GridLayout paneLayout = new GridLayout();
        paneLayout.marginHeight = 0;
        paneLayout.marginWidth = 0;
        pane.setLayout((Layout)paneLayout);
        GridData gd = new GridData(1808);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = nColumns;
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        pane.setLayoutData(gd);
        ToolBarManager manager = pane.getToolBarManager();
        manager.update(true);
        this.javaTypeViewer.getTree().setFocus();
    }

    protected Composite createSelectionButtons(Composite parent, int nColumns) {
        Composite buttonComposite = new Composite(parent, 131072);
        buttonComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        GridData gd = new GridData(272);
        gd.horizontalSpan = nColumns;
        buttonComposite.setLayoutData((Object)gd);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] viewerElements = ExternalTypeFromJavaPage.this.fContentProvider.getElements(ExternalTypeFromJavaPage.this.fInput);
                int i = 0;
                while (i < viewerElements.length) {
                    ExternalTypeFromJavaPage.this.javaTypeViewer.setSubtreeChecked(viewerElements[i], true);
                    ++i;
                }
                ExternalTypeFromJavaPage.this.storeSelectedClass();
                ExternalTypeFromJavaPage.this.validatePage();
            }
        };
        this.createButton(buttonComposite, NewExternalTypeWizardMessages.NewExternalTypeWizardPage_SelectAll_message, (SelectionListener)listener);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalTypeFromJavaPage.this.javaTypeViewer.setCheckedElements(new Object[0]);
                ExternalTypeFromJavaPage.this.storeSelectedClass();
                ExternalTypeFromJavaPage.this.validatePage();
            }
        };
        this.createButton(buttonComposite, NewExternalTypeWizardMessages.NewExternalTypeWizardPage_DeSelectAll_message, (SelectionListener)listener);
        return buttonComposite;
    }

    protected Button createButton(Composite parent, String label, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        button.addSelectionListener(listener);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 1;
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getSource() == this.javaTypeViewer) {
            if (event.getChecked()) {
                this.javaTypeViewer.setSubtreeChecked(event.getElement(), true);
            } else {
                this.javaTypeViewer.setSubtreeChecked(event.getElement(), false);
            }
            this.storeSelectedClass();
        }
        this.validatePage();
    }

    private void storeSelectedClass() {
        List<Method> selectedMethods = this.handleMethodsSelected();
        List<Constructor<?>> selectedCons = this.handleConstructorsSelected();
        List<Field> selectedFields = this.handleFieldsSelected();
        JavaType javaType = this.configuration.getToBeGenerated().get(this.configuration.getSelectedClazz());
        if (javaType == null) {
            javaType = new JavaType();
            javaType.setSource(0);
        }
        javaType.setFields(selectedFields);
        javaType.setConstructors(selectedCons);
        javaType.setMethods(selectedMethods);
        this.configuration.getToBeGenerated().put(this.configuration.getSelectedClazz(), javaType);
    }

    private List<Field> handleFieldsSelected() {
        ArrayList<Field> selectedFields = new ArrayList<Field>();
        Object[] objectArray = this.javaTypeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Field) {
                selectedFields.add((Field)o);
            }
            ++n2;
        }
        return selectedFields;
    }

    private List<Method> handleMethodsSelected() {
        ArrayList<Method> selectedMethods = new ArrayList<Method>();
        Object[] objectArray = this.javaTypeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Method) {
                selectedMethods.add((Method)o);
            }
            ++n2;
        }
        return selectedMethods;
    }

    private List<Constructor<?>> handleConstructorsSelected() {
        ArrayList selectedCons = new ArrayList();
        Object[] objectArray = this.javaTypeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Constructor) {
                selectedCons.add((Constructor)o);
            }
            ++n2;
        }
        return selectedCons;
    }

    private void validatePage() {
        this.memberStatus.setOK();
        JavaType javaType = this.configuration.getToBeGenerated().get(this.configuration.getSelectedClazz());
        if (javaType == null) {
            this.memberStatus.setError(NewExternalTypeWizardMessages.ExternalTypeFromJavaPage_Validation_NoMember);
        } else {
            List<Method> selectedMethods = javaType.getMethods();
            List<Field> selectedFields = javaType.getFields();
            List<Constructor<?>> selectedCons = javaType.getConstructors();
            if (!(selectedMethods != null && !selectedMethods.isEmpty() || selectedFields != null && !selectedFields.isEmpty() || selectedCons != null && !selectedCons.isEmpty() || this.isTypeWithoutPublicMember(this.configuration.getSelectedClazz()))) {
                this.memberStatus.setError(NewExternalTypeWizardMessages.ExternalTypeFromJavaPage_Validation_NoMember);
            }
        }
        this.updateStatus(this.memberStatus);
    }

    private boolean isTypeWithoutPublicMember(Class<?> clazz) {
        int n;
        int n2;
        AccessibleObject[] accessibleObjectArray;
        boolean isMark = true;
        if (clazz.getDeclaredFields() != null) {
            accessibleObjectArray = clazz.getDeclaredFields();
            n2 = accessibleObjectArray.length;
            n = 0;
            while (n < n2) {
                AccessibleObject field = accessibleObjectArray[n];
                if (Modifier.isPublic(((Field)field).getModifiers())) {
                    return false;
                }
                ++n;
            }
        }
        if (clazz.getDeclaredConstructors() != null) {
            accessibleObjectArray = clazz.getDeclaredConstructors();
            n2 = accessibleObjectArray.length;
            n = 0;
            while (n < n2) {
                AccessibleObject constructor = accessibleObjectArray[n];
                if (Modifier.isPublic(((Constructor)constructor).getModifiers())) {
                    return false;
                }
                ++n;
            }
        }
        if (clazz.getDeclaredMethods() != null) {
            accessibleObjectArray = clazz.getDeclaredMethods();
            n2 = accessibleObjectArray.length;
            n = 0;
            while (n < n2) {
                AccessibleObject method = accessibleObjectArray[n];
                if (Modifier.isPublic(((Method)method).getModifiers())) {
                    return false;
                }
                ++n;
            }
        }
        return isMark;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fPageVisible = visible;
    }

    protected void updateStatus(IStatus status) {
        this.fCurrStatus = status;
        this.setPageComplete(!status.matches(4));
        if (this.fPageVisible) {
            StatusUtil.applyToStatusLine((DialogPage)this, status);
        }
    }

    class ExternalTypeContentProvider
    implements ITreeContentProvider {
        private Object[] fTypes;
        private final Object[] fEmpty = new Object[0];
        private String inputFullyQualifiedName;

        public Object[] getElements(Object inputElement) {
            if (this.fTypes != null) {
                return this.fTypes;
            }
            return this.fEmpty;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Class) {
                int n;
                GenericDeclaration[] pTypes;
                boolean skipped;
                Class clazz = (Class)parentElement;
                HashSet<Field> fields = new HashSet<Field>();
                Field[] fieldArray = clazz.getDeclaredFields();
                int n2 = fieldArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Field field = fieldArray[n3];
                    if (Modifier.isPublic(field.getModifiers()) && !ReflectionUtil.isSkippedType(field.getType())) {
                        fields.add(field);
                    }
                    ++n3;
                }
                HashSet pubConstructors = new HashSet();
                Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
                int n4 = constructorArray.length;
                n2 = 0;
                while (n2 < n4) {
                    Constructor<?> pubCon = constructorArray[n2];
                    if (Modifier.isPublic(pubCon.getModifiers())) {
                        skipped = false;
                        GenericDeclaration[] genericDeclarationArray = pTypes = pubCon.getParameterTypes();
                        n = pTypes.length;
                        int n5 = 0;
                        while (n5 < n) {
                            GenericDeclaration pType = genericDeclarationArray[n5];
                            if (ReflectionUtil.isSkippedType(pType)) {
                                skipped = true;
                                break;
                            }
                            ++n5;
                        }
                        if (!skipped) {
                            pubConstructors.add(pubCon);
                        }
                    }
                    ++n2;
                }
                HashSet<GenericDeclaration> publicMethods = new HashSet<GenericDeclaration>(16);
                pTypes = clazz.getDeclaredMethods();
                int n6 = pTypes.length;
                n4 = 0;
                while (n4 < n6) {
                    GenericDeclaration m = pTypes[n4];
                    if (Modifier.isPublic(((Method)m).getModifiers()) && !((Method)m).isBridge()) {
                        Class<?>[] pTypes2;
                        skipped = false;
                        Class<?>[] classArray = pTypes2 = ((Method)m).getParameterTypes();
                        int n7 = pTypes2.length;
                        n = 0;
                        while (n < n7) {
                            Class<?> pType = classArray[n];
                            if (ReflectionUtil.isSkippedType(pType)) {
                                skipped = true;
                                break;
                            }
                            ++n;
                        }
                        if (!skipped && ReflectionUtil.isSkippedType(((Method)m).getReturnType())) {
                            skipped = true;
                        }
                        if (!skipped) {
                            publicMethods.add(m);
                        }
                    }
                    ++n4;
                }
                int memLen = fields.size() + pubConstructors.size() + publicMethods.size();
                Object[] members = new Object[memLen];
                int counter = 0;
                Field[] sortedFields = new Field[fields.size()];
                sortedFields = fields.toArray(sortedFields);
                int i = 1;
                while (i < sortedFields.length) {
                    int j = i;
                    Field field = sortedFields[i];
                    while (j > 0 && sortedFields[j - 1].getName().compareToIgnoreCase(field.getName()) > 0) {
                        sortedFields[j] = sortedFields[j - 1];
                        --j;
                    }
                    sortedFields[j] = field;
                    ++i;
                }
                Field[] fieldArray2 = sortedFields;
                int n5 = sortedFields.length;
                int n7 = 0;
                while (n7 < n5) {
                    Field field = fieldArray2[n7];
                    members[counter++] = field;
                    ++n7;
                }
                for (Constructor constructor : pubConstructors) {
                    members[counter++] = constructor;
                }
                Method[] methodArray2 = new Method[publicMethods.size()];
                methodArray2 = publicMethods.toArray(methodArray2);
                i = 1;
                while (i < methodArray2.length) {
                    int j = i;
                    Method method = methodArray2[i];
                    while (j > 0 && methodArray2[j - 1].getName().compareToIgnoreCase(method.getName()) > 0) {
                        methodArray2[j] = methodArray2[j - 1];
                        --j;
                    }
                    methodArray2[j] = method;
                    ++i;
                }
                Method[] methodArray3 = methodArray2;
                int n8 = methodArray2.length;
                int n9 = 0;
                while (n9 < n8) {
                    Method m = methodArray3[n9];
                    members[counter++] = m;
                    ++n9;
                }
                return members;
            }
            return this.fEmpty;
        }

        public Object getParent(Object element) {
            if (element instanceof Method) {
                return ((Method)element).getDeclaringClass();
            }
            if (element instanceof Constructor) {
                return ((Constructor)element).getDeclaringClass();
            }
            if (element instanceof Field) {
                return ((Field)element).getDeclaringClass();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof String) {
                this.inputFullyQualifiedName = (String)newInput;
                this.updateJavaTypeTree();
            }
        }

        public void dispose() {
        }

        public void updateJavaTypeTree() {
            if (this.inputFullyQualifiedName != null) {
                HashSet types = new HashSet(10);
                Class<?> selectedClazz = ExternalTypeFromJavaPage.this.configuration.getSelectedClazz();
                if (selectedClazz == null) {
                    selectedClazz = ReflectionUtil.getClass(ExternalTypeFromJavaPage.this.getURLClassLoader(), this.inputFullyQualifiedName);
                }
                types.add(selectedClazz);
                this.fTypes = types.toArray(new Class[types.size()]);
            }
        }
    }

    class ExternalTypeCustomValidator
    implements ISelectionStatusValidator {
        public IStatus validate(Object[] selection) {
            return this.validateBuilderType((IType)selection[0]);
        }

        public IStatus validateBuilderType(IType type) {
            try {
                if (type != null && Flags.isPublic((int)type.getFlags())) {
                    return new StatusInfo();
                }
                return new StatusInfo(4, NewExternalTypeWizardMessages.ExternalTypeFromJavaPage_notPublicType);
            }
            catch (JavaModelException javaModelException) {
                return new StatusInfo(2, NewExternalTypeWizardMessages.ExternalTypeFromJavaPage_typeValidationError);
            }
        }
    }

    public class ExternalTypeLabelProvider
    implements ILabelProvider {
        private Image classImage;
        private Image methpubImage;
        private Image fieldpubImage;

        public ExternalTypeLabelProvider() {
            try {
                URL url = new URL("platform:/plugin/org.eclipse.jdt.ui/icons/full/obj16/class_obj.gif");
                this.classImage = ImageDescriptor.createFromURL((URL)url).createImage();
                url = new URL("platform:/plugin/org.eclipse.jdt.ui/icons/full/obj16/methpub_obj.gif");
                this.methpubImage = ImageDescriptor.createFromURL((URL)url).createImage();
                url = new URL("platform:/plugin/org.eclipse.jdt.ui/icons/full/obj16/field_public_obj.gif");
                this.fieldpubImage = ImageDescriptor.createFromURL((URL)url).createImage();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public String getText(Object element) {
            String labelName = "";
            if (element instanceof Class) {
                labelName = ((Class)element).getSimpleName();
            } else if (element instanceof Method) {
                labelName = ReflectionUtil.getMethodLabel((Method)element);
            } else if (element instanceof Constructor) {
                labelName = ReflectionUtil.getConstructorLabel((Constructor)element);
            } else if (element instanceof Field) {
                labelName = ReflectionUtil.getJavaFieldLabel((Field)element);
            }
            return labelName;
        }

        public void dispose() {
            if (this.classImage != null) {
                this.classImage.dispose();
            }
            if (this.methpubImage != null) {
                this.methpubImage.dispose();
            }
            if (this.fieldpubImage != null) {
                this.fieldpubImage.dispose();
            }
        }

        public Image getImage(Object element) {
            if (element instanceof Class) {
                return this.classImage;
            }
            if (element instanceof Method || element instanceof Constructor) {
                return this.methpubImage;
            }
            if (element instanceof Field) {
                return this.fieldpubImage;
            }
            return null;
        }
    }

    private class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private TypeFieldsAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            ExternalTypeFromJavaPage.this.typePageChangeControlPressed(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            ExternalTypeFromJavaPage.this.typePageDialogFieldChanged(field);
        }
    }
}

