/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.editor.HTMLPrinter;
import org.eclipse.edt.ide.ui.internal.editor.IAnnotation;
import org.eclipse.jface.text.Position;

class HoverUtils {
    HoverUtils() {
    }

    public static void sort(List exact) {
        class AnnotationComparator
        implements Comparator {
            AnnotationComparator() {
            }

            public int compare(Object o1, Object o2) {
                if (o1 instanceof IAnnotation && o2 instanceof IAnnotation) {
                    IAnnotation a1 = (IAnnotation)o1;
                    IAnnotation a2 = (IAnnotation)o2;
                    if (!a1.isEGLMarkerAnnotation() && a2.isEGLMarkerAnnotation()) {
                        return -1;
                    }
                    if (a1.isEGLMarkerAnnotation() && !a2.isEGLMarkerAnnotation()) {
                        return 1;
                    }
                }
                return 0;
            }
        }
        Collections.sort(exact, new AnnotationComparator());
    }

    public static boolean isDuplicateAnnotation(Map messagesAtPosition, Position position, IAnnotation eglAnnotation) {
        String txt = eglAnnotation.getText();
        if (messagesAtPosition.containsKey(position)) {
            List annots = (List)messagesAtPosition.get(position);
            Integer problemKind = eglAnnotation.getProblemKind();
            for (IAnnotation annot : annots) {
                if (!annot.getProblemKind().equals(problemKind) || !(txt == null ? annot.getText() == null : txt.equals(annot.getText()))) continue;
                return true;
            }
            annots.add(eglAnnotation);
        } else {
            ArrayList<IAnnotation> list = new ArrayList<IAnnotation>();
            list.add(eglAnnotation);
            messagesAtPosition.put(position, list);
        }
        return false;
    }

    public static String formatSingleMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    public static String formatMultipleMessages(List messages) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(UINlsStrings.EGLAnnotationHoverMultipleMarkersAtThisLine));
        HTMLPrinter.startBulletList(buffer);
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            HTMLPrinter.addBullet(buffer, HTMLPrinter.convertToHTMLContent((String)e.next()));
        }
        HTMLPrinter.endBulletList(buffer);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }
}

