/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.internal.dialogs.PartSelectionDialog;
import org.eclipse.edt.ide.ui.wizards.EGLFileConfiguration;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;

public class EGLPartSelectionDialog
extends PartSelectionDialog {
    IFile initeglFile;
    EGLFileConfiguration fConfig;

    public EGLPartSelectionDialog(Shell parent, IRunnableContext context, int elemKind, String subType, IFile eglFile, EGLFileConfiguration fileConfig) {
        this(parent, context, elemKind, subType, eglFile, SearchEngine.createWorkspaceScope(), fileConfig);
    }

    public EGLPartSelectionDialog(Shell parent, IRunnableContext context, int elemKind, String subType, IFile eglFile, IEGLSearchScope searchScope, EGLFileConfiguration fileConfig) {
        super(parent, context, elemKind, subType, searchScope);
        this.initeglFile = eglFile;
        this.fConfig = fileConfig;
    }

    protected void okPressed() {
        this.updateConfig();
        super.okPressed();
    }

    @Override
    public int open() {
        this.setFilter("*");
        return super.open();
    }

    private void updateConfig() {
        Object ref = this.getLowerSelectedElement();
        if (ref instanceof PartInfo) {
            PartInfo partinfo = (PartInfo)ref;
            String srcFolder = partinfo.getPackageFragmentRootPath().toOSString();
            String pkgName = partinfo.getPackageName();
            String partName = partinfo.getPartName();
            this.fConfig.setContainerName(srcFolder);
            this.fConfig.setFPackage(pkgName);
            this.fConfig.setFileName(partName);
        }
    }
}

