/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.internal.sql.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.IPropertiesPersistenceHook;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.edt.ide.sql.SQLNlsStrings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class RDBConnectionUtility {
    public static IStatus connectWithPromptIfNeeded(IConnectionProfile profile, boolean reprompt) {
        profile.getName();
        Shell shell = Display.getCurrent().getActiveShell();
        IStatus connectionStatus = null;
        if (profile != null) {
            if (shell == null) {
                connectionStatus = profile.connect();
            } else {
                connectionStatus = profile.connectWithoutJob();
                if (reprompt && profile.getConnectionState() != 1 && connectionStatus.getCode() != 0) {
                    String title = NLS.bind((String)SQLNlsStrings.SQL_CONNECTION_FAILURE_MSG, (Object)profile.getName());
                    MessageDialog.openInformation((Shell)shell, (String)title, (String)connectionStatus.getChildren()[0].getException().getLocalizedMessage());
                    PropertyDialogAction propertyDialogAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)shell), (ISelectionProvider)new ConnectionPropertiesWizardSelectionProvider(profile));
                    StructuredSelection selection = new StructuredSelection((Object)profile);
                    propertyDialogAction.selectionChanged((IStructuredSelection)selection);
                    if (!profile.arePropertiesComplete() && propertyDialogAction.isApplicableForSelection()) {
                        PreferenceDialog dialog = propertyDialogAction.createDialog();
                        dialog = propertyDialogAction.createDialog();
                        String shellText = NLS.bind((String)SQLNlsStrings.SQL_CONNECTION_PROPERTIES_FOR, (Object)profile.getName());
                        dialog.getShell().setText(shellText);
                        IConnectionProfileProvider provider = profile.getProvider();
                        IPropertiesPersistenceHook hook = ((ConnectionProfileProvider)provider).getPropertiesPersistenceHook();
                        String initialPage = hook.getConnectionPropertiesPageID();
                        if (initialPage != null) {
                            ((IWorkbenchPreferenceContainer)dialog).openPage(initialPage, null);
                        }
                        if (dialog.open() == 1) {
                            reprompt = false;
                        }
                    }
                    if (reprompt) {
                        connectionStatus = profile.connectWithoutJob();
                    }
                }
            }
        }
        return connectionStatus;
    }

    private static final class ConnectionPropertiesWizardSelectionProvider
    implements ISelectionProvider {
        private IStructuredSelection selection;

        public ConnectionPropertiesWizardSelectionProvider(IConnectionProfile connectionProfile) {
            this.selection = new StructuredSelection((Object)connectionProfile);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }
}

