/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.migration.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edapt.spi.migration.MigrationPlugin;
import org.osgi.framework.Bundle;

public final class FactoryHelper {
    public static final FactoryHelper INSTANCE = new FactoryHelper();
    private static final String CLASS = "class";
    private static final String NS_URI = "nsURI";
    private static final String POINT_ID = "org.eclipse.emf.edapt.factories";
    private final Map<String, Class<? extends EFactory>> nsURIToFactoryMap = new LinkedHashMap<String, Class<? extends EFactory>>();

    private FactoryHelper() {
        this.readExtensionPoint();
    }

    private void readExtensionPoint() {
        IConfigurationElement[] configurationElements;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionRegistry.getConfigurationElementsFor(POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            this.registerFactory(configurationElement);
            ++n2;
        }
    }

    private void registerFactory(IConfigurationElement configurationElement) {
        try {
            String nsURI = configurationElement.getAttribute(NS_URI);
            String bundle = configurationElement.getContributor().getName();
            String className = configurationElement.getAttribute(CLASS);
            Class<? extends EFactory> clazz = FactoryHelper.loadClass(bundle, className);
            if (nsURI == null || clazz == null) {
                return;
            }
            this.nsURIToFactoryMap.put(nsURI, clazz);
        }
        catch (ClassNotFoundException e) {
            MigrationPlugin.INSTANCE.log(e);
        }
    }

    private static Class<? extends EFactory> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            MigrationPlugin.INSTANCE.log("Could not get bundle " + bundleName + " from platform.");
        }
        return bundle.loadClass(clazz);
    }

    public void overrideFactory(EPackage ePackage) {
        try {
            if (!this.nsURIToFactoryMap.containsKey(ePackage.getNsURI())) {
                return;
            }
            Class<? extends EFactory> clazz = this.nsURIToFactoryMap.get(ePackage.getNsURI());
            EFactory eFactory = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            ePackage.setEFactoryInstance(eFactory);
        }
        catch (InstantiationException e) {
            MigrationPlugin.INSTANCE.log(e);
        }
        catch (IllegalAccessException e) {
            MigrationPlugin.INSTANCE.log(e);
        }
        catch (IllegalArgumentException e) {
            MigrationPlugin.INSTANCE.log(e);
        }
        catch (InvocationTargetException e) {
            MigrationPlugin.INSTANCE.log(e);
        }
        catch (NoSuchMethodException e) {
            MigrationPlugin.INSTANCE.log(e);
        }
        catch (SecurityException e) {
            MigrationPlugin.INSTANCE.log(e);
        }
    }
}

