/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectContentChangedObserver;
import org.eclipse.emf.ecp.edit.internal.swt.ImageDescriptorToImage;
import org.eclipse.emf.ecp.view.model.provider.xmi.ViewModelFileExtensionsManager;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.ecp.view.editor.controls";
    private static Activator plugin;
    private ServiceReference<ReportService> reportServiceReference;
    private ServiceReference<EMFFormsDatabinding> emfFormsDatabindingServiceReference;
    private final Map<String, ImageDescriptorToImage> imageRegistry = new LinkedHashMap<String, ImageDescriptorToImage>(20, 0.8f, true){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean removeEldestEntry(Map.Entry<String, ImageDescriptorToImage> eldest) {
            return this.size() > 20;
        }

        @Override
        public ImageDescriptorToImage remove(Object arg0) {
            ImageDescriptorToImage image = (ImageDescriptorToImage)super.remove(arg0);
            image.getImage().dispose();
            return image;
        }
    };
    private final Map<Action, ImageDescriptorToImage> imageRegistryByAction = new LinkedHashMap<Action, ImageDescriptorToImage>();

    public static Image getImage(String path) {
        if (!Activator.getDefault().imageRegistry.containsKey(path)) {
            Activator.getDefault().imageRegistry.put(path, new ImageDescriptorToImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource(path))));
        }
        return Activator.getDefault().imageRegistry.get(path).getImage();
    }

    public static Image getImage(Action action) {
        String path = action.toString();
        if (!Activator.getDefault().imageRegistry.containsKey(path)) {
            Activator.getDefault().imageRegistry.put(path, new ImageDescriptorToImage(action.getImageDescriptor()));
        }
        return Activator.getDefault().imageRegistry.get(path).getImage();
    }

    public static Image getImage(URL url) {
        if (!Activator.getDefault().imageRegistry.containsKey(url == null ? "NULL" : url.toExternalForm())) {
            ImageDescriptor createFromURL = ImageDescriptor.createFromURL((URL)url);
            Activator.getDefault().imageRegistry.put(url == null ? "NULL" : url.toExternalForm(), new ImageDescriptorToImage(createFromURL));
        }
        return Activator.getDefault().imageRegistry.get(url == null ? "NULL" : url.toExternalForm()).getImage();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        if (!Activator.getDefault().imageRegistry.containsKey(path)) {
            Activator.getDefault().imageRegistry.put(path, new ImageDescriptorToImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource(path))));
        }
        return Activator.getDefault().imageRegistry.get(path).getImageDescriptor();
    }

    public static ImageData getImageData(URL url) {
        return ImageDescriptor.createFromURL((URL)url).getImageData();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ECPUtil.getECPObserverBus().register((ECPObserver)new ECPProjectContentChangedObserver(){

            public Collection<Object> objectsChanged(ECPProject project, Collection<Object> objects) {
                if (project.getProvider().getName().equals("org.eclipse.emf.ecp.workspace.provider")) {
                    EList contents = project.getContents();
                    for (Object object : contents) {
                        if (!(object instanceof VView)) continue;
                        ViewModelFileExtensionsManager.dispose();
                    }
                }
                return new ArrayList<Object>();
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        for (ImageDescriptorToImage descriptorToImage : this.imageRegistry.values()) {
            descriptorToImage.getImage().dispose();
        }
        for (ImageDescriptorToImage descriptorToImage : this.imageRegistryByAction.values()) {
            descriptorToImage.getImage().dispose();
        }
        if (this.emfFormsDatabindingServiceReference != null) {
            context.ungetService(this.emfFormsDatabindingServiceReference);
        }
        if (this.reportServiceReference != null) {
            context.ungetService(this.reportServiceReference);
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ReportService getReportService() {
        if (this.reportServiceReference == null) {
            this.reportServiceReference = plugin.getBundle().getBundleContext().getServiceReference(ReportService.class);
        }
        return (ReportService)plugin.getBundle().getBundleContext().getService(this.reportServiceReference);
    }

    public EMFFormsDatabinding getEMFFormsDatabinding() {
        if (this.emfFormsDatabindingServiceReference == null) {
            this.emfFormsDatabindingServiceReference = plugin.getBundle().getBundleContext().getServiceReference(EMFFormsDatabinding.class);
        }
        return (EMFFormsDatabinding)plugin.getBundle().getBundleContext().getService(this.emfFormsDatabindingServiceReference);
    }
}

