/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.builds.core.IParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.BooleanParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.BuildParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.BuildPlan;
import org.eclipse.mylyn.builds.internal.core.ChoiceParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.FileParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.PasswordParameterDefinition;
import org.eclipse.mylyn.builds.internal.core.StringParameterDefinition;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParametersDialog
extends TitleAreaDialog {
    private final Map<String, Control> controls = new HashMap<String, Control>();
    private final BuildPlan plan;
    private Map<String, String> parameters;

    public ParametersDialog(Shell parentShell, BuildPlan plan) {
        super(parentShell);
        this.plan = plan;
        this.setHelpAvailable(false);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Run Build");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(NLS.bind((String)"Build Plan {0}", (Object)this.plan.getLabel()));
        Composite pane = new Composite(composite, 0);
        pane.setLayoutData((Object)new GridData(1808));
        pane.setLayout((Layout)new GridLayout(2, false));
        for (final IParameterDefinition definition : this.plan.getParameterDefinitions()) {
            String name = definition.getName();
            Label label = new Label(pane, 0);
            label.setText(name);
            Control control = this.addParameter(pane, definition);
            if (control instanceof Text) {
                GridDataFactory.fillDefaults().hint(this.convertVerticalDLUsToPixels(200), -1).applyTo(control);
            }
            control.addFocusListener((FocusListener)new FocusAdapter(){
                private boolean firstTime = true;

                public void focusGained(FocusEvent e) {
                    if (this.firstTime) {
                        ParametersDialog.this.setMessage("Provide build parameters.");
                        this.firstTime = false;
                    } else {
                        ParametersDialog.this.setMessage(definition.getDescription());
                    }
                }
            });
            this.controls.put(name, control);
        }
        return composite;
    }

    private Control addParameter(Composite pane, IParameterDefinition definition) {
        if (definition instanceof ChoiceParameterDefinition) {
            int i;
            ChoiceParameterDefinition def = (ChoiceParameterDefinition)definition;
            Combo control = new Combo(pane, 2052);
            for (String option : def.getOptions()) {
                control.add(option);
            }
            if (def.getDefaultValue() != null && (i = control.indexOf(def.getDefaultValue())) != -1) {
                control.select(i);
            }
            return control;
        }
        if (definition instanceof BooleanParameterDefinition) {
            BooleanParameterDefinition def = (BooleanParameterDefinition)definition;
            Button control = new Button(pane, 2080);
            control.setSelection(def.isDefaultValue());
            return control;
        }
        if (definition instanceof StringParameterDefinition) {
            StringParameterDefinition def = (StringParameterDefinition)definition;
            Text control = new Text(pane, 2048);
            control.setText(this.toValue(def.getDefaultValue()));
            return control;
        }
        if (definition instanceof PasswordParameterDefinition) {
            PasswordParameterDefinition def = (PasswordParameterDefinition)definition;
            Text control = new Text(pane, 2048);
            control.setEchoChar('*');
            control.setText(this.toValue(def.getDefaultValue()));
            return control;
        }
        if (definition instanceof BuildParameterDefinition) {
            BuildParameterDefinition def = (BuildParameterDefinition)definition;
            Text control = new Text(pane, 2048);
            control.setText(this.toValue(def.getBuildPlanId()));
            return control;
        }
        if (definition instanceof FileParameterDefinition) {
            Text control = new Text(pane, 2048);
            return control;
        }
        throw new IllegalArgumentException("Unexpected definition type: " + definition.getClass().getName());
    }

    private String toValue(String defaultValue) {
        return defaultValue != null ? defaultValue : "";
    }

    protected void okPressed() {
        this.parameters = new HashMap<String, String>();
        for (IParameterDefinition definition : this.plan.getParameterDefinitions()) {
            String name = definition.getName();
            Control control = this.controls.get(name);
            String parameter = this.getParameter(control);
            if (parameter == null) continue;
            this.parameters.put(name, parameter);
        }
        super.okPressed();
    }

    private String getParameter(Control control) {
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            return combo.getText();
        }
        if (control instanceof Button) {
            Button button = (Button)control;
            if (button.getSelection()) {
                return "on";
            }
            return null;
        }
        if (control instanceof Text) {
            Text text = (Text)control;
            return text.getText();
        }
        throw new IllegalArgumentException("Unexpected control type: " + control.getClass().getName());
    }
}

