/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSListener;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.AddToVersionControlDialog;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.IRepositoryListener;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.ReleaseCommentDialog;
import org.eclipse.team.internal.ccvs.ui.XMLWriter;
import org.eclipse.team.internal.ccvs.ui.repo.CommentHistoryContentHandler;
import org.eclipse.team.internal.ccvs.ui.repo.CommentTemplatesContentHandler;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoriesViewContentHandler;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.ui.IWorkingSet;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryManager {
    private static final String STATE_FILE = ".repositoryManagerState";
    private static final int STATE_FILE_VERSION_1 = -1;
    private static final String REPOSITORIES_VIEW_FILE = "repositoriesView.xml";
    private static final String COMMENT_HIST_FILE = "commitCommentHistory.xml";
    private static final String COMMENT_TEMPLATES_FILE = "commentTemplates.xml";
    static final String ELEMENT_COMMIT_COMMENT = "CommitComment";
    static final String ELEMENT_COMMIT_HISTORY = "CommitComments";
    static final String ELEMENT_COMMENT_TEMPLATES = "CommitCommentTemplates";
    private Map<String, RepositoryRoot> repositoryRoots = new HashMap<String, RepositoryRoot>();
    List<IRepositoryListener> listeners = new ArrayList<IRepositoryListener>();
    static String[] previousComments = new String[0];
    static String[] commentTemplates = new String[0];
    public static boolean notifyRepoView = true;
    private int notificationLevel = 0;
    private Map<String, ICVSRepositoryLocation> changedRepositories = new HashMap<String, ICVSRepositoryLocation>();
    public static final int DEFAULT_MAX_COMMENTS = 10;
    private int maxComments = 10;

    public void setMaxComments(int maxComments) {
        if (maxComments > 0) {
            this.maxComments = maxComments;
            if (maxComments < previousComments.length) {
                String[] newComments = new String[maxComments];
                System.arraycopy(previousComments, 0, newComments, 0, maxComments);
                previousComments = newComments;
            }
        }
    }

    public ICVSRepositoryLocation[] getKnownRepositoryLocations() {
        return KnownRepositories.getInstance().getRepositories();
    }

    private RepositoryRoot[] getRepositoryRoots(ICVSRepositoryLocation[] locations) {
        ArrayList<RepositoryRoot> roots = new ArrayList<RepositoryRoot>();
        int i = 0;
        while (i < locations.length) {
            ICVSRepositoryLocation location = locations[i];
            RepositoryRoot root = this.getRepositoryRootFor(location);
            if (root != null) {
                roots.add(root);
            }
            ++i;
        }
        return roots.toArray(new RepositoryRoot[roots.size()]);
    }

    public RepositoryRoot[] getKnownRepositoryRoots() {
        return this.getRepositoryRoots(this.getKnownRepositoryLocations());
    }

    public CVSTag[] getKnownTags(ICVSFolder project, int tagType) {
        try {
            CVSTag[] tags = this.getKnownTags(project);
            HashSet<CVSTag> result = new HashSet<CVSTag>();
            int i = 0;
            while (i < tags.length) {
                CVSTag tag = tags[i];
                if (tag.getType() == tagType) {
                    result.add(tag);
                }
                ++i;
            }
            return result.toArray(new CVSTag[result.size()]);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return new CVSTag[0];
        }
    }

    public CVSTag[] getKnownTags(ICVSRepositoryLocation location, int tagType) {
        HashSet<CVSTag> result = new HashSet<CVSTag>();
        RepositoryRoot root = this.repositoryRoots.get(location.getLocation(false));
        if (root != null) {
            CVSTag[] tags = root.getAllKnownTags();
            int i = 0;
            while (i < tags.length) {
                CVSTag tag = tags[i];
                if (tag.getType() == tagType) {
                    result.add(tag);
                }
                ++i;
            }
        }
        return result.toArray(new CVSTag[0]);
    }

    public CVSTag[] getKnownTags(ICVSRepositoryLocation repository, IWorkingSet set, int tagType, IProgressMonitor monitor) throws CVSException {
        if (set == null) {
            return this.getKnownTags(repository, tagType);
        }
        ICVSRemoteResource[] folders = this.getFoldersForTag(repository, CVSTag.DEFAULT, monitor);
        folders = this.filterResources(set, folders);
        HashSet<CVSTag> tags = new HashSet<CVSTag>();
        int i = 0;
        while (i < folders.length) {
            ICVSRemoteFolder folder = (ICVSRemoteFolder)folders[i];
            tags.addAll(Arrays.asList(this.getKnownTags((ICVSFolder)folder, tagType)));
            ++i;
        }
        return tags.toArray(new CVSTag[tags.size()]);
    }

    public CVSTag[] getKnownTags(ICVSFolder project) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSResource)project);
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)project);
        return root.getAllKnownTags(remotePath);
    }

    public Map getKnownProjectsAndVersions(ICVSRepositoryLocation location) {
        HashMap knownTags = new HashMap();
        RepositoryRoot root = this.getRepositoryRootFor(location);
        String[] paths = root.getKnownRemotePaths();
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            HashSet<CVSTag> result = new HashSet<CVSTag>();
            result.addAll(Arrays.asList(root.getAllKnownTags(path)));
            knownTags.put(path, result);
            ++i;
        }
        return knownTags;
    }

    public ICVSRemoteResource[] getFoldersForTag(ICVSRepositoryLocation location, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(NLS.bind((String)CVSUIMessages.RepositoryManager_fetchingRemoteFolders, (Object[])new String[]{tag.getName()}), 100);
            if (tag.getType() == 0) {
                ICVSRemoteResource[] resources = location.members(tag, false, Policy.subMonitorFor(monitor, 60));
                RepositoryRoot root = this.getRepositoryRootFor(location);
                ICVSRemoteResource[] modules = root.getDefinedModules(tag, Policy.subMonitorFor(monitor, 40));
                ICVSRemoteResource[] result = new ICVSRemoteResource[resources.length + modules.length];
                System.arraycopy(resources, 0, result, 0, resources.length);
                System.arraycopy(modules, 0, result, resources.length, modules.length);
                ICVSRemoteResource[] iCVSRemoteResourceArray = result;
                return iCVSRemoteResourceArray;
            }
            if (tag.getType() == 3) {
                ICVSRemoteResource[] resources = location.members(tag, false, Policy.subMonitorFor(monitor, 60));
                RepositoryRoot root = this.getRepositoryRootFor(location);
                ICVSRemoteResource[] modules = root.getDefinedModules(tag, Policy.subMonitorFor(monitor, 40));
                ICVSRemoteResource[] result = new ICVSRemoteResource[resources.length + modules.length];
                System.arraycopy(resources, 0, result, 0, resources.length);
                System.arraycopy(modules, 0, result, resources.length, modules.length);
                ICVSRemoteResource[] iCVSRemoteResourceArray = result;
                return iCVSRemoteResourceArray;
            }
            HashSet<ICVSRemoteFolder> result = new HashSet<ICVSRemoteFolder>();
            RepositoryRoot root = this.getRepositoryRootFor(location);
            String[] paths = root.getRemoteChildrenForTag(null, tag);
            int i = 0;
            while (i < paths.length) {
                String path = paths[i];
                ICVSRemoteFolder remote = root.getRemoteFolder(path, tag, Policy.subMonitorFor(monitor, 100));
                result.add(remote);
                ++i;
            }
            ICVSRemoteResource[] iCVSRemoteResourceArray = result.toArray(new ICVSRemoteResource[result.size()]);
            return iCVSRemoteResourceArray;
        }
        finally {
            monitor.done();
        }
    }

    public ICVSRemoteResource[] getCachedChildrenForTag(ICVSRepositoryLocation location, ICVSRemoteFolder parentFolder, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        if (tag == null || tag.getType() == 0 || tag.getType() == 3) {
            return new ICVSRemoteResource[0];
        }
        monitor = Policy.monitorFor(monitor);
        HashSet<ICVSRemoteFolder> result = new HashSet<ICVSRemoteFolder>();
        RepositoryRoot root = this.getRepositoryRootFor(location);
        String[] paths = root.getRemoteChildrenForTag(parentFolder == null ? null : RepositoryRoot.getRemotePathFor((ICVSResource)parentFolder), tag);
        monitor.beginTask(NLS.bind((String)CVSUIMessages.RemoteFolderElement_fetchingRemoteChildren, (Object[])new String[]{NLS.bind((String)CVSUIMessages.RemoteFolderElement_nameAndTag, (Object[])new String[]{parentFolder.getName(), tag.getName()})}), 10 * paths.length);
        try {
            int i = 0;
            while (i < paths.length) {
                String path = paths[i];
                ICVSRemoteFolder remote = root.getRemoteFolder(path, tag, Policy.subMonitorFor(monitor, 10));
                result.add(remote);
                ++i;
            }
            ICVSRemoteResource[] iCVSRemoteResourceArray = result.toArray(new ICVSRemoteResource[result.size()]);
            return iCVSRemoteResourceArray;
        }
        finally {
            monitor.done();
        }
    }

    public CVSTag[] refreshDefinedTags(ICVSFolder folder, boolean recurse, boolean notify, IProgressMonitor monitor) throws TeamException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSResource)folder);
        CVSTag[] tags = root.refreshDefinedTags(folder, recurse, monitor);
        if (tags.length > 0 && notify) {
            this.broadcastRepositoryChange(root);
        }
        return tags;
    }

    public void rootAdded(ICVSRepositoryLocation root) {
        for (IRepositoryListener listener : this.listeners) {
            listener.repositoryAdded(root);
        }
    }

    public void rootRemoved(ICVSRepositoryLocation root) {
        RepositoryRoot repoRoot = this.repositoryRoots.remove(root.getLocation(false));
        if (repoRoot != null) {
            this.broadcastRepositoryChange(repoRoot);
        }
    }

    public void addTags(ICVSResource resource, CVSTag[] tags) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor(resource);
        String remotePath = RepositoryRoot.getRemotePathFor(resource);
        root.addTags(remotePath, tags);
        this.broadcastRepositoryChange(root);
    }

    public void addDateTag(ICVSRepositoryLocation location, CVSTag tag) {
        if (tag == null) {
            return;
        }
        RepositoryRoot root = this.getRepositoryRootFor(location);
        root.addDateTag(tag);
        this.broadcastRepositoryChange(root);
    }

    public CVSTag[] getDateTags(ICVSRepositoryLocation location) {
        RepositoryRoot root = this.getRepositoryRootFor(location);
        return root.getDateTags();
    }

    public void removeDateTag(ICVSRepositoryLocation location, CVSTag tag) {
        RepositoryRoot root = this.getRepositoryRootFor(location);
        root.removeDateTag(tag);
        this.broadcastRepositoryChange(root);
    }

    public void setAutoRefreshFiles(ICVSFolder project, String[] filePaths) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSResource)project);
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)project);
        root.setAutoRefreshFiles(remotePath, filePaths);
    }

    public String[] getAutoRefreshFiles(ICVSFolder project) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSResource)project);
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)project);
        return root.getAutoRefreshFiles(remotePath);
    }

    public void removeTags(ICVSFolder project, CVSTag[] tags) throws CVSException {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSResource)project);
        String remotePath = RepositoryRoot.getRemotePathFor((ICVSResource)project);
        root.removeTags(remotePath, tags);
        this.broadcastRepositoryChange(root);
    }

    public void startup() {
        this.loadState();
        this.loadCommentHistory();
        this.loadCommentTemplates();
        CVSProviderPlugin.getPlugin().addRepositoryListener(new ICVSListener(){

            public void repositoryAdded(ICVSRepositoryLocation root) {
                RepositoryManager.this.rootAdded(root);
            }

            public void repositoryRemoved(ICVSRepositoryLocation root) {
                RepositoryManager.this.rootRemoved(root);
            }
        });
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        store.addPropertyChangeListener(event -> {
            Object newValue;
            if (event.getProperty().equals("pref_commit_comments_max_history") && (newValue = event.getNewValue()) instanceof String) {
                try {
                    this.setMaxComments(Integer.parseInt((String)newValue));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        this.setMaxComments(store.getInt("pref_commit_comments_max_history"));
    }

    public void shutdown() throws TeamException {
        this.saveState();
        this.saveCommentHistory();
        this.saveCommentTemplates();
    }

    private void loadState() {
        IPath pluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation().append(REPOSITORIES_VIEW_FILE);
        File file = pluginStateLocation.toFile();
        if (file.exists()) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                this.readState(is);
            }
            catch (IOException e) {
                CVSUIPlugin.log(4, CVSUIMessages.RepositoryManager_ioException, e);
            }
            catch (TeamException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        } else {
            IPath oldPluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation().append(STATE_FILE);
            file = oldPluginStateLocation.toFile();
            if (file.exists()) {
                try {
                    try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
                        this.readOldState(dis);
                    }
                    this.saveState();
                    file.delete();
                }
                catch (IOException e) {
                    CVSUIPlugin.log(4, CVSUIMessages.RepositoryManager_ioException, e);
                }
                catch (TeamException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            }
        }
    }

    private void loadCommentHistory() {
        IPath pluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation().append(COMMENT_HIST_FILE);
        File file = pluginStateLocation.toFile();
        if (!file.exists()) {
            return;
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            this.readCommentHistory(is);
        }
        catch (IOException e) {
            CVSUIPlugin.log(4, CVSUIMessages.RepositoryManager_ioException, e);
        }
        catch (TeamException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    private void loadCommentTemplates() {
        IPath pluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation().append(COMMENT_TEMPLATES_FILE);
        File file = pluginStateLocation.toFile();
        if (!file.exists()) {
            return;
        }
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            this.readCommentTemplates(is);
        }
        catch (IOException e) {
            CVSUIPlugin.log(4, CVSUIMessages.RepositoryManager_ioException, e);
        }
        catch (TeamException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    protected void saveState() throws TeamException {
        IPath pluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation();
        File tempFile = pluginStateLocation.append("repositoriesView.xml.tmp").toFile();
        File stateFile = pluginStateLocation.append(REPOSITORIES_VIEW_FILE).toFile();
        try {
            boolean renamed;
            try (XMLWriter writer = new XMLWriter(new BufferedOutputStream(new FileOutputStream(tempFile)));){
                this.writeState(writer);
            }
            if (stateFile.exists()) {
                stateFile.delete();
            }
            if (!(renamed = tempFile.renameTo(stateFile))) {
                throw new TeamException((IStatus)new Status(4, "org.eclipse.team.cvs.ui", -6, NLS.bind((String)CVSUIMessages.RepositoryManager_rename, (Object[])new String[]{tempFile.getAbsolutePath()}), null));
            }
        }
        catch (IOException e) {
            throw new TeamException((IStatus)new Status(4, "org.eclipse.team.cvs.ui", -6, NLS.bind((String)CVSUIMessages.RepositoryManager_save, (Object[])new String[]{stateFile.getAbsolutePath()}), (Throwable)e));
        }
    }

    private void writeState(XMLWriter writer) {
        writer.startTag("repositories-view", null, true);
        List<ICVSRepositoryLocation> repos = Arrays.asList(this.getKnownRepositoryLocations());
        for (CVSRepositoryLocation cVSRepositoryLocation : repos) {
            RepositoryRoot root = this.getRepositoryRootFor((ICVSRepositoryLocation)cVSRepositoryLocation);
            root.writeState(writer);
        }
        writer.endTag("repositories-view");
    }

    private void readState(InputStream stream) throws IOException, TeamException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(stream), (DefaultHandler)new RepositoriesViewContentHandler(this));
        }
        catch (SAXException ex) {
            CVSStatus status = new CVSStatus(4, 4, NLS.bind((String)CVSUIMessages.RepositoryManager_parsingProblem, (Object[])new String[]{REPOSITORIES_VIEW_FILE}), (Throwable)ex);
            throw new CVSException((IStatus)status);
        }
        catch (ParserConfigurationException ex) {
            CVSStatus status = new CVSStatus(4, 4, NLS.bind((String)CVSUIMessages.RepositoryManager_parsingProblem, (Object[])new String[]{REPOSITORIES_VIEW_FILE}), (Throwable)ex);
            throw new CVSException((IStatus)status);
        }
    }

    private void readCommentHistory(InputStream stream) throws IOException, TeamException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(stream), (DefaultHandler)new CommentHistoryContentHandler());
        }
        catch (SAXException ex) {
            CVSStatus status = new CVSStatus(4, 4, NLS.bind((String)CVSUIMessages.RepositoryManager_parsingProblem, (Object[])new String[]{COMMENT_HIST_FILE}), (Throwable)ex);
            throw new CVSException((IStatus)status);
        }
        catch (ParserConfigurationException ex) {
            CVSStatus status = new CVSStatus(4, 4, NLS.bind((String)CVSUIMessages.RepositoryManager_parsingProblem, (Object[])new String[]{COMMENT_HIST_FILE}), (Throwable)ex);
            throw new CVSException((IStatus)status);
        }
    }

    private void readOldState(DataInputStream dis) throws IOException, TeamException {
        int repoSize = dis.readInt();
        boolean version1 = false;
        if (repoSize == -1) {
            version1 = true;
            repoSize = dis.readInt();
        }
        int i = 0;
        while (i < repoSize) {
            ICVSRepositoryLocation root = KnownRepositories.getInstance().getRepository(dis.readUTF());
            RepositoryRoot repoRoot = this.getRepositoryRootFor(root);
            int tagsSize = dis.readInt();
            CVSTag[] branchTags = new CVSTag[tagsSize];
            int j = 0;
            while (j < tagsSize) {
                String tagName = dis.readUTF();
                int tagType = dis.readInt();
                branchTags[j] = new CVSTag(tagName, tagType);
                ++j;
            }
            int projSize = dis.readInt();
            if (projSize > 0) {
                int j2 = 0;
                while (j2 < projSize) {
                    String name = dis.readUTF();
                    HashSet<CVSTag> tagSet = new HashSet<CVSTag>();
                    int numTags = dis.readInt();
                    int k = 0;
                    while (k < numTags) {
                        tagSet.add(new CVSTag(dis.readUTF(), 2));
                        ++k;
                    }
                    CVSTag[] tags = tagSet.toArray(new CVSTag[tagSet.size()]);
                    repoRoot.addTags(name, tags);
                    ++j2;
                }
            }
            if (version1) {
                try {
                    projSize = dis.readInt();
                    if (projSize > 0) {
                        int j3 = 0;
                        while (j3 < projSize) {
                            String name = dis.readUTF();
                            HashSet<String> filenames = new HashSet<String>();
                            int numFilenames = dis.readInt();
                            int k = 0;
                            while (k < numFilenames) {
                                filenames.add(String.valueOf(name) + "/" + dis.readUTF());
                                ++k;
                            }
                            repoRoot.setAutoRefreshFiles(name, filenames.toArray(new String[filenames.size()]));
                            ++j3;
                        }
                    }
                }
                catch (EOFException eOFException) {}
            }
            this.broadcastRepositoryChange(repoRoot);
            ++i;
        }
    }

    protected void saveCommentHistory() throws TeamException {
        IPath pluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation();
        File tempFile = pluginStateLocation.append("commitCommentHistory.xml.tmp").toFile();
        File histFile = pluginStateLocation.append(COMMENT_HIST_FILE).toFile();
        try {
            boolean renamed;
            try (XMLWriter writer = new XMLWriter(new BufferedOutputStream(new FileOutputStream(tempFile)));){
                this.writeCommentHistory(writer);
            }
            if (histFile.exists()) {
                histFile.delete();
            }
            if (!(renamed = tempFile.renameTo(histFile))) {
                throw new TeamException((IStatus)new Status(4, "org.eclipse.team.cvs.ui", -6, NLS.bind((String)CVSUIMessages.RepositoryManager_rename, (Object[])new String[]{tempFile.getAbsolutePath()}), null));
            }
        }
        catch (IOException e) {
            throw new TeamException((IStatus)new Status(4, "org.eclipse.team.cvs.ui", -6, NLS.bind((String)CVSUIMessages.RepositoryManager_save, (Object[])new String[]{histFile.getAbsolutePath()}), (Throwable)e));
        }
    }

    private void writeCommentHistory(XMLWriter writer) {
        writer.startTag(ELEMENT_COMMIT_HISTORY, null, false);
        int i = 0;
        while (i < previousComments.length && i < this.maxComments) {
            writer.printSimpleTag(ELEMENT_COMMIT_COMMENT, previousComments[i]);
            ++i;
        }
        writer.endTag(ELEMENT_COMMIT_HISTORY);
    }

    public void addRepositoryListener(IRepositoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeRepositoryListener(IRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    public String promptForComment(Shell shell, IResource[] resourcesToCommit, String proposedComment) {
        int[] result = new int[1];
        ReleaseCommentDialog dialog = new ReleaseCommentDialog(shell, resourcesToCommit, proposedComment, 2);
        shell.getDisplay().syncExec(() -> {
            nArray[0] = dialog.open();
            if (result[0] != 0) {
                return;
            }
        });
        if (result[0] != 0) {
            return null;
        }
        return dialog.getComment();
    }

    public IResource[] promptForResourcesToBeAdded(Shell shell, IResource[] unadded) {
        if (unadded == null) {
            return new IResource[0];
        }
        if (unadded.length == 0) {
            return unadded;
        }
        IResource[][] result = new IResource[1][0];
        result[0] = null;
        AddToVersionControlDialog dialog = new AddToVersionControlDialog(shell, unadded);
        shell.getDisplay().syncExec(() -> {
            int code = dialog.open();
            if (code == 2) {
                iResourceArray[0] = dialog.getResourcesToAdd();
            } else if (code == 3) {
                iResourceArray[0] = new IResource[0];
            }
        });
        return result[0];
    }

    public ICVSRepositoryLocation getRepositoryLocationFor(ICVSResource resource) {
        try {
            return this.internalGetRepositoryLocationFor(resource);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    private ICVSRepositoryLocation internalGetRepositoryLocationFor(ICVSResource resource) throws CVSException {
        ICVSFolder folder = resource.isFolder() ? (ICVSFolder)resource : resource.getParent();
        if (folder.isCVSFolder()) {
            ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(folder.getFolderSyncInfo().getRoot());
            return location;
        }
        return null;
    }

    private RepositoryRoot getRepositoryRootFor(ICVSResource resource) throws CVSException {
        ICVSRepositoryLocation location = this.internalGetRepositoryLocationFor(resource);
        if (location == null) {
            return null;
        }
        return this.getRepositoryRootFor(location);
    }

    public RepositoryRoot getRepositoryRootFor(ICVSRepositoryLocation location) {
        RepositoryRoot root = this.repositoryRoots.get(location.getLocation(false));
        if (root == null) {
            root = new RepositoryRoot(location);
            this.add(root);
        }
        return root;
    }

    public void add(RepositoryRoot root) {
        this.repositoryRoots.put(root.getRoot().getLocation(false), root);
        this.broadcastRepositoryChange(root);
    }

    private void broadcastRepositoryChange(RepositoryRoot root) {
        if (this.notificationLevel == 0) {
            this.broadcastRepositoriesChanged(new ICVSRepositoryLocation[]{root.getRoot()});
        } else {
            this.changedRepositories.put(root.getRoot().getLocation(false), root.getRoot());
        }
    }

    private void broadcastRepositoriesChanged(ICVSRepositoryLocation[] roots) {
        if (roots.length == 0) {
            return;
        }
        for (IRepositoryListener listener : this.listeners) {
            listener.repositoriesChanged(roots);
        }
    }

    public void run(IRunnableWithProgress runnable, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            ++this.notificationLevel;
            runnable.run(monitor);
        }
        finally {
            this.notificationLevel = Math.max(0, this.notificationLevel - 1);
            if (this.notificationLevel == 0) {
                try {
                    Collection<ICVSRepositoryLocation> roots = this.changedRepositories.values();
                    this.broadcastRepositoriesChanged(roots.toArray(new ICVSRepositoryLocation[roots.size()]));
                }
                finally {
                    this.changedRepositories.clear();
                }
            }
        }
    }

    public boolean isDisplayingProjectVersions(ICVSRepositoryLocation repository) {
        return true;
    }

    public ICVSRemoteResource[] filterResources(IWorkingSet workingSet, ICVSRemoteResource[] resources) {
        if (workingSet == null) {
            return resources;
        }
        IAdaptable[] adaptables = workingSet.getElements();
        HashSet<IProject> projects = new HashSet<IProject>();
        int i = 0;
        while (i < adaptables.length) {
            IAdaptable adaptable = adaptables[i];
            Object adapted = adaptable.getAdapter(IResource.class);
            if (adapted != null) {
                IProject project = ((IResource)adapted).getProject();
                projects.add(project);
            }
            ++i;
        }
        ArrayList<ICVSRemoteResource> result = new ArrayList<ICVSRemoteResource>();
        int i2 = 0;
        while (i2 < resources.length) {
            ICVSRemoteResource resource = resources[i2];
            for (IProject project : projects) {
                if (!project.getName().equals(resource.getName())) continue;
                result.add(resource);
                break;
            }
            ++i2;
        }
        return result.toArray(new ICVSRemoteResource[result.size()]);
    }

    public void setLabel(CVSRepositoryLocation location, String label) {
        RepositoryRoot root = this.getRepositoryRootFor((ICVSRepositoryLocation)location);
        String oldLabel = root.getName();
        if (oldLabel == null) {
            if (label == null) {
                return;
            }
            root.setName(label);
        } else if (label == null) {
            root.setName(label);
        } else {
            if (label.equals(oldLabel)) {
                return;
            }
            root.setName(label);
        }
        this.broadcastRepositoryChange(root);
    }

    public void replaceRepositoryLocation(ICVSRepositoryLocation oldLocation, CVSRepositoryLocation newLocation) {
        try {
            this.run(monitor -> {
                RepositoryRoot root = this.getRepositoryRootFor(oldLocation);
                KnownRepositories.getInstance().disposeRepository(oldLocation);
                boolean isNew = !KnownRepositories.getInstance().isKnownRepository(newLocation.getLocation());
                root.setRepositoryLocation(KnownRepositories.getInstance().addRepository((ICVSRepositoryLocation)newLocation, isNew));
                this.add(root);
            }, Policy.monitorFor(null));
        }
        catch (InvocationTargetException e) {
            CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void purgeCache() {
        for (RepositoryRoot root : this.repositoryRoots.values()) {
            root.clearCache();
        }
    }

    public String[] getPreviousComments() {
        return previousComments;
    }

    public void addComment(String comment) {
        int index = this.getCommentIndex(comment);
        if (index != -1) {
            this.makeFirstElement(index);
            return;
        }
        if (this.containsCommentTemplate(comment)) {
            return;
        }
        String[] newComments = new String[Math.min(previousComments.length + 1, this.maxComments)];
        newComments[0] = comment;
        int i = 1;
        while (i < newComments.length) {
            newComments[i] = previousComments[i - 1];
            ++i;
        }
        previousComments = newComments;
    }

    private int getCommentIndex(String comment) {
        int i = 0;
        while (i < previousComments.length) {
            if (previousComments[i].equals(comment)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void makeFirstElement(int index) {
        String[] newComments = new String[previousComments.length];
        newComments[0] = previousComments[index];
        System.arraycopy(previousComments, 0, newComments, 1, index);
        int maxIndex = previousComments.length - 1;
        if (index != maxIndex) {
            int nextIndex = index + 1;
            System.arraycopy(previousComments, nextIndex, newComments, nextIndex, maxIndex - index);
        }
        previousComments = newComments;
    }

    private void readCommentTemplates(InputStream stream) throws IOException, TeamException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(stream), (DefaultHandler)new CommentTemplatesContentHandler());
        }
        catch (SAXException ex) {
            CVSStatus status = new CVSStatus(4, 4, NLS.bind((String)CVSUIMessages.RepositoryManager_parsingProblem, (Object[])new String[]{COMMENT_TEMPLATES_FILE}), (Throwable)ex);
            throw new CVSException((IStatus)status);
        }
        catch (ParserConfigurationException ex) {
            CVSStatus status = new CVSStatus(4, 4, NLS.bind((String)CVSUIMessages.RepositoryManager_parsingProblem, (Object[])new String[]{COMMENT_TEMPLATES_FILE}), (Throwable)ex);
            throw new CVSException((IStatus)status);
        }
    }

    protected void saveCommentTemplates() throws TeamException {
        IPath pluginStateLocation = CVSUIPlugin.getPlugin().getStateLocation();
        File tempFile = pluginStateLocation.append("commentTemplates.xml.tmp").toFile();
        File histFile = pluginStateLocation.append(COMMENT_TEMPLATES_FILE).toFile();
        try {
            boolean renamed;
            try (XMLWriter writer = new XMLWriter(new BufferedOutputStream(new FileOutputStream(tempFile)));){
                this.writeCommentTemplates(writer);
            }
            if (histFile.exists()) {
                histFile.delete();
            }
            if (!(renamed = tempFile.renameTo(histFile))) {
                throw new TeamException((IStatus)new Status(4, "org.eclipse.team.cvs.ui", -6, NLS.bind((String)CVSUIMessages.RepositoryManager_rename, (Object[])new String[]{tempFile.getAbsolutePath()}), null));
            }
        }
        catch (IOException e) {
            throw new TeamException((IStatus)new Status(4, "org.eclipse.team.cvs.ui", -6, NLS.bind((String)CVSUIMessages.RepositoryManager_save, (Object[])new String[]{histFile.getAbsolutePath()}), (Throwable)e));
        }
    }

    private void writeCommentTemplates(XMLWriter writer) {
        writer.startTag(ELEMENT_COMMENT_TEMPLATES, null, false);
        int i = 0;
        while (i < commentTemplates.length) {
            writer.printSimpleTag(ELEMENT_COMMIT_COMMENT, commentTemplates[i]);
            ++i;
        }
        writer.endTag(ELEMENT_COMMENT_TEMPLATES);
    }

    private boolean containsCommentTemplate(String comment) {
        int i = 0;
        while (i < commentTemplates.length) {
            if (commentTemplates[i].equals(comment)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getCommentTemplates() {
        return commentTemplates;
    }

    public void replaceAndSaveCommentTemplates(String[] templates) throws TeamException {
        commentTemplates = templates;
        this.saveCommentTemplates();
    }
}

