/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.model;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mylyn.gerrit.dashboard.core.GerritTask;
import org.eclipse.mylyn.gerrit.dashboard.ui.GerritUi;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.model.ReviewTableDefinition;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ReviewTableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private final String EMPTY_STRING = "";
    public static final String CHECKED_IMAGE = "greenCheck.png";
    public static final String NOT_OK_IMAGE = "redNot.png";
    public static final String MINUS_ONE = "minusOne.png";
    public static final String PLUS_ONE = "plusOne.png";
    public static final String STAR_FILLED = "starFilled.gif";
    public static final String STAR_OPEN = "starOpen.gif";
    public static final int NOT_OK_IMAGE_STATE = -2;
    public static final int CHECKED_IMAGE_STATE = 2;
    private static Display fDisplay = Display.getCurrent();
    private static Color RED = fDisplay.getSystemColor(3);
    private static Color GREEN = fDisplay.getSystemColor(6);
    private static Color DEFAULT_COLOR = fDisplay.getSystemColor(25);
    private static Color INCOMING_COLOR = fDisplay.getSystemColor(1);
    private static Color CLOSED_COLOR = fDisplay.getSystemColor(1);
    private static ImageRegistry fImageRegistry = new ImageRegistry();

    static {
        String iconPath = "icons/view16/";
        fImageRegistry.put(CHECKED_IMAGE, GerritUi.getImageDescriptor(String.valueOf(iconPath) + CHECKED_IMAGE));
        fImageRegistry.put(NOT_OK_IMAGE, GerritUi.getImageDescriptor(String.valueOf(iconPath) + NOT_OK_IMAGE));
        fImageRegistry.put(MINUS_ONE, GerritUi.getImageDescriptor(String.valueOf(iconPath) + MINUS_ONE));
        fImageRegistry.put(PLUS_ONE, GerritUi.getImageDescriptor(String.valueOf(iconPath) + PLUS_ONE));
        fImageRegistry.put(STAR_FILLED, GerritUi.getImageDescriptor(String.valueOf(iconPath) + STAR_FILLED));
        fImageRegistry.put(STAR_OPEN, GerritUi.getImageDescriptor(String.valueOf(iconPath) + STAR_OPEN));
    }

    private Image getReviewStateImage(int aState) {
        switch (aState) {
            case 2: {
                return fImageRegistry.get(CHECKED_IMAGE);
            }
            case 1: {
                return fImageRegistry.get(PLUS_ONE);
            }
            case 0: {
                break;
            }
            case -1: {
                return fImageRegistry.get(MINUS_ONE);
            }
            case -2: {
                return fImageRegistry.get(NOT_OK_IMAGE);
            }
        }
        return null;
    }

    private Image getVerifyStateImage(int aState) {
        switch (aState) {
            case 1: 
            case 2: {
                return fImageRegistry.get(CHECKED_IMAGE);
            }
            case 0: {
                break;
            }
            case -2: 
            case -1: {
                return fImageRegistry.get(NOT_OK_IMAGE);
            }
        }
        return null;
    }

    private Image getReviewId(Boolean aState) {
        if (aState.booleanValue()) {
            return fImageRegistry.get(STAR_FILLED);
        }
        return fImageRegistry.get(STAR_OPEN);
    }

    public String getColumnText(Object aObj, int aIndex) {
        if (aObj instanceof GerritTask) {
            GerritTask reviewSummary = (GerritTask)aObj;
            switch (aIndex) {
                case 0: {
                    return reviewSummary.getAttribute(GerritTask.IS_STARRED);
                }
                case 1: {
                    return reviewSummary.getAttribute("task.common.key");
                }
                case 2: {
                    return reviewSummary.getAttribute("task.common.summary");
                }
                case 3: {
                    String attribute = reviewSummary.getAttribute(GerritTask.STATUS);
                    return attribute;
                }
                case 4: {
                    return reviewSummary.getAttribute(GerritTask.OWNER);
                }
                case 5: {
                    return reviewSummary.getAttribute("task.common.product");
                }
                case 6: {
                    String branch = reviewSummary.getAttribute(GerritTask.BRANCH);
                    String topic = reviewSummary.getAttribute(GerritTask.TOPIC);
                    if (topic != null && !topic.isEmpty()) {
                        branch = String.valueOf(branch) + " (" + reviewSummary.getAttribute(GerritTask.TOPIC) + ")";
                    }
                    return branch;
                }
                case 7: {
                    return reviewSummary.getAttributeAsDate("task.common.date.modified");
                }
            }
            return "";
        }
        return "";
    }

    public Image getColumnImage(Object aObj, int aIndex) {
        String value = null;
        if (aObj instanceof GerritTask) {
            GerritTask reviewSummary = (GerritTask)aObj;
            switch (aIndex) {
                case 0: {
                    value = reviewSummary.getAttribute(GerritTask.IS_STARRED);
                    if (value == null || value.equals("")) break;
                    return this.getReviewId(Boolean.valueOf(value.toLowerCase()));
                }
                case 8: {
                    value = reviewSummary.getAttribute(GerritTask.REVIEW_STATE);
                    if (value == null || value.equals("")) break;
                    int val = Integer.parseInt(value);
                    return this.getReviewStateImage(val);
                }
                case 9: {
                    value = reviewSummary.getAttribute(GerritTask.VERIFY_STATE);
                    if (value == null || value.equals("")) break;
                    int val = Integer.parseInt(value);
                    return this.getVerifyStateImage(val);
                }
            }
        }
        return null;
    }

    public Color getForeground(Object aElement, int aColumnIndex) {
        if (aElement instanceof GerritTask) {
            int value = 0;
            if (aColumnIndex == ReviewTableDefinition.CR.ordinal() || aColumnIndex == ReviewTableDefinition.VERIFY.ordinal()) {
                switch (aColumnIndex) {
                    case 7: {
                        break;
                    }
                }
                if (value < 0) {
                    return RED;
                }
                if (value > 0) {
                    return GREEN;
                }
            }
        }
        return null;
    }

    public Color getBackground(Object aElement, int aColumnIndex) {
        GerritTask item;
        String state;
        if (aElement instanceof GerritTask && (state = (item = (GerritTask)aElement).getAttribute(GerritTask.IS_STARRED)) != null) {
            if (state.equals(Boolean.toString(true))) {
                return INCOMING_COLOR;
            }
            if (state.equals(Boolean.toString(false))) {
                return CLOSED_COLOR;
            }
        }
        return DEFAULT_COLOR;
    }
}

