/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.osgi.util.NLS;
import org.gradle.tooling.GradleConnector;

public final class RemoteGradleDistribution
extends GradleDistribution {
    private final URI url;

    RemoteGradleDistribution(URI url) {
        this.url = (URI)Preconditions.checkNotNull((Object)url);
    }

    public URI getUrl() {
        return this.url;
    }

    @Override
    public void apply(GradleConnector connector) {
        connector.useDistribution(this.url);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteGradleDistribution other = (RemoteGradleDistribution)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return String.format("GRADLE_DISTRIBUTION(REMOTE_DISTRIBUTION(%s))", this.url.toString());
    }

    @Override
    public String getDisplayName() {
        return NLS.bind((String)CoreMessages.GradleDistribution_Value_UseRemoteDistribution_0, (Object)this.url.toString());
    }
}

