/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.DiscardChangesOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CommandConfirmation;
import org.eclipse.egit.ui.internal.operations.GitScopeUtil;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.ui.IWorkbenchPart;

public class DiscardChangesActionHandler
extends RepositoryActionHandler {
    private boolean hasDirectories;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.mySelection = DiscardChangesActionHandler.getSelection(event);
        try {
            IWorkbenchPart part = this.getPart(event);
            DiscardChangesOperation operation = this.createOperation(part, event);
            if (operation == null) {
                return null;
            }
            Map paths = operation.getPathsPerRepository();
            if (!CommandConfirmation.confirmCheckout(this.getShell(event), paths, !this.hasDirectories)) {
                return null;
            }
            JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)UIText.DiscardChangesAction_discardChanges, (Object)JobFamilies.DISCARD_CHANGES);
            return null;
        }
        finally {
            this.mySelection = null;
        }
    }

    @Override
    public boolean isEnabled() {
        Repository[] repositories = this.getRepositories();
        if (repositories.length == 0) {
            return false;
        }
        Repository[] repositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repository = repositoryArray[n2];
            if (!repository.getRepositoryState().equals((Object)RepositoryState.SAFE)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private DiscardChangesOperation createOperation(IWorkbenchPart part, ExecutionEvent event) throws ExecutionException {
        IResource[] resourcesInScope;
        String revision;
        IResource[] selectedResources = this.gatherResourceToOperateOn(event);
        try {
            revision = this.gatherRevision(event);
        }
        catch (OperationCanceledException e) {
            return null;
        }
        try {
            resourcesInScope = GitScopeUtil.getRelatedChanges(part, selectedResources);
        }
        catch (InterruptedException e) {
            return null;
        }
        this.hasDirectories = Stream.of(resourcesInScope).anyMatch(rsc -> rsc.getType() != 1);
        return new DiscardChangesOperation(resourcesInScope, revision);
    }

    protected IResource[] gatherResourceToOperateOn(ExecutionEvent event) throws ExecutionException {
        return this.getSelectedResources(event);
    }

    protected String gatherRevision(ExecutionEvent event) throws ExecutionException {
        return null;
    }
}

