/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.internal.block;

import org.eclipse.mylyn.wikitext.confluence.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.confluence.internal.block.AbstractConfluenceDelimitedBlock;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class ExtendedQuoteBlock
extends AbstractConfluenceDelimitedBlock {
    private int paraLine = 0;
    private boolean paraOpen = false;
    private Block nestedBlock = null;

    public ExtendedQuoteBlock() {
        super("quote");
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.paraOpen = false;
        this.paraLine = 0;
        this.nestedBlock = null;
    }

    @Override
    protected void beginBlock() {
        Attributes attributes = new Attributes();
        this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, attributes);
    }

    @Override
    protected void endBlock() {
        if (this.nestedBlock != null) {
            this.nestedBlock.setClosed(true);
            this.nestedBlock = null;
        }
        if (this.paraOpen) {
            this.builder.endBlock();
            this.paraLine = 0;
            this.paraOpen = false;
        }
        this.builder.endBlock();
    }

    @Override
    protected int handleBlockContent(String content) {
        if (this.nestedBlock == null) {
            ConfluenceLanguage markupLanguage = (ConfluenceLanguage)this.getMarkupLanguage();
            for (Block block : markupLanguage.getNestedBlocks()) {
                if (!block.canStart(content, 0)) continue;
                this.nestedBlock = block.clone();
                this.nestedBlock.setParser(this.getParser());
                this.nestedBlock.setState(this.getState());
                if (!this.paraOpen) break;
                this.builder.endBlock();
                this.paraOpen = false;
                this.paraLine = 0;
                break;
            }
        }
        if (this.nestedBlock != null) {
            int lineOffset = this.nestedBlock.processLine(content, 0);
            if (this.nestedBlock.isClosed()) {
                this.nestedBlock = null;
            }
            if (lineOffset < content.length() && lineOffset >= 0) {
                return lineOffset;
            }
            return -1;
        }
        if (this.blockLineCount == 1 && content.length() == 0) {
            return -1;
        }
        if (this.blockLineCount > 1 && this.paraOpen && this.getMarkupLanguage().isEmptyLine(content)) {
            this.builder.endBlock();
            this.paraOpen = false;
            this.paraLine = 0;
            return -1;
        }
        if (!this.paraOpen) {
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
            this.paraOpen = true;
        }
        if (this.paraLine != 0) {
            this.builder.lineBreak();
        }
        ++this.paraLine;
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, content, 0);
        return -1;
    }

    public int findCloseOffset(String line, int lineOffset) {
        if (this.nestedBlock == null) {
            return super.findCloseOffset(line, lineOffset);
        }
        return this.nestedBlock.findCloseOffset(line, lineOffset);
    }

    public boolean beginNesting() {
        if (this.nestedBlock == null) {
            return super.beginNesting();
        }
        return this.nestedBlock.beginNesting();
    }

    public boolean canResume(String line, int lineOffset) {
        if (this.nestedBlock == null) {
            return super.canResume(line, lineOffset);
        }
        return this.nestedBlock.canResume(line, lineOffset);
    }

    @Override
    protected void setOption(String key, String value) {
    }
}

