/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.PositionSpan;
import org.apache.lucene.search.highlight.SpanScorer;
import org.apache.lucene.search.highlight.WeightedSpanTerm;

public class SimpleSpanFragmenter
implements Fragmenter {
    private static final int DEFAULT_FRAGMENT_SIZE = 100;
    private int fragmentSize;
    private int currentNumFrags;
    private int position = -1;
    private SpanScorer spanScorer;
    private int waitForPos = -1;

    public SimpleSpanFragmenter(SpanScorer spanscorer) {
        this(spanscorer, 100);
    }

    public SimpleSpanFragmenter(SpanScorer spanscorer, int fragmentSize) {
        this.fragmentSize = fragmentSize;
        this.spanScorer = spanscorer;
    }

    public boolean isNewFragment(Token token) {
        boolean isNewFrag;
        this.position += token.getPositionIncrement();
        if (this.waitForPos == this.position) {
            this.waitForPos = -1;
        } else if (this.waitForPos != -1) {
            return false;
        }
        WeightedSpanTerm wSpanTerm = this.spanScorer.getWeightedSpanTerm(token.term());
        if (wSpanTerm != null) {
            List positionSpans = wSpanTerm.getPositionSpans();
            for (int i = 0; i < positionSpans.size(); ++i) {
                if (((PositionSpan)positionSpans.get((int)i)).start != this.position) continue;
                this.waitForPos = ((PositionSpan)positionSpans.get((int)i)).end + 1;
                return true;
            }
        }
        boolean bl = isNewFrag = token.endOffset() >= this.fragmentSize * this.currentNumFrags;
        if (isNewFrag) {
            ++this.currentNumFrags;
        }
        return isNewFrag;
    }

    public void start(String originalText) {
        this.position = 0;
        this.currentNumFrags = 1;
    }
}

