/*******************************************************************************
 * Copyright (c) 2004, 2009 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.impl.query.DrillQueryHelper;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.BirtDimensionView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;
import org.eclipse.birt.data.engine.olap.query.view.DrillCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.query.view.Relationship;


public class DrilledAggregationAccessor extends Accessor
{
	private CubeCursor baseCursor;
	private BirtCubeView baseView;
	private BirtCubeView[] drillView;
	
	public DrilledAggregationAccessor( CubeCursor baseCursor,
			BirtCubeView baseView, DrillQueryHelper drillQueryHelper ) throws DataException
	{
		this.baseCursor = baseCursor;
		this.baseView = baseView;
		this.drillView = drillQueryHelper.getAllCubeViews( );
	}

	public void close( ) throws OLAPException
	{
	}

	public Object getObject( int arg0 ) throws OLAPException
	{
		try
		{
			String aggrName = this.baseView.getAggregationRegisterTable( )
					.getAggrName( arg0 );
			return getObject( aggrName );
		}
		catch ( DataException e )
		{
		}
		return null;
	}

	public Object getObject( String arg0 ) throws OLAPException
	{
		List columnDimList = null, rowDimList = null, pageDimList = null;

		List columnLevelList = new ArrayList( );
		List rowLevelList = new ArrayList( );
		if ( this.baseView.getRowEdgeView( ) != null )
		{
			EdgeCursor rowEdgeCursor = (EdgeCursor) ( (BirtEdgeView) this.baseView.getRowEdgeView( ) ).getEdgeCursor( );
			if ( rowEdgeCursor != null
					&& !rowEdgeCursor.isBeforeFirst( )
					&& !rowEdgeCursor.isAfterLast( ) )
			{
				rowDimList = rowEdgeCursor.getDimensionCursor( );
				List dimensionView = this.baseView.getRowEdgeView( )
						.getDimensionViews( );
				for ( int i = 0; i < dimensionView.size( ); i++ )
				{
					BirtDimensionView view = (BirtDimensionView) dimensionView.get( i );
					rowLevelList.addAll( view.getMemberSelection( ) );
				}
			}
		}
		if ( this.baseView.getColumnEdgeView( ) != null )
		{
			EdgeCursor columnEdgeCursor = (EdgeCursor) ( (BirtEdgeView) this.baseView.getColumnEdgeView( ) ).getEdgeCursor( );
			if ( columnEdgeCursor != null
					&& !columnEdgeCursor.isBeforeFirst( )
					&& !columnEdgeCursor.isAfterLast( ) )
			{
				columnDimList = columnEdgeCursor.getDimensionCursor( );
				List dimensionView = this.baseView.getColumnEdgeView( )
						.getDimensionViews( );
				for ( int i = 0; i < dimensionView.size( ); i++ )
				{
					BirtDimensionView view = (BirtDimensionView) dimensionView.get( i );
					columnLevelList.addAll( view.getMemberSelection( ) );
				}
			}
		}

		Object[][] columnValue = new Object[columnLevelList.size( )][];
		Object[][] rowValue = new Object[rowLevelList.size( )][];

		for ( int i = 0; i < columnLevelList.size( ); i++ )
		{
			DimensionCursor cursor = (DimensionCursor) columnDimList.get( i );
			Object value = cursor.getObject( ( (ILevelDefinition) columnLevelList.get( i ) ).getName( ) );
			columnValue[i] = new Object[]{
				value
			};
		}
		for ( int i = 0; i < rowLevelList.size( ); i++ )
		{
			DimensionCursor cursor = (DimensionCursor) rowDimList.get( i );
			Object value = cursor.getObject( ( (ILevelDefinition) rowLevelList.get( i ) ).getName( ) );
			rowValue[i] = new Object[]{
				value
			};
		}

		//find the cursor based on the current value on column/row edge
		int index = findDrillCursorIndex( columnValue, rowValue );
		if ( index < 0 )
			return this.baseCursor.getObject( arg0 );
		else
		{
			rowLevelList.clear( );
			columnLevelList.clear( );
			try
			{
				Map referedLevel = this.drillView[index].getReferencedLevels( );
				Relationship relation = (Relationship) referedLevel.get( arg0 );
				if ( relation == null )
				{
					// the aggregation only contains in base cursor.
					return this.baseCursor.getObject( arg0 );
				}
				rowLevelList = relation.getLevelListOnRow( );
				columnLevelList = relation.getLevelListOnColumn( );
			}
			catch ( DataException e2 )
			{
			}

			columnValue = new Object[columnLevelList.size( )][];
			rowValue = new Object[rowLevelList.size( )][];

			for ( int i = 0; i < columnLevelList.size( ); i++ )
			{
				DimensionCursor cursor = (DimensionCursor) columnDimList.get( i );
				Object value = cursor.getObject( ( (DimLevel) columnLevelList.get( i ) ).getLevelName( ) );
				columnValue[i] = new Object[]{
					value
				};
			}
			for ( int i = 0; i < rowLevelList.size( ); i++ )
			{
				DimensionCursor cursor = (DimensionCursor) rowDimList.get( i );
				Object value = cursor.getObject( ( (DimLevel) rowLevelList.get( i ) ).getLevelName( ) );
				rowValue[i] = new Object[]{
					value
				};
			}
			
			
			EdgeCursor columnCursor = null, rowCursor = null;
			List ordinateEdge;
			try
			{
				ordinateEdge = drillView[index].getCubeCursor( null, null, false )
						.getOrdinateEdge( );
				if ( drillView[index].getColumnEdgeView( ) != null )
				{
					columnCursor = (EdgeCursor) ordinateEdge.get( 0 );
					if ( drillView[index].getRowEdgeView( ) != null )
					{
						rowCursor = (EdgeCursor) ordinateEdge.get( 1 );
					}
				}
				else
				{
					if ( drillView[index].getRowEdgeView( ) != null )
					{
						rowCursor = (EdgeCursor) ordinateEdge.get( 0 );
					}
				}
			}
			catch ( DataException e1 )
			{
				throw new OLAPException( e1.getLocalizedMessage( ) );
			}
			
			boolean flag = true;
			if ( !columnLevelList.isEmpty( ) && columnCursor!= null )
			{
				try
				{
					IAggregationResultSet rs = drillView[index].getColumnEdgeView( )
							.getEdgeAxis( )
							.getQueryResultSet( );
					if ( rs.length( ) == 0 )
						return null;

					for ( int i = 0; i < rs.length( ); i++ )
					{
						rs.seek( i );
						for ( int j = 0; j < columnLevelList.size( ); j++ )
						{
							Object[] key = rs.getLevelKeyValue( rs.getLevelIndex( (DimLevel) columnLevelList.get( j ) ) );
							if ( isEuqalObjectArray( key, columnValue[j] ) )
							{
								flag = true;
								continue;
							}
							else
							{
								flag = false;
								break;
							}
						}
						if( flag )
							break;
					}
					if ( !flag )
					{
						return null;
					}
					else
						columnCursor.setPosition( rs.getPosition( ) );
				}
				catch ( IOException e )
				{
				}

			}
			if ( !rowLevelList.isEmpty( ) && rowCursor!= null )
			{
				try
				{
					IAggregationResultSet rs = drillView[index].getRowEdgeView( )
							.getEdgeAxis( )
							.getQueryResultSet( );

					for ( int i = 0; i < rs.length( ); i++ )
					{
						rs.seek( i );
						for ( int j = 0; j < rowLevelList.size( ); j++ )
						{
							Object[] key = rs.getLevelKeyValue( rs.getLevelIndex( (DimLevel) rowLevelList.get( j ) ) );
							if ( this.isDrilledElement( key, rowValue[j] ) )
							{
								flag = true;
								continue;
							}
							else
							{
								flag = false;
								break;
							}
						}
						if ( flag )
							break;
					}
					if ( !flag )
					{
						return null;
					}
					else
						rowCursor.setPosition( rs.getPosition( ) );
				}
				catch ( IOException e )
				{
				}
			}
			
			try
			{
				return this.drillView[index].getCubeCursor( null, null, false )
						.getObject( arg0 );
			}
			catch ( DataException e )
			{
				throw new OLAPException( e.getLocalizedMessage( ) );
			}
		}
	}

	private int findDrillCursorIndex( Object[][] columnValue,
			Object[][] rowValue )
	{
		int cursorIndex = -1;
		
		for ( int index = this.drillView.length - 1; index >= 0; index-- )
		{
			boolean flag = true;

			ICubeQueryDefinition query = drillView[index].getCubeQueryDefinition( );
			Iterator column = ( (DrillCubeQueryDefinition) query ).getTupleOnColumn( )
					.iterator( );

			int count = 0;
			while ( column.hasNext( ) )
			{
				Object[] key = (Object[]) column.next( );
				if ( key == null || key.length == 0 || key[0] == null )
				{
					count++;
					continue;
				}
				if ( columnValue.length > count
						&& isDrilledElement( key, columnValue[count] ) )
				{
					count++;
					continue;
				}
				else
				{
					flag = false;
					break;
				}
			}
			if ( flag )
			{
				Iterator row = ( (DrillCubeQueryDefinition) query ).getTupleOnRow( )
						.iterator( );
				count = 0;
				while ( row.hasNext( ) )
				{
					Object[] key = (Object[]) row.next( );
					if ( key == null || key.length == 0 || key[0] == null )
					{
						break;
					}
					if ( rowValue.length > count
							&& isDrilledElement( key, rowValue[count] ) )
					{
						count++;
						continue;
					}
					else
					{
						flag = false;
					}
				}
			}
			if ( flag )
			{
				cursorIndex = index;
				break;
			}
		}
		return cursorIndex;
	}
	
	private boolean isDrilledElement( Object[] drilledObject, Object[] obj2 )
	{
		for ( int i = 0; i < drilledObject.length; i++ )
		{
			if ( drilledObject[i] == null )
				return true;
			if ( drilledObject[i].equals( obj2[0] ) )
			{
				return true;
			}
		}
		return false;
	}
	
	private boolean isEuqalObjectArray( Object[] obj1, Object[] obj2 )
	{
		if ( obj1.length != obj2.length )
			return false;
		for ( int i = 0; i < obj1.length; i++ )
		{
			if ( !obj1[i].equals( obj2[i] ) )
				return false;
		}
		return true;
	}
}
