/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;

public class BreakContinueTargetFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String ID = "BreakContinueTargetFinder";
    private ASTNode fSelected;
    private boolean fIsBreak;
    private SimpleName fLabel;
    private String fDescription;
    private CompilationUnit fASTRoot;
    private static final Class[] STOPPERS;
    private static final Class[] BREAKTARGETS;
    private static final Class[] CONTINUETARGETS;
    private static final int BRACE_LENGTH = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.Initializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        STOPPERS = classArray;
        Class[] classArray2 = new Class[5];
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jdt.core.dom.ForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.jdt.core.dom.EnhancedForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[1] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.jdt.core.dom.WhileStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[2] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.jdt.core.dom.DoStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[3] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.jdt.core.dom.SwitchStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[4] = clazz7;
        BREAKTARGETS = classArray2;
        Class[] classArray3 = new Class[4];
        Class<?> clazz8 = class$2;
        if (clazz8 == null) {
            try {
                clazz8 = class$2 = Class.forName("org.eclipse.jdt.core.dom.ForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[0] = clazz8;
        Class<?> clazz9 = class$3;
        if (clazz9 == null) {
            try {
                clazz9 = class$3 = Class.forName("org.eclipse.jdt.core.dom.EnhancedForStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[1] = clazz9;
        Class<?> clazz10 = class$4;
        if (clazz10 == null) {
            try {
                clazz10 = class$4 = Class.forName("org.eclipse.jdt.core.dom.WhileStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[2] = clazz10;
        Class<?> clazz11 = class$5;
        if (clazz11 == null) {
            try {
                clazz11 = class$5 = Class.forName("org.eclipse.jdt.core.dom.DoStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[3] = clazz11;
        CONTINUETARGETS = classArray3;
    }

    public String initialize(CompilationUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, (int)offset, (int)length));
    }

    public String initialize(CompilationUnit root, ASTNode node) {
        ASTNode controlNode = this.getBreakOrContinueNode(node);
        if (controlNode != null) {
            this.fASTRoot = root;
            try {
                if (root.getTypeRoot() == null || root.getTypeRoot().getBuffer() == null) {
                    return SearchMessages.BreakContinueTargetFinder_cannot_highlight;
                }
            }
            catch (JavaModelException javaModelException) {
                return SearchMessages.BreakContinueTargetFinder_cannot_highlight;
            }
            this.fSelected = controlNode;
            this.fIsBreak = this.fSelected instanceof BreakStatement;
            this.fLabel = this.getLabel();
            this.fDescription = Messages.format(SearchMessages.BreakContinueTargetFinder_occurrence_description, BasicElementLabels.getJavaElementName(ASTNodes.asString(this.fSelected)));
            return null;
        }
        return SearchMessages.BreakContinueTargetFinder_no_break_or_continue_selected;
    }

    private ASTNode getBreakOrContinueNode(ASTNode selectedNode) {
        if (selectedNode instanceof BreakStatement) {
            return selectedNode;
        }
        if (selectedNode instanceof ContinueStatement) {
            return selectedNode;
        }
        if (selectedNode instanceof SimpleName && selectedNode.getParent() instanceof BreakStatement) {
            return selectedNode.getParent();
        }
        if (selectedNode instanceof SimpleName && selectedNode.getParent() instanceof ContinueStatement) {
            return selectedNode.getParent();
        }
        return null;
    }

    private SimpleName getLabel() {
        if (this.fIsBreak) {
            BreakStatement bs = (BreakStatement)this.fSelected;
            return bs.getLabel();
        }
        ContinueStatement cs = (ContinueStatement)this.fSelected;
        return cs.getLabel();
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        ASTNode targetNode = this.findTargetNode(this.fSelected);
        if (!this.isEnclosingStatement(targetNode)) {
            return null;
        }
        ArrayList<IOccurrencesFinder.OccurrenceLocation> list = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
        IOccurrencesFinder.OccurrenceLocation location = this.getLocationForFirstToken(targetNode);
        if (location != null) {
            list.add(location);
        }
        if (this.fIsBreak && (location = this.getLocationForClosingBrace(targetNode)) != null) {
            list.add(location);
        }
        if (!list.isEmpty()) {
            return list.toArray(new IOccurrencesFinder.OccurrenceLocation[list.size()]);
        }
        return null;
    }

    private boolean isEnclosingStatement(ASTNode targetNode) {
        return targetNode != null && !(targetNode instanceof MethodDeclaration) && !(targetNode instanceof Initializer);
    }

    private ASTNode findTargetNode(ASTNode node) {
        while (this.keepWalkingUp(node = node.getParent())) {
        }
        return node;
    }

    private IOccurrencesFinder.OccurrenceLocation getLocationForFirstToken(ASTNode node) {
        try {
            int nextEndOffset = new TokenScanner(this.fASTRoot.getTypeRoot()).getNextEndOffset(node.getStartPosition(), true);
            return new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), nextEndOffset - node.getStartPosition(), 0, this.fDescription);
        }
        catch (CoreException coreException) {
            return new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), node.getLength(), 0, this.fDescription);
        }
    }

    private IOccurrencesFinder.OccurrenceLocation getLocationForClosingBrace(ASTNode targetNode) {
        int offset = ASTNodes.getExclusiveEnd(targetNode) - 1;
        return new IOccurrencesFinder.OccurrenceLocation(offset, 1, 0, this.fDescription);
    }

    private boolean keepWalkingUp(ASTNode node) {
        if (node == null) {
            return false;
        }
        if (BreakContinueTargetFinder.isAnyInstanceOf(STOPPERS, node)) {
            return false;
        }
        if (this.fLabel != null) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("org.eclipse.jdt.core.dom.LabeledStatement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isInstance(node)) {
                LabeledStatement ls = (LabeledStatement)node;
                return !BreakContinueTargetFinder.areEqualLabels(ls.getLabel(), this.fLabel);
            }
        }
        if (this.fLabel == null && this.fIsBreak && BreakContinueTargetFinder.isAnyInstanceOf(BREAKTARGETS, node)) {
            return false;
        }
        return this.fLabel != null || this.fIsBreak || !BreakContinueTargetFinder.isAnyInstanceOf(CONTINUETARGETS, node);
    }

    private static boolean areEqualLabels(SimpleName labelToMatch, SimpleName labelSelected) {
        return labelSelected.getIdentifier().equals(labelToMatch.getIdentifier());
    }

    private static boolean isAnyInstanceOf(Class[] continueTargets, ASTNode node) {
        int i = 0;
        while (i < continueTargets.length) {
            if (continueTargets[i].isInstance(node)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public CompilationUnit getASTRoot() {
        return this.fASTRoot;
    }

    public String getElementName() {
        return ASTNodes.asString(this.fSelected);
    }

    public String getID() {
        return ID;
    }

    public String getJobLabel() {
        return SearchMessages.BreakContinueTargetFinder_job_label;
    }

    public int getSearchKind() {
        return 9;
    }

    public String getUnformattedPluralLabel() {
        if (this.fIsBreak) {
            return SearchMessages.BreakContinueTargetFinder_break_label_plural;
        }
        return SearchMessages.BreakContinueTargetFinder_continue_label_plural;
    }

    public String getUnformattedSingularLabel() {
        if (this.fIsBreak) {
            return SearchMessages.BreakContinueTargetFinder_break_label_singular;
        }
        return SearchMessages.BreakContinueTargetFinder_continue_label_singular;
    }
}

