/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class CommentsTabPage
extends FormatterTabPage {
    private final String PREVIEW = String.valueOf(CommentsTabPage.createPreviewHeader("An example for comment formatting. This example is meant to illustrate the various possibilities offered by <i>Eclipse</i> in order to format comments.")) + "package mypackage;\n" + "/**\n" + " * This is the comment for the example interface.\n" + " */\n" + " interface Example {\n" + "// This is a long comment    with\twhitespace     that should be split in multiple line comments in case the line comment formatting is enabled\n" + "int foo3();\n" + " \n" + "//\tvoid commented() {\n" + "//\t\t\tSystem.out.println(\"indented\");\n" + "//\t}\n" + "\n" + "\t//\tvoid indentedCommented() {\n" + "\t//\t\t\tSystem.out.println(\"indented\");\n" + "\t//\t}\n" + "\n" + "/* block comment          on first column*/\n" + " int bar();\n" + "\t/*\n" + "\t*\n" + "\t* These possibilities include:\n" + "\t* <ul><li>Formatting of header comments.</li><li>Formatting of Javadoc tags</li></ul>\n" + "\t*/\n" + " int bar2(); // This is a long comment that should be split in multiple line comments in case the line comment formatting is enabled\n" + " /**\n" + " * The following is some sample code which illustrates source formatting within javadoc comments:\n" + " * <pre>public class Example {final int a= 1;final boolean b= true;}</pre>\n" + " * Descriptions of parameters and return values are best appended at end of the javadoc comment.\n" + " * @param a The first parameter. For an optimum result, this should be an odd number\n" + " * between 0 and 100.\n" + " * @param b The second parameter.\n" + " * @return The result of the foo operation, usually within 0 and 1000.\n" + " */" + " int foo(int a, int b);\n" + "}";
    private CompilationUnitPreview fPreview;

    public CommentsTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(4);
        Group globalGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group1_title);
        final ModifyDialogTabPage.CheckboxPreference javadoc = this.createPrefFalseTrue((Composite)globalGroup, numColumns, FormatterMessages.commentsTabPage_enable_javadoc_comment_formatting, "org.eclipse.jdt.core.formatter.comment.format_javadoc_comments", false);
        ModifyDialogTabPage.CheckboxPreference blockComment = this.createPrefFalseTrue((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_enable_block_comment_formatting, "org.eclipse.jdt.core.formatter.comment.format_block_comments", false);
        final ModifyDialogTabPage.CheckboxPreference singleLineComments = this.createPrefFalseTrue((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_enable_line_comment_formatting, "org.eclipse.jdt.core.formatter.comment.format_line_comments", false);
        ModifyDialogTabPage.CheckboxPreference singleLineCommentsOnFirstColumn = this.createPrefFalseTrue((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_format_line_comments_on_first_column, "org.eclipse.jdt.core.formatter.format_line_comment_starting_on_first_column", false);
        ((GridData)singleLineCommentsOnFirstColumn.getControl().getLayoutData()).horizontalIndent = indent;
        final ModifyDialogTabPage.CheckboxPreference header = this.createPrefFalseTrue((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_format_header, "org.eclipse.jdt.core.formatter.comment.format_header", false);
        GridData spacerData = new GridData(0, 0);
        spacerData.horizontalSpan = numColumns;
        new Composite((Composite)globalGroup, 0).setLayoutData((Object)spacerData);
        this.createPrefFalseTrue((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_never_indent_block_comments_on_first_column, "org.eclipse.jdt.core.formatter.never_indent_block_comments_on_first_column", false);
        this.createPrefFalseTrue((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_never_indent_line_comments_on_first_column, "org.eclipse.jdt.core.formatter.never_indent_line_comments_on_first_column", false);
        this.createPrefFalseTrue((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_do_not_join_lines, "org.eclipse.jdt.core.formatter.join_lines_in_comments", true);
        Group settingsGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group2_title);
        ModifyDialogTabPage.CheckboxPreference html = this.createPrefFalseTrue((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_format_html, "org.eclipse.jdt.core.formatter.comment.format_html", false);
        ModifyDialogTabPage.CheckboxPreference code = this.createPrefFalseTrue((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_format_code_snippets, "org.eclipse.jdt.core.formatter.comment.format_source_code", false);
        ModifyDialogTabPage.CheckboxPreference blankJavadoc = this.createPrefInsert((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_blank_line_before_javadoc_tags, "org.eclipse.jdt.core.formatter.comment.insert_new_line_before_root_tags");
        final ModifyDialogTabPage.CheckboxPreference indentJavadoc = this.createPrefFalseTrue((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_indent_javadoc_tags, "org.eclipse.jdt.core.formatter.comment.indent_root_tags", false);
        ModifyDialogTabPage.CheckboxPreference indentDesc = this.createPrefFalseTrue((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_indent_description_after_param, "org.eclipse.jdt.core.formatter.comment.indent_parameter_description", false);
        ((GridData)indentDesc.getControl().getLayoutData()).horizontalIndent = indent;
        ModifyDialogTabPage.CheckboxPreference nlParam = this.createPrefInsert((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_new_line_after_param_tags, "org.eclipse.jdt.core.formatter.comment.insert_new_line_for_parameter");
        ModifyDialogTabPage.CheckboxPreference nlBoundariesJavadoc = this.createPrefFalseTrue((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_new_lines_at_javadoc_boundaries, "org.eclipse.jdt.core.formatter.comment.new_lines_at_javadoc_boundaries", false);
        ModifyDialogTabPage.CheckboxPreference blankLinesJavadoc = this.createPrefFalseTrue((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_clear_blank_lines, "org.eclipse.jdt.core.formatter.comment.clear_blank_lines_in_javadoc_comment", false);
        Group blockSettingsGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group4_title);
        ModifyDialogTabPage.CheckboxPreference nlBoundariesBlock = this.createPrefFalseTrue((Composite)blockSettingsGroup, numColumns, FormatterMessages.CommentsTabPage_new_lines_at_comment_boundaries, "org.eclipse.jdt.core.formatter.comment.new_lines_at_block_boundaries", false);
        ModifyDialogTabPage.CheckboxPreference blankLinesBlock = this.createPrefFalseTrue((Composite)blockSettingsGroup, numColumns, FormatterMessages.CommentsTabPage_remove_blank_block_comment_lines, "org.eclipse.jdt.core.formatter.comment.clear_blank_lines_in_block_comment", false);
        Group widthGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group3_title);
        ModifyDialogTabPage.NumberPreference lineWidth = this.createNumberPref((Composite)widthGroup, numColumns, FormatterMessages.CommentsTabPage_line_width, "org.eclipse.jdt.core.formatter.comment.line_length", 0, 9999);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> lineFirstColumnMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        lineFirstColumnMasters.add(singleLineComments);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> lineFirstColumnSlaves = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        lineFirstColumnSlaves.add(singleLineCommentsOnFirstColumn);
        new Controller(lineFirstColumnMasters, lineFirstColumnSlaves){

            protected boolean areSlavesEnabled() {
                return singleLineComments.getChecked();
            }
        }.update(null, null);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> javaDocMaster = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        javaDocMaster.add(javadoc);
        javaDocMaster.add(header);
        ArrayList<Object> javaDocSlaves = new ArrayList<Object>();
        javaDocSlaves.add(settingsGroup);
        javaDocSlaves.add(html);
        javaDocSlaves.add(code);
        javaDocSlaves.add(blankJavadoc);
        javaDocSlaves.add(indentJavadoc);
        javaDocSlaves.add(nlParam);
        javaDocSlaves.add(nlBoundariesJavadoc);
        javaDocSlaves.add(blankLinesJavadoc);
        new OrController(javaDocMaster, javaDocSlaves);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> indentMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        indentMasters.add(javadoc);
        indentMasters.add(header);
        indentMasters.add(indentJavadoc);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> indentSlaves = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        indentSlaves.add(indentDesc);
        new Controller(indentMasters, indentSlaves){

            protected boolean areSlavesEnabled() {
                return (javadoc.getChecked() || header.getChecked()) && indentJavadoc.getChecked();
            }
        }.update(null, null);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> blockMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        blockMasters.add(blockComment);
        blockMasters.add(header);
        ArrayList<Object> blockSlaves = new ArrayList<Object>();
        blockSlaves.add(blockSettingsGroup);
        blockSlaves.add(nlBoundariesBlock);
        blockSlaves.add(blankLinesBlock);
        new OrController(blockMasters, blockSlaves);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> lineWidthMasters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        lineWidthMasters.add(javadoc);
        lineWidthMasters.add(blockComment);
        lineWidthMasters.add(singleLineComments);
        lineWidthMasters.add(header);
        ArrayList<Object> lineWidthSlaves = new ArrayList<Object>();
        lineWidthSlaves.add(widthGroup);
        lineWidthSlaves.add(lineWidth);
        new OrController(lineWidthMasters, lineWidthSlaves);
    }

    protected void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        super.doUpdatePreview();
        this.fPreview.update();
    }

    private ModifyDialogTabPage.CheckboxPreference createPrefFalseTrue(Composite composite, int numColumns, String text, String key, boolean invertPreference) {
        if (invertPreference) {
            return this.createCheckboxPref(composite, numColumns, text, key, TRUE_FALSE);
        }
        return this.createCheckboxPref(composite, numColumns, text, key, FALSE_TRUE);
    }

    private ModifyDialogTabPage.CheckboxPreference createPrefInsert(Composite composite, int numColumns, String text, String key) {
        return this.createCheckboxPref(composite, numColumns, text, key, DO_NOT_INSERT_INSERT);
    }

    private static abstract class Controller
    implements Observer {
        private final Collection fMasters;
        private final Collection fSlaves;

        public Controller(Collection masters, Collection slaves) {
            this.fMasters = masters;
            this.fSlaves = slaves;
            Iterator iter = this.fMasters.iterator();
            while (iter.hasNext()) {
                ((ModifyDialogTabPage.CheckboxPreference)iter.next()).addObserver(this);
            }
        }

        public void update(Observable o, Object arg) {
            boolean enabled = this.areSlavesEnabled();
            Iterator iter = this.fSlaves.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof ModifyDialogTabPage.Preference) {
                    ((ModifyDialogTabPage.Preference)obj).setEnabled(enabled);
                    continue;
                }
                if (!(obj instanceof Control)) continue;
                ((Group)obj).setEnabled(enabled);
            }
        }

        public Collection getMasters() {
            return this.fMasters;
        }

        protected abstract boolean areSlavesEnabled();
    }

    private static final class OrController
    extends Controller {
        public OrController(Collection masters, Collection slaves) {
            super(masters, slaves);
            this.update(null, null);
        }

        protected boolean areSlavesEnabled() {
            Iterator iter = this.getMasters().iterator();
            while (iter.hasNext()) {
                if (!((ModifyDialogTabPage.CheckboxPreference)iter.next()).getChecked()) continue;
                return true;
            }
            return false;
        }
    }
}

