/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.importing.CvsBundleImportDescription;
import org.eclipse.pde.internal.core.importing.provisional.BundleImportDescription;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.provisional.IBundeImportWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class CVSBundleImportPage
extends WizardPage
implements IBundeImportWizardPage {
    private BundleImportDescription[] descriptions;
    private Button useHead;
    private TableViewer bundlesViewer;
    private Label counterLabel;
    private static final String CVS_PAGE_USE_HEAD = "org.eclipse.pde.ui.cvs.import.page.head";

    public CVSBundleImportPage() {
        super("cvs", PDEUIMessages.CVSBundleImportPage_0, null);
        this.setDescription(PDEUIMessages.CVSBundleImportPage_1);
    }

    public void createControl(Composite parent) {
        String string;
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808);
        Composite group = SWTFactory.createComposite(comp, 1, 1, 768);
        Button versions = SWTFactory.createRadioButton(group, PDEUIMessages.CVSBundleImportPage_3);
        this.useHead = SWTFactory.createRadioButton(group, PDEUIMessages.CVSBundleImportPage_2);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSBundleImportPage.this.bundlesViewer.refresh(true);
            }
        };
        versions.addSelectionListener((SelectionListener)listener);
        this.useHead.addSelectionListener((SelectionListener)listener);
        Table table = new Table(comp, 2562);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.bundlesViewer = new TableViewer(table);
        this.bundlesViewer.setLabelProvider((IBaseLabelProvider)new CvsLabelProvider());
        this.bundlesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.bundlesViewer.setComparator(new ViewerComparator());
        this.counterLabel = new Label(comp, 0);
        this.counterLabel.setLayoutData((Object)new GridData(768));
        this.setControl((Control)comp);
        this.setPageComplete(true);
        IDialogSettings settings = this.getWizard().getDialogSettings();
        boolean head = false;
        boolean found = false;
        if (settings != null && (string = settings.get(CVS_PAGE_USE_HEAD)) != null) {
            found = true;
            head = settings.getBoolean(CVS_PAGE_USE_HEAD);
        }
        if (!found) {
            int i = 0;
            while (i < this.descriptions.length) {
                CvsBundleImportDescription description = (CvsBundleImportDescription)this.descriptions[i];
                if (description.getTag() != null) {
                    head = false;
                    break;
                }
                ++i;
            }
        }
        this.useHead.setSelection(head);
        versions.setSelection(!head);
        if (this.descriptions != null) {
            this.bundlesViewer.setInput((Object)this.descriptions);
            this.updateCount();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.plugin_import_cvs_page");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setPageComplete(true);
    }

    public boolean finish() {
        IDialogSettings settings;
        boolean head = false;
        if (this.getControl() != null) {
            head = this.useHead.getSelection();
            settings = this.getWizard().getDialogSettings();
            if (settings != null) {
                settings.put(CVS_PAGE_USE_HEAD, head);
            }
        } else {
            settings = this.getWizard().getDialogSettings();
            if (settings != null) {
                head = settings.getBoolean(CVS_PAGE_USE_HEAD);
            }
        }
        if (head) {
            int i = 0;
            while (i < this.descriptions.length) {
                CvsBundleImportDescription description = (CvsBundleImportDescription)this.descriptions[i];
                description.setTag(null);
                ++i;
            }
        }
        return true;
    }

    public BundleImportDescription[] getSelection() {
        return this.descriptions;
    }

    public void setSelection(BundleImportDescription[] descriptions) {
        this.descriptions = descriptions;
        if (this.bundlesViewer != null) {
            this.bundlesViewer.setInput((Object)descriptions);
            this.updateCount();
        }
    }

    private void updateCount() {
        this.counterLabel.setText(NLS.bind((String)PDEUIMessages.ImportWizard_expressPage_total, (Object)new Integer(this.descriptions.length)));
        this.counterLabel.getParent().layout();
    }

    class CvsLabelProvider
    extends StyledCellLabelProvider
    implements ILabelProvider {
        CvsLabelProvider() {
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }

        public void update(ViewerCell cell) {
            StyledString string = this.getStyledText(cell.getElement());
            cell.setText(string.getString());
            cell.setStyleRanges(string.getStyleRanges());
            cell.setImage(this.getImage(cell.getElement()));
            super.update(cell);
        }

        private StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString();
            if (element instanceof CvsBundleImportDescription) {
                CvsBundleImportDescription description = (CvsBundleImportDescription)element;
                String project = description.getProject();
                String version = description.getTag();
                String host = description.getServer();
                styledString.append(project);
                if (version != null && !CVSBundleImportPage.this.useHead.getSelection()) {
                    styledString.append(' ');
                    styledString.append(version, StyledString.DECORATIONS_STYLER);
                }
                styledString.append(' ');
                styledString.append('[', StyledString.DECORATIONS_STYLER);
                styledString.append(host, StyledString.DECORATIONS_STYLER);
                styledString.append(']', StyledString.DECORATIONS_STYLER);
                return styledString;
            }
            styledString.append(element.toString());
            return styledString;
        }
    }
}

