/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.feature.Choice;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.editor.feature.PortabilityChoicesDialog;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class PortabilitySection
extends PDESection {
    private FormEntry fArchText;
    private FormEntry fNlText;
    private FormEntry fOsText;
    private FormEntry fWsText;

    public static Choice[] getArchChoices() {
        return PortabilitySection.getKnownChoices(Platform.knownOSArchValues());
    }

    private static Choice[] getKnownChoices(String[] values) {
        Choice[] choices = new Choice[values.length];
        int i = 0;
        while (i < choices.length) {
            choices[i] = new Choice(values[i], values[i]);
            ++i;
        }
        return choices;
    }

    public static Choice[] getNLChoices() {
        Locale[] locales = Locale.getAvailableLocales();
        Choice[] choices = new Choice[locales.length];
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            choices[i] = new Choice(locale.toString(), String.valueOf(locale.toString()) + " - " + locale.getDisplayName());
            ++i;
        }
        return choices;
    }

    public static Choice[] getOSChoices() {
        return PortabilitySection.getKnownChoices(Platform.knownOSValues());
    }

    public static Choice[] getWSChoices() {
        return PortabilitySection.getKnownChoices(Platform.knownWSValues());
    }

    public PortabilitySection(FeatureFormPage page, Composite parent) {
        this(page, parent, PDEUIMessages.FeatureEditor_PortabilitySection_title, PDEUIMessages.FeatureEditor_PortabilitySection_desc, 0);
    }

    public PortabilitySection(PDEFormPage page, Composite parent, String title, String desc, int toggleStyle) {
        super(page, parent, 0x80 | toggleStyle);
        this.getSection().setText(title);
        this.getSection().setDescription(desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    private void applyValue(String property, String value) throws CoreException {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        if (property.equals("nl")) {
            feature.setNL(value);
        } else if (property.equals("os")) {
            feature.setOS(value);
        } else if (property.equals("ws")) {
            feature.setWS(value);
        } else if (property.equals("arch")) {
            feature.setArch(value);
        }
    }

    public void cancelEdit() {
        this.fOsText.cancelEdit();
        this.fWsText.cancelEdit();
        this.fNlText.cancelEdit();
        this.fArchText.cancelEdit();
        super.cancelEdit();
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void commit(boolean onSave) {
        this.fOsText.commit();
        this.fWsText.commit();
        this.fNlText.commit();
        this.fArchText.commit();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData twd = new TableWrapData();
        twd.grabHorizontal = true;
        section.setLayoutData((Object)twd);
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        container.setLayoutData((Object)new GridData(768));
        String editLabel = PDEUIMessages.FeatureEditor_PortabilitySection_edit;
        this.fOsText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_PortabilitySection_os, editLabel, false);
        this.fOsText.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry entry) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.fOsText.getText().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Choice[] choices = PortabilitySection.getOSChoices();
                        PortabilitySection.access$1(1.access$0(this.this$1), "os", PortabilitySection.access$0(1.access$0(this.this$1)), choices);
                    }
                });
            }

            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("os", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            static /* synthetic */ PortabilitySection access$0(1 var0) {
                return var0.PortabilitySection.this;
            }
        });
        this.limitTextWidth(this.fOsText);
        this.fOsText.setEditable(this.isEditable());
        this.fWsText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_PortabilitySection_ws, editLabel, false);
        this.fWsText.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry entry) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.fWsText.getText().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Choice[] choices = PortabilitySection.getWSChoices();
                        PortabilitySection.access$1(3.access$0(this.this$1), "ws", PortabilitySection.access$3(3.access$0(this.this$1)), choices);
                    }
                });
            }

            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("ws", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            static /* synthetic */ PortabilitySection access$0(3 var0) {
                return var0.PortabilitySection.this;
            }
        });
        this.limitTextWidth(this.fWsText);
        this.fWsText.setEditable(this.isEditable());
        this.fNlText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_PortabilitySection_nl, editLabel, false);
        this.fNlText.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry entry) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.fNlText.getText().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Choice[] choices = PortabilitySection.getNLChoices();
                        PortabilitySection.access$1(5.access$0(this.this$1), "nl", PortabilitySection.access$4(5.access$0(this.this$1)), choices);
                    }
                });
            }

            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("nl", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            static /* synthetic */ PortabilitySection access$0(5 var0) {
                return var0.PortabilitySection.this;
            }
        });
        this.limitTextWidth(this.fNlText);
        this.fNlText.setEditable(this.isEditable());
        this.fArchText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_PortabilitySection_arch, editLabel, false);
        this.fArchText.setFormEntryListener(new FormEntryAdapter(this){

            public void browseButtonSelected(FormEntry entry) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.fArchText.getText().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Choice[] choices = PortabilitySection.getArchChoices();
                        PortabilitySection.access$1(7.access$0(this.this$1), "arch", PortabilitySection.access$5(7.access$0(this.this$1)), choices);
                    }
                });
            }

            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("arch", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            static /* synthetic */ PortabilitySection access$0(7 var0) {
                return var0.PortabilitySection.this;
            }
        });
        this.limitTextWidth(this.fArchText);
        this.fArchText.setEditable(this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize(IManagedForm form) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
        super.initialize(form);
    }

    private void limitTextWidth(FormEntry entry) {
        GridData gd = (GridData)entry.getText().getLayoutData();
        gd.widthHint = 30;
    }

    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    private void openPortabilityChoiceDialog(String property, FormEntry text, Choice[] choices) {
        String value = text.getValue();
        PortabilityChoicesDialog dialog = new PortabilityChoicesDialog(PDEPlugin.getActiveWorkbenchShell(), choices, value);
        dialog.create();
        dialog.getShell().setText(PDEUIMessages.FeatureEditor_PortabilityChoicesDialog_title);
        int result = dialog.open();
        if (result == 0) {
            value = dialog.getValue();
            text.setValue(value);
            try {
                this.applyValue(property, value);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public void refresh() {
        this.setValue("os");
        this.setValue("ws");
        this.setValue("arch");
        this.setValue("nl");
        super.refresh();
    }

    public void setFocus() {
        if (this.fOsText != null) {
            this.fOsText.getText().setFocus();
        }
    }

    private void setValue(String property) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        if (property.equals("nl")) {
            this.fNlText.setValue(feature.getNL(), true);
        } else if (property.equals("os")) {
            this.fOsText.setValue(feature.getOS(), true);
        } else if (property.equals("ws")) {
            this.fWsText.setValue(feature.getWS(), true);
        } else if (property.equals("arch")) {
            this.fArchText.setValue(feature.getArch(), true);
        }
    }

    static /* synthetic */ void access$1(PortabilitySection portabilitySection, String string, FormEntry formEntry, Choice[] choiceArray) {
        portabilitySection.openPortabilityChoiceDialog(string, formEntry, choiceArray);
    }
}

