/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMVisitor;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.actions.AbstractNodeActionManager;
import org.eclipse.wst.xml.ui.internal.actions.NodeAction;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReplacePrefixAction
extends NodeAction {
    protected static ImageDescriptor imageDescriptor;
    protected Element element;
    protected AbstractNodeActionManager manager;
    protected Map prefixMapping;

    public ReplacePrefixAction(AbstractNodeActionManager manager, Element element, Map prefixMapping) {
        this.manager = manager;
        this.element = element;
        this.prefixMapping = prefixMapping;
    }

    public String getUndoDescription() {
        return "";
    }

    public void run() {
        Shell shell = XMLUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        if (this.validateEdit(this.manager.getModel(), shell)) {
            NodeCollectingDOMVisitor visitor = new NodeCollectingDOMVisitor();
            visitor.visitNode(this.element);
            Iterator i = visitor.list.iterator();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                String key = node.getPrefix() != null ? node.getPrefix() : "";
                String newPrefix = (String)this.prefixMapping.get(key);
                if (newPrefix == null) continue;
                node.setPrefix(newPrefix);
            }
        }
    }

    class NodeCollectingDOMVisitor
    extends DOMVisitor {
        public List list = new Vector();

        NodeCollectingDOMVisitor() {
        }

        protected boolean isPrefixChangedNeeded(Node node) {
            String key;
            String string = key = node.getPrefix() != null ? node.getPrefix() : "";
            return ReplacePrefixAction.this.prefixMapping.get(key) != null;
        }

        public void visitAttr(Attr attr) {
        }

        protected void visitElement(Element element) {
            super.visitElement(element);
            if (this.isPrefixChangedNeeded(element)) {
                this.list.add(element);
            }
        }
    }
}

