/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.script;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSStringMap
extends ScriptableObject {
    private Map map;
    private static Logger logger = Logger.getLogger(JSStringMap.class.getName());
    private static final long serialVersionUID = -4866037635884065761L;

    public JSStringMap(Map map) {
        assert (map != null);
        logger.entering(JSStringMap.class.getName(), "JSStringMap");
        this.map = map;
    }

    public String getClassName() {
        return "StringMap";
    }

    public void delete(String name) {
        logger.entering(JSStringMap.class.getName(), "delete", name);
        if (this.map.containsKey(name)) {
            this.map.remove(name);
        }
        logger.exiting(JSStringMap.class.getName(), "delete");
    }

    public Object get(String name, Scriptable start) {
        logger.entering(JSStringMap.class.getName(), "get", name);
        if (this.map.containsKey(name)) {
            Object result = this.map.get(name);
            logger.exiting(JSStringMap.class.getName(), "get", result);
            return result;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(JSStringMap.class.getName(), "get", super.get(name, start));
        }
        return super.get(name, start);
    }

    public Object[] getIds() {
        return this.map.keySet().toArray(new String[0]);
    }

    public boolean has(String name, Scriptable start) {
        logger.entering(JSStringMap.class.getName(), "has", name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(JSStringMap.class.getName(), "has", new Boolean(this.map.containsKey(name)));
        }
        return this.map.containsKey(name);
    }

    public void put(String name, Scriptable start, Object value) {
        logger.entering(JSStringMap.class.getName(), "put", name);
        String valStr = value.toString();
        this.map.put(name, valStr);
        logger.exiting(JSStringMap.class.getName(), "put");
    }
}

