/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.olap.api.query.DimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMirroredDefinition;
import org.eclipse.birt.data.engine.olap.api.query.NamedObject;
import org.eclipse.birt.data.engine.olap.impl.query.EdgeDrillingFilterDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.MirroredDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeDefinition
extends NamedObject
implements IEdgeDefinition {
    private List<IDimensionDefinition> dimensions = new ArrayList<IDimensionDefinition>();
    private List<IEdgeDrillFilter> drillOperation = new ArrayList<IEdgeDrillFilter>();
    private ILevelDefinition mirrorStartingLevel;
    private IMirroredDefinition mirror;

    public EdgeDefinition(String name) {
        super(name);
    }

    @Override
    public IDimensionDefinition createDimension(String name) {
        DimensionDefinition dim = new DimensionDefinition(name);
        this.dimensions.add(dim);
        return dim;
    }

    @Override
    public List<IDimensionDefinition> getDimensions() {
        return this.dimensions;
    }

    @Override
    public void creatMirrorDefinition(ILevelDefinition level, boolean breakHierarchy) {
        this.mirror = new MirroredDefinition(level, breakHierarchy);
    }

    @Override
    public IMirroredDefinition getMirroredDefinition() {
        return this.mirror;
    }

    @Override
    public void setMirrorStartingLevel(ILevelDefinition level) {
        this.mirror = new MirroredDefinition(level, true);
    }

    @Override
    public ILevelDefinition getMirrorStartingLevel() {
        return this.mirrorStartingLevel;
    }

    @Override
    public List<IEdgeDrillFilter> getDrillFilter() {
        return this.drillOperation;
    }

    @Override
    public IEdgeDrillFilter createDrillFilter(String name) {
        EdgeDrillingFilterDefinition drill = new EdgeDrillingFilterDefinition(name);
        this.drillOperation.add(drill);
        return drill;
    }
}

