/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.content.BlockStackingExecutor;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.w3c.dom.css.CSSValue;

public abstract class PDFBlockStackingLM
extends PDFStackingLM
implements IBlockStackingLayoutManager {
    protected IReportItemExecutor blockExecutor = null;
    protected CompositeArea keepWithCache = new CompositeArea();
    protected boolean keepWith = false;

    public int getCurrentMaxContentHeight() {
        return this.maxAvaHeight - this.currentBP - this.keepWithCache.getHeight();
    }

    protected void addChild(PDFAbstractLM child) {
        this.child = child;
    }

    public PDFBlockStackingLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
    }

    protected boolean traverseChildren() throws BirtException {
        boolean hasNextPage = false;
        if (this.child != null && (hasNextPage = this.child.layout())) {
            if (this.child.isFinished()) {
                this.child = null;
            }
            return true;
        }
        if (this.blockExecutor == null) {
            this.blockExecutor = this.createExecutor();
        }
        while (this.blockExecutor.hasNextChild()) {
            IReportItemExecutor childExecutor = this.blockExecutor.getNextChild();
            if (childExecutor == null || !this.layoutChildNode(childExecutor)) continue;
            return true;
        }
        return false;
    }

    protected IReportItemExecutor createExecutor() {
        return new BlockStackingExecutor(this.content, this.executor);
    }

    private boolean layoutChildNode(IReportItemExecutor childExecutor) throws BirtException {
        boolean hasNextPage = false;
        IContent childContent = childExecutor.execute();
        PDFAbstractLM childLM = this.getFactory().createLayoutManager(this, childContent, childExecutor);
        hasNextPage = childLM.layout();
        this.child = hasNextPage && !childLM.isFinished() ? childLM : null;
        return hasNextPage;
    }

    protected void initialize() throws BirtException {
        if (this.root == null) {
            this.createRoot();
            this.validateBoxProperty(this.root.getStyle(), this.parent.getCurrentMaxContentWidth(), this.context.getMaxHeight());
            this.calculateSpecifiedWidth();
            this.setOffsetX(this.root.getContentX());
            this.setOffsetY(this.isFirst ? this.root.getContentY() : 0);
            this.setCurrentBP(0);
            this.setCurrentIP(0);
        }
        int maxW = this.parent.getCurrentMaxContentWidth();
        if (this.specifiedWidth > 0) {
            maxW = Math.min(maxW, this.specifiedWidth);
        }
        this.root.setAllocatedWidth(maxW);
        this.maxAvaWidth = this.root.getContentWidth();
        this.root.setAllocatedHeight(this.parent.getCurrentMaxContentHeight());
        this.maxAvaHeight = this.root.getContentHeight();
    }

    protected void closeLayout() {
        if (this.root == null) {
            return;
        }
        IStyle areaStyle = this.root.getStyle();
        if (!this.isLast) {
            areaStyle.setProperty(23, IStyle.NUMBER_0);
            areaStyle.setProperty(9, IStyle.NUMBER_0);
            areaStyle.setProperty(16, IStyle.NUMBER_0);
        }
        int height = this.getCurrentBP() + this.getOffsetY() + this.getDimensionValue(areaStyle.getProperty(9)) + this.getDimensionValue(areaStyle.getProperty(23));
        if (this.isFirst && this.isLast) {
            this.calculateSpecifiedHeight();
            if (this.specifiedHeight > height) {
                CSSValue verticalAlign = areaStyle.getProperty(38);
                if (IStyle.BOTTOM_VALUE.equals(verticalAlign) || IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
                    int offset = this.specifiedHeight - height;
                    if (IStyle.BOTTOM_VALUE.equals(verticalAlign)) {
                        Iterator iter = this.root.getChildren();
                        while (iter.hasNext()) {
                            AbstractArea child = (AbstractArea)iter.next();
                            child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset);
                        }
                    } else if (IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
                        Iterator iter = this.root.getChildren();
                        while (iter.hasNext()) {
                            AbstractArea child = (AbstractArea)iter.next();
                            child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset / 2);
                        }
                    }
                }
                height = this.specifiedHeight;
            }
        }
        this.root.setHeight(height);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean addArea(IArea area, boolean keepWithPrevious, boolean keepWithNext) {
        if (area == null) {
            return true;
        }
        boolean bl = this.keepWith = this.keepWith || keepWithNext || this.pageBreakAvoid;
        if (!this.keepWith && !keepWithPrevious) {
            this.clearCache();
        }
        AbstractArea aArea = (AbstractArea)area;
        if (this.keepWithCache.getHeight() + aArea.getAllocatedHeight() + this.getCurrentBP() > this.getMaxAvaHeight()) {
            if (!this.isPageEmpty()) {
                this.context.setAutoPageBreak(true);
                return false;
            }
            this.addToRoot(aArea);
        } else if (keepWithPrevious || this.keepWith) {
            this.keepWithCache.add(area);
        } else {
            this.addToRoot(aArea);
        }
        this.keepWith = keepWithNext;
        if (!this.keepWith) {
            this.clearCache();
        }
        return true;
    }

    public String getTextAlign() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return contentStyle.getTextAlign();
        }
        return null;
    }

    protected void cancelChildren() throws BirtException {
        if (this.child != null) {
            this.child.cancel();
        }
    }

    protected boolean hasNextChild() throws BirtException {
        return this.child != null || this.blockExecutor == null || this.blockExecutor.hasNextChild();
    }

    public void setKeepWithNext(boolean keepWithNext) {
        if (keepWithNext) {
            this.keepWith = true;
        }
        if (!this.keepWith && !this.pageBreakAvoid) {
            this.clearCache();
        }
    }

    protected boolean clearCache() {
        while (!this.keepWithCache.isEmpty()) {
            AbstractArea area = (AbstractArea)this.keepWithCache.getFirst();
            boolean succeed = this.addToRoot(area);
            if (!succeed) {
                return false;
            }
            this.keepWithCache.removeFirst();
        }
        return true;
    }

    protected boolean addToRoot(AbstractArea area) {
        this.root.addChild(area);
        area.setAllocatedPosition(this.currentIP + this.offsetX, this.currentBP + this.offsetY);
        this.currentBP += area.getAllocatedHeight();
        if (this.currentIP + area.getAllocatedWidth() > this.root.getContentWidth()) {
            this.root.setNeedClip(true);
        }
        if (this.currentBP > this.maxAvaHeight) {
            this.root.setNeedClip(true);
        }
        return true;
    }

    public void autoPageBreak() {
        if (!this.isRootEmpty()) {
            this.closeLayout();
            this.submitRoot();
            return;
        }
        if (!this.keepWithCache.isEmpty()) {
            this.clearCache();
            if (!this.isRootEmpty()) {
                this.closeLayout();
                this.submitRoot();
                return;
            }
        }
        if (this.child != null) {
            this.child.autoPageBreak();
            this.closeLayout();
            this.submitRoot();
        }
    }

    public void submit(AbstractArea area) {
        this.root.addChild(area);
        area.setAllocatedPosition(this.currentIP + this.offsetX, this.currentBP + this.offsetY);
        this.currentBP += area.getAllocatedHeight();
    }

    protected boolean submitRoot() {
        if (this.root == null) {
            return true;
        }
        boolean success = true;
        if (this.parent != null) {
            if (this.isLast) {
                success = this.parent.addArea(this.root, false, this.isKeepWithNext());
            } else if (this.context.isAutoPageBreak() && this.isFirst) {
                success = this.parent.addArea(this.root, false, false);
            } else {
                this.parent.submit(this.root);
            }
            if (success) {
                this.isFirst = false;
                this.root = null;
            }
        } else if (this.content != null) {
            this.content.setExtension(1, this.root);
        }
        return success;
    }

    protected static class CompositeArea {
        protected LinkedList cache = new LinkedList();
        protected int height = 0;

        public int size() {
            return this.cache.size();
        }

        public void add(IArea area) {
            AbstractArea aArea = (AbstractArea)area;
            this.cache.addLast(area);
            this.height += aArea.getAllocatedHeight();
        }

        public int getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        public Iterator getChildren() {
            return this.cache.iterator();
        }

        public IArea getFirst() {
            if (!this.cache.isEmpty()) {
                return (IArea)this.cache.getFirst();
            }
            return null;
        }

        public IArea removeFirst() {
            if (!this.cache.isEmpty()) {
                AbstractArea area = (AbstractArea)this.cache.removeFirst();
                this.height -= area.getAllocatedHeight();
                return area;
            }
            return null;
        }

        public void addAll(CompositeArea areas) {
            Iterator iter = areas.getChildren();
            while (iter.hasNext()) {
                this.add((IArea)iter.next());
            }
        }

        public CompositeArea getLastN(int count) {
            CompositeArea areas = new CompositeArea();
            int i = 0;
            while (i < count) {
                AbstractArea area = (AbstractArea)this.getFirst();
                if (area == null) {
                    return areas;
                }
                areas.add(area);
                ++i;
            }
            return areas;
        }

        public CompositeArea getFirstN(int count) {
            CompositeArea areas = new CompositeArea();
            int i = 0;
            while (i < count) {
                AbstractArea area = (AbstractArea)this.getFirst();
                if (area == null) {
                    return areas;
                }
                areas.add(area);
                ++i;
            }
            return areas;
        }

        public CompositeArea getAreas(int height, boolean force) {
            if (height >= this.height) {
                return this;
            }
            CompositeArea areas = new CompositeArea();
            int current = 0;
            while (current < height) {
                AbstractArea area = (AbstractArea)this.getFirst();
                if (area == null) continue;
                if ((current += area.getAllocatedHeight()) <= height) {
                    areas.add(area);
                    this.removeFirst();
                    continue;
                }
                if (current == 0 && force) {
                    areas.add(area);
                    this.removeFirst();
                }
                return areas;
            }
            return null;
        }
    }

    protected class KeepWithMgr {
        protected CompositeArea cache = new CompositeArea();
        protected int maxHeight = 0;

        public KeepWithMgr() {
        }

        public KeepWithMgr(int maxHeight) {
            this.maxHeight = maxHeight;
        }

        public void setMaxHeight(int maxHeight) {
            this.maxHeight = maxHeight;
        }

        public void addLast(IArea area) {
            this.cache.add(area);
        }

        public boolean isOverFlow() {
            return this.cache.getHeight() > this.maxHeight;
        }

        public int getHeight() {
            return this.cache.getHeight();
        }

        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        public IArea getFirst() {
            if (!this.cache.isEmpty()) {
                return this.cache.getFirst();
            }
            return null;
        }

        public void removeFirst() {
            if (!this.cache.isEmpty()) {
                this.cache.removeFirst();
            }
        }
    }
}

