/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.css;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.executor.css.CssParserConstants;
import org.eclipse.birt.report.engine.executor.css.CssParserTokenManager;
import org.eclipse.birt.report.engine.executor.css.ParseException;
import org.eclipse.birt.report.engine.executor.css.SimpleCharStream;
import org.eclipse.birt.report.engine.executor.css.Token;

public class CssParser
implements CssParserConstants {
    private static Logger logger = Logger.getLogger(CssParser.class.getName());
    private HashMap cssProperties;
    protected String currentProperty;
    private String cssStatement;
    public CssParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[48];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static {
        CssParser.jj_la1_0();
        CssParser.jj_la1_1();
        CssParser.jj_la1_2();
    }

    public void setCssStatement(String cssStatement) {
        this.cssStatement = cssStatement;
    }

    private void setValue(StringBuffer value, char operator, Token n, int token) throws ParseException {
        if (n != null) {
            if (n.kind == 76) {
                value.append(this.convertIdent(String.valueOf(operator) + n.image));
            } else {
                value.append(String.valueOf(operator) + n.image);
            }
        }
    }

    public HashMap getCssProperties() {
        return this.cssProperties;
    }

    private void skipTo(int kind) {
        Token current;
        Token t;
        do {
            current = this.token;
            t = this.getNextToken();
        } while (t.kind != kind && t.kind != 0);
        this.token = current;
    }

    public final void parse() throws ParseException {
        this.cssProperties = new HashMap();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 76: {
                this.declaration();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(17);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 56: 
                case 61: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 74: 
                case 75: 
                case 76: {
                    this.declaration();
                    continue block9;
                }
            }
            this.jj_la1[2] = this.jj_gen;
        }
    }

    public final char unaryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                return '-';
            }
            case 14: {
                this.jj_consume_token(14);
                return '+';
            }
        }
        this.jj_la1[3] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token size() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                Token n = this.jj_consume_token(51);
                return n;
            }
            case 52: {
                Token n = this.jj_consume_token(52);
                return n;
            }
            case 42: {
                Token n = this.jj_consume_token(42);
                return n;
            }
            case 43: {
                Token n = this.jj_consume_token(43);
                return n;
            }
            case 73: {
                Token n = this.jj_consume_token(73);
                return n;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void declaration() throws ParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 56: {
                    this.jj_consume_token(56);
                    this.jj_consume_token(26);
                    this.shortHandFont();
                    break;
                }
                case 61: {
                    this.jj_consume_token(61);
                    this.jj_consume_token(26);
                    this.shortHandBackground();
                    break;
                }
                case 65: {
                    this.jj_consume_token(65);
                    this.jj_consume_token(26);
                    this.shortHandBorder();
                    break;
                }
                case 66: {
                    this.jj_consume_token(66);
                    this.jj_consume_token(26);
                    this.shortHandBorderWidth();
                    break;
                }
                case 67: {
                    this.jj_consume_token(67);
                    this.jj_consume_token(26);
                    this.shortHandBorderStyle();
                    break;
                }
                case 68: {
                    this.jj_consume_token(68);
                    this.jj_consume_token(26);
                    this.shortHandBorderTop();
                    break;
                }
                case 69: {
                    this.jj_consume_token(69);
                    this.jj_consume_token(26);
                    this.shortHandBorderRight();
                    break;
                }
                case 70: {
                    this.jj_consume_token(70);
                    this.jj_consume_token(26);
                    this.shortHandBorderBottom();
                    break;
                }
                case 71: {
                    this.jj_consume_token(71);
                    this.jj_consume_token(26);
                    this.shortHandBorderLeft();
                    break;
                }
                case 74: {
                    this.jj_consume_token(74);
                    this.jj_consume_token(26);
                    this.shortHandMargin();
                    break;
                }
                case 75: {
                    this.jj_consume_token(75);
                    this.jj_consume_token(26);
                    this.shortHandPadding();
                    break;
                }
                case 76: {
                    Token n = this.jj_consume_token(76);
                    this.currentProperty = this.convertIdent(n.image);
                    this.jj_consume_token(26);
                    StringBuffer value = this.expr();
                    this.cssProperties.put(this.currentProperty, value.toString().trim());
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "The css statement is:" + this.cssStatement, ex);
            this.skipTo(17);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void shortHandFont() throws ParseException {
        fontFamily = "";
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 57: {
                    n = this.jj_consume_token(57);
                    this.cssProperties.put("font", n.image);
                    this.cssProperties.put("font-weight", "");
                    this.cssProperties.put("font-style", "");
                    break;
                }
                case 42: 
                case 43: 
                case 51: 
                case 52: 
                case 54: 
                case 58: 
                case 59: 
                case 60: 
                case 73: {
                    fontStyle = null;
                    fontVariant = null;
                    fontWeight = null;
                    block29: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 54: 
                            case 58: 
                            case 59: 
                            case 60: {
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                                ** GOTO lbl50
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 58: {
                                n = this.jj_consume_token(58);
                                fontStyle = n.image;
                                continue block29;
                            }
                            case 59: {
                                n = this.jj_consume_token(59);
                                fontVariant = n.image;
                                continue block29;
                            }
                            case 60: {
                                n = this.jj_consume_token(60);
                                fontWeight = n.image;
                                continue block29;
                            }
                            case 54: {
                                n = this.jj_consume_token(54);
                                if (fontStyle == null) {
                                    fontStyle = n.image;
                                }
                                if (fontVariant == null) {
                                    fontVariant = n.image;
                                }
                                if (fontWeight != null) continue block29;
                                fontWeight = n.image;
                                continue block29;
                            }
                        }
                        break;
                    }
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
lbl50:
                    // 1 sources

                    this.cssProperties.put("font-style", fontStyle);
                    this.cssProperties.put("font-variant", fontVariant);
                    this.cssProperties.put("font-weight", fontWeight);
                    n = this.size();
                    if (n != null) {
                        this.cssProperties.put("font-size", n.image);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 19: {
                            this.jj_consume_token(19);
                            n = this.size();
                            if (n == null) break;
                            this.cssProperties.put("line-height", n.image);
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 76: {
                            n = this.jj_consume_token(76);
                            if (n == null) break;
                            fontFamily = String.valueOf(fontFamily) + n.image;
                            break;
                        }
                        case 38: {
                            n = this.jj_consume_token(38);
                            if (n == null) break;
                            fontFamily = String.valueOf(fontFamily) + n.image;
                            break;
                        }
                        default: {
                            this.jj_la1[9] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    block30: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 16: {
                                break;
                            }
                            default: {
                                this.jj_la1[10] = this.jj_gen;
                                ** GOTO lbl111
                            }
                        }
                        n = this.jj_consume_token(16);
                        fontFamily = String.valueOf(fontFamily) + ",";
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 76: {
                                n = this.jj_consume_token(76);
                                if (n == null) continue block30;
                                fontFamily = String.valueOf(fontFamily) + n.image;
                                continue block30;
                            }
                            case 38: {
                                n = this.jj_consume_token(38);
                                if (n == null) continue block30;
                                fontFamily = String.valueOf(fontFamily) + n.image;
                                continue block30;
                            }
                        }
                        break;
                    }
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
lbl111:
                    // 1 sources

                    this.cssProperties.put("font-family", fontFamily);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        catch (Exception ex) {
            CssParser.logger.log(Level.SEVERE, "The css statement is:" + this.cssStatement, ex);
        }
    }

    public final void shortHandBackground() throws ParseException {
        try {
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 53: {
                        Token n = this.jj_consume_token(53);
                        if (n == null) break;
                        this.cssProperties.put("background-color", n.image);
                        break;
                    }
                    case 41: {
                        Token n = this.jj_consume_token(41);
                        if (n == null) break;
                        this.cssProperties.put("background-image", n.image);
                        break;
                    }
                    case 62: {
                        Token n = this.jj_consume_token(62);
                        if (n == null) break;
                        this.cssProperties.put("background-repeat", n.image);
                        break;
                    }
                    case 63: {
                        Token n = this.jj_consume_token(63);
                        if (n == null) break;
                        this.cssProperties.put("background-attachment", n.image);
                        break;
                    }
                    case 42: 
                    case 43: 
                    case 51: 
                    case 52: 
                    case 64: 
                    case 73: {
                        Token n = this.background_position();
                        if (n == null) break;
                        if (this.cssProperties.get("background-position") == null) {
                            this.cssProperties.put("background-position", n.image);
                            break;
                        }
                        this.cssProperties.put("background-position", String.valueOf((String)this.cssProperties.get("background-position")) + " " + n.image);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 41: 
                    case 42: 
                    case 43: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 73: {
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[14] = this.jj_gen;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "The css statement is:" + this.cssStatement, ex);
        }
    }

    public final void shortHandBorder() throws ParseException {
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 51: 
                case 52: 
                case 73: {
                    Token n = this.size();
                    this.cssProperties.put("border-top-width", n.image);
                    this.cssProperties.put("border-right-width", n.image);
                    this.cssProperties.put("border-bottom-width", n.image);
                    this.cssProperties.put("border-left-width", n.image);
                    break;
                }
                case 72: {
                    Token n = this.jj_consume_token(72);
                    this.cssProperties.put("border-top-style", n.image);
                    this.cssProperties.put("border-right-style", n.image);
                    this.cssProperties.put("border-bottom-style", n.image);
                    this.cssProperties.put("border-left-style", n.image);
                    break;
                }
                case 53: {
                    Token n = this.jj_consume_token(53);
                    this.cssProperties.put("border-top-color", n.image);
                    this.cssProperties.put("border-right-color", n.image);
                    this.cssProperties.put("border-bottom-color", n.image);
                    this.cssProperties.put("border-left-color", n.image);
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 51: 
                case 52: 
                case 53: 
                case 72: 
                case 73: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[16] = this.jj_gen;
    }

    public final void shortHandBorderWidth() throws ParseException {
        Token n = this.size();
        this.cssProperties.put("border-top-width", n.image);
        this.cssProperties.put("border-right-width", n.image);
        this.cssProperties.put("border-bottom-width", n.image);
        this.cssProperties.put("border-left-width", n.image);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: 
            case 43: 
            case 51: 
            case 52: 
            case 73: {
                n = this.size();
                this.cssProperties.put("border-right-width", n.image);
                this.cssProperties.put("border-left-width", n.image);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 42: 
                    case 43: 
                    case 51: 
                    case 52: 
                    case 73: {
                        n = this.size();
                        this.cssProperties.put("border-bottom-width", n.image);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 42: 
                            case 43: 
                            case 51: 
                            case 52: 
                            case 73: {
                                n = this.size();
                                this.cssProperties.put("border-left-width", n.image);
                                break block0;
                            }
                        }
                        this.jj_la1[17] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
    }

    public final void shortHandBorderStyle() throws ParseException {
        Token n = this.jj_consume_token(72);
        this.cssProperties.put("border-top-style", n.image);
        this.cssProperties.put("border-right-style", n.image);
        this.cssProperties.put("border-bottom-style", n.image);
        this.cssProperties.put("border-left-style", n.image);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                n = this.jj_consume_token(72);
                this.cssProperties.put("border-right-style", n.image);
                this.cssProperties.put("border-left-style", n.image);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 72: {
                        n = this.jj_consume_token(72);
                        this.cssProperties.put("border-bottom-style", n.image);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 72: {
                                n = this.jj_consume_token(72);
                                this.cssProperties.put("border-left-style", n.image);
                                break block0;
                            }
                        }
                        this.jj_la1[20] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[21] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
    }

    public final void shortHandBorderTop() throws ParseException {
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 51: 
                case 52: 
                case 73: {
                    Token n = this.size();
                    this.cssProperties.put("border-top-width", n.image);
                    break;
                }
                case 72: {
                    Token n = this.jj_consume_token(72);
                    this.cssProperties.put("border-top-style", n.image);
                    break;
                }
                case 53: {
                    Token n = this.jj_consume_token(53);
                    this.cssProperties.put("border-top-color", n.image);
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 51: 
                case 52: 
                case 53: 
                case 72: 
                case 73: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[24] = this.jj_gen;
    }

    public final void shortHandBorderRight() throws ParseException {
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 51: 
                case 52: 
                case 73: {
                    Token n = this.size();
                    this.cssProperties.put("border-right-width", n.image);
                    break;
                }
                case 72: {
                    Token n = this.jj_consume_token(72);
                    this.cssProperties.put("border-right-style", n.image);
                    break;
                }
                case 53: {
                    Token n = this.jj_consume_token(53);
                    this.cssProperties.put("border-right-color", n.image);
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 51: 
                case 52: 
                case 53: 
                case 72: 
                case 73: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[26] = this.jj_gen;
    }

    public final void shortHandBorderBottom() throws ParseException {
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 51: 
                case 52: 
                case 73: {
                    Token n = this.size();
                    this.cssProperties.put("border-bottom-width", n.image);
                    break;
                }
                case 72: {
                    Token n = this.jj_consume_token(72);
                    this.cssProperties.put("border-bottom-style", n.image);
                    break;
                }
                case 53: {
                    Token n = this.jj_consume_token(53);
                    this.cssProperties.put("border-bottom-color", n.image);
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 51: 
                case 52: 
                case 53: 
                case 72: 
                case 73: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[28] = this.jj_gen;
    }

    public final void shortHandBorderLeft() throws ParseException {
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 51: 
                case 52: 
                case 73: {
                    Token n = this.size();
                    this.cssProperties.put("border-left-width", n.image);
                    break;
                }
                case 72: {
                    Token n = this.jj_consume_token(72);
                    this.cssProperties.put("border-left-style", n.image);
                    break;
                }
                case 53: {
                    Token n = this.jj_consume_token(53);
                    this.cssProperties.put("border-left-color", n.image);
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 43: 
                case 51: 
                case 52: 
                case 53: 
                case 72: 
                case 73: {
                    continue block8;
                }
            }
            break;
        }
        this.jj_la1[30] = this.jj_gen;
    }

    public final Token getMarginWidth() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                Token n = this.jj_consume_token(43);
                return n;
            }
            case 42: {
                Token n = this.jj_consume_token(42);
                return n;
            }
            case 55: {
                Token n = this.jj_consume_token(55);
                return n;
            }
        }
        this.jj_la1[31] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void shortHandMargin() throws ParseException {
        Token n = this.getMarginWidth();
        this.cssProperties.put("margin-top", n.image);
        this.cssProperties.put("margin-right", n.image);
        this.cssProperties.put("margin-bottom", n.image);
        this.cssProperties.put("margin-left", n.image);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: 
            case 43: 
            case 55: {
                n = this.getMarginWidth();
                this.cssProperties.put("margin-right", n.image);
                this.cssProperties.put("margin-left", n.image);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 42: 
                    case 43: 
                    case 55: {
                        n = this.getMarginWidth();
                        this.cssProperties.put("margin-bottom", n.image);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 42: 
                            case 43: 
                            case 55: {
                                n = this.getMarginWidth();
                                this.cssProperties.put("margin-left", n.image);
                                break block0;
                            }
                        }
                        this.jj_la1[32] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[33] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
    }

    public final Token getPaddingWidth() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                Token n = this.jj_consume_token(43);
                return n;
            }
            case 42: {
                Token n = this.jj_consume_token(42);
                return n;
            }
        }
        this.jj_la1[35] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void shortHandPadding() throws ParseException {
        Token n = this.getPaddingWidth();
        this.cssProperties.put("padding-top", n.image);
        this.cssProperties.put("padding-right", n.image);
        this.cssProperties.put("padding-bottom", n.image);
        this.cssProperties.put("padding-left", n.image);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: 
            case 43: {
                n = this.getPaddingWidth();
                this.cssProperties.put("padding-right", n.image);
                this.cssProperties.put("padding-left", n.image);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 42: 
                    case 43: {
                        n = this.getPaddingWidth();
                        this.cssProperties.put("padding-bottom", n.image);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 42: 
                            case 43: {
                                n = this.getPaddingWidth();
                                this.cssProperties.put("padding-left", n.image);
                                break block0;
                            }
                        }
                        this.jj_la1[36] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[37] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
    }

    public final Token background_position() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                Token n = this.jj_consume_token(64);
                return n;
            }
            case 42: 
            case 43: 
            case 51: 
            case 52: 
            case 73: {
                Token n = this.size();
                return n;
            }
        }
        this.jj_la1[39] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StringBuffer expr() throws ParseException {
        StringBuffer value = new StringBuffer();
        this.term(value);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 16: 
                case 19: 
                case 38: 
                case 39: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 63: 
                case 64: 
                case 72: 
                case 73: 
                case 76: 
                case 77: 
                case 78: 
                case 88: 
                case 89: {
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: 
                case 19: {
                    this.operator(value);
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                }
            }
            this.term(value);
        }
        return value;
    }

    public final void operator(StringBuffer value) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                if (value.toString().length() <= 0) break;
                value.append("/");
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                if (value.toString().length() <= 0) break;
                value.append(",");
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void term(StringBuffer value) throws ParseException {
        char operator = ' ';
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 72: 
            case 73: 
            case 77: 
            case 89: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 15: {
                        operator = this.unaryOperator();
                        break;
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 39: {
                        Token n = this.jj_consume_token(39);
                        this.setValue(value, operator, n, 39);
                        break block0;
                    }
                    case 42: 
                    case 43: 
                    case 51: 
                    case 52: 
                    case 73: {
                        Token n = this.size();
                        this.setValue(value, operator, n, 43);
                        break block0;
                    }
                    case 44: {
                        Token n = this.jj_consume_token(44);
                        this.setValue(value, operator, n, 44);
                        break block0;
                    }
                    case 45: {
                        Token n = this.jj_consume_token(45);
                        this.setValue(value, operator, n, 45);
                        break block0;
                    }
                    case 53: {
                        Token n = this.jj_consume_token(53);
                        this.setValue(value, operator, n, 53);
                        break block0;
                    }
                    case 46: {
                        Token n = this.jj_consume_token(46);
                        this.setValue(value, operator, n, 46);
                        break block0;
                    }
                    case 47: {
                        Token n = this.jj_consume_token(47);
                        this.setValue(value, operator, n, 47);
                        break block0;
                    }
                    case 48: {
                        Token n = this.jj_consume_token(48);
                        this.setValue(value, operator, n, 48);
                        break block0;
                    }
                    case 49: {
                        Token n = this.jj_consume_token(49);
                        this.setValue(value, operator, n, 49);
                        break block0;
                    }
                    case 50: {
                        Token n = this.jj_consume_token(50);
                        this.setValue(value, operator, n, 50);
                        break block0;
                    }
                    case 77: {
                        Token n = this.jj_consume_token(77);
                        logger.log(Level.SEVERE, "Unknown dimension: {0}" + n.image);
                        break block0;
                    }
                    case 89: {
                        String func = this.function();
                        value.append(func);
                        break block0;
                    }
                    case 54: 
                    case 55: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 72: {
                        Token n = this.getFromShorthand();
                        this.setValue(value, operator, n, 54);
                        break block0;
                    }
                }
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 38: 
            case 41: 
            case 76: 
            case 78: 
            case 88: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 38: {
                        Token n = this.jj_consume_token(38);
                        this.setValue(value, operator, n, 38);
                        break block0;
                    }
                    case 76: {
                        Token n = this.jj_consume_token(76);
                        this.setValue(value, operator, n, 76);
                        break block0;
                    }
                    case 78: {
                        this.hexcolor(value);
                        break block0;
                    }
                    case 41: {
                        Token n = this.jj_consume_token(41);
                        this.setValue(value, operator, n, 41);
                        break block0;
                    }
                    case 88: {
                        Token n = this.jj_consume_token(88);
                        this.setValue(value, operator, n, 88);
                        break block0;
                    }
                }
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token getFromShorthand() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                Token n = this.jj_consume_token(57);
                return n;
            }
            case 58: {
                Token n = this.jj_consume_token(58);
                return n;
            }
            case 59: {
                Token n = this.jj_consume_token(59);
                return n;
            }
            case 60: {
                Token n = this.jj_consume_token(60);
                return n;
            }
            case 62: {
                Token n = this.jj_consume_token(62);
                return n;
            }
            case 63: {
                Token n = this.jj_consume_token(63);
                return n;
            }
            case 64: {
                Token n = this.jj_consume_token(64);
                return n;
            }
            case 55: {
                Token n = this.jj_consume_token(55);
                return n;
            }
            case 54: {
                Token n = this.jj_consume_token(54);
                return n;
            }
            case 72: {
                Token n = this.jj_consume_token(72);
                return n;
            }
        }
        this.jj_la1[47] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String function() throws ParseException {
        Token n = new Token();
        n = this.jj_consume_token(89);
        StringBuffer exp = this.expr();
        this.jj_consume_token(24);
        return String.valueOf(n.image) + exp.toString() + ")";
    }

    public final void hexcolor(StringBuffer value) throws ParseException {
        Token n = this.jj_consume_token(78);
        this.setValue(value, ' ', n, 78);
    }

    String convertStringIndex(String s, int start, int len) throws ParseException, ParseException {
        StringBuffer buf = new StringBuffer(len);
        int index = start;
        while (index < len) {
            block11: {
                char c;
                block9: {
                    block10: {
                        c = s.charAt(index);
                        if (c != '\\') break block9;
                        if (++index >= len) break block10;
                        c = s.charAt(index);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': 
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                int numValue = Character.digit(c, 16);
                                int count = 0;
                                int p = 16;
                                while (index + 1 < len && count < 6) {
                                    c = s.charAt(index + 1);
                                    if (Character.digit(c, 16) != -1) {
                                        numValue = numValue * 16 + Character.digit(c, 16);
                                        p *= 16;
                                        ++index;
                                        continue;
                                    }
                                    if (c != ' ') break;
                                    ++index;
                                    break;
                                }
                                buf.append((char)numValue);
                                break;
                            }
                            case '\n': 
                            case '\f': {
                                break;
                            }
                            case '\r': {
                                if (index + 1 < len && s.charAt(index + 1) == '\n') {
                                    ++index;
                                    break;
                                }
                                break block11;
                            }
                            default: {
                                buf.append(c);
                                break;
                            }
                        }
                        break block11;
                    }
                    throw new ParseException("invalid string");
                }
                buf.append(c);
            }
            ++index;
        }
        return buf.toString();
    }

    String convertIdent(String s) throws ParseException, ParseException {
        return this.convertStringIndex(s, 0, s.length());
    }

    private static void jj_la1_0() {
        int[] nArray = new int[48];
        nArray[1] = 131072;
        nArray[3] = 49152;
        nArray[8] = 524288;
        nArray[10] = 65536;
        nArray[40] = 638976;
        nArray[41] = 589824;
        nArray[42] = 589824;
        nArray[43] = 49152;
        nArray[46] = 49152;
        jj_la1_0 = nArray;
    }

    private static void jj_la1_1() {
        int[] nArray = new int[48];
        nArray[0] = 0x21000000;
        nArray[2] = 0x21000000;
        nArray[4] = 1575936;
        nArray[5] = 0x21000000;
        nArray[6] = 473956352;
        nArray[7] = 473956352;
        nArray[9] = 64;
        nArray[11] = 64;
        nArray[12] = 509086720;
        nArray[13] = -1070068224;
        nArray[14] = -1070068224;
        nArray[15] = 3673088;
        nArray[16] = 3673088;
        nArray[17] = 1575936;
        nArray[18] = 1575936;
        nArray[19] = 1575936;
        nArray[23] = 3673088;
        nArray[24] = 3673088;
        nArray[25] = 3673088;
        nArray[26] = 3673088;
        nArray[27] = 3673088;
        nArray[28] = 3673088;
        nArray[29] = 3673088;
        nArray[30] = 3673088;
        nArray[31] = 0x800C00;
        nArray[32] = 0x800C00;
        nArray[33] = 0x800C00;
        nArray[34] = 0x800C00;
        nArray[35] = 3072;
        nArray[36] = 3072;
        nArray[37] = 3072;
        nArray[38] = 3072;
        nArray[39] = 1575936;
        nArray[40] = -553648448;
        nArray[44] = -553649024;
        nArray[45] = 576;
        nArray[46] = -553648448;
        nArray[47] = -557842432;
        jj_la1_1 = nArray;
    }

    private static void jj_la1_2() {
        int[] nArray = new int[48];
        nArray[0] = 7422;
        nArray[2] = 7422;
        nArray[4] = 512;
        nArray[5] = 7422;
        nArray[9] = 4096;
        nArray[11] = 4096;
        nArray[12] = 512;
        nArray[13] = 513;
        nArray[14] = 513;
        nArray[15] = 768;
        nArray[16] = 768;
        nArray[17] = 512;
        nArray[18] = 512;
        nArray[19] = 512;
        nArray[20] = 256;
        nArray[21] = 256;
        nArray[22] = 256;
        nArray[23] = 768;
        nArray[24] = 768;
        nArray[25] = 768;
        nArray[26] = 768;
        nArray[27] = 768;
        nArray[28] = 768;
        nArray[29] = 768;
        nArray[30] = 768;
        nArray[39] = 513;
        nArray[40] = 50361089;
        nArray[44] = 33563393;
        nArray[45] = 0x1005000;
        nArray[46] = 50361089;
        nArray[47] = 257;
        jj_la1_2 = nArray;
    }

    public CssParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CssParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 48) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 48) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public CssParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CssParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 48) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 48) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public CssParser(CssParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 48) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(CssParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 48) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[91];
        int i = 0;
        while (i < 91) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 48) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((jj_la1_2[i] & 1 << j) != 0) {
                        la1tokens[64 + j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 91) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

