/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ImageLabel
extends Canvas {
    private static final int INDENT = 3;
    private int align = 16384;
    private int hIndent = 3;
    private int vIndent = 3;
    private Image image;
    private String appToolTipText;
    private Color backgroundColor;

    public ImageLabel(Composite parent, int style) {
        super(parent, ImageLabel.checkStyle(style));
        if ((style & 0x1000000) != 0) {
            this.align = 0x1000000;
        }
        if ((style & 0x20000) != 0) {
            this.align = 131072;
        }
        if ((style & 0x4000) != 0) {
            this.align = 16384;
        }
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ImageLabel.this.onPaint(event);
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ImageLabel.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                ImageLabel.this.redraw();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ImageLabel.this.onDispose(event);
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.initAccessible();
    }

    void initAccessible() {
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = ImageLabel.this.toControl(new Point(e.x, e.y));
                e.childID = ImageLabel.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = ImageLabel.this.getBounds();
                Point pt = ImageLabel.this.toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 41;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                this.getHelp(e);
            }

            public void getHelp(AccessibleEvent e) {
                e.result = ImageLabel.this.getToolTipText();
            }
        });
    }

    private static int checkStyle(int style) {
        String platform;
        if ((style & 0x800) != 0) {
            style |= 4;
        }
        int mask = 100663340;
        style &= mask;
        if (((style |= 0x80000) & 0x1020000) == 0) {
            style |= 0x4000;
        }
        if ("carbon".equals(platform = SWT.getPlatform()) || "gtk".equals(platform)) {
            return style;
        }
        return style | 0x40000;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point e = this.getTotalSize(this.image);
        e.x = wHint == -1 ? (e.x += 2 * this.hIndent) : wHint;
        e.y = hHint == -1 ? (e.y += 2 * this.vIndent) : hHint;
        return e;
    }

    private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topleft, Color bottomright) {
        gc.setForeground(bottomright);
        gc.drawLine(x + w, y, x + w, y + h);
        gc.drawLine(x, y + h, x + w, y + h);
        gc.setForeground(topleft);
        gc.drawLine(x, y, x + w - 1, y);
        gc.drawLine(x, y, x, y + h - 1);
    }

    public int getAlignment() {
        return this.align;
    }

    public Image getImage() {
        return this.image;
    }

    private Point getTotalSize(Image image) {
        Point size = new Point(0, 0);
        if (image != null) {
            Rectangle r = image.getBounds();
            size.x += r.width;
            size.y += r.height;
        }
        return size;
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    private void paintBorder(GC gc, Rectangle r) {
        Display disp = this.getDisplay();
        Color c1 = null;
        Color c2 = null;
        int style = this.getStyle();
        if ((style & 4) != 0) {
            c1 = disp.getSystemColor(18);
            c2 = disp.getSystemColor(20);
        }
        if ((style & 8) != 0) {
            c1 = disp.getSystemColor(19);
            c2 = disp.getSystemColor(18);
        }
        if (c1 != null && c2 != null) {
            gc.setLineWidth(1);
            this.drawBevelRect(gc, r.x, r.y, r.width - 1, r.height - 1, c1, c2);
        }
    }

    void onDispose(DisposeEvent event) {
        this.image = null;
        this.appToolTipText = null;
    }

    void onPaint(PaintEvent event) {
        Rectangle rect = this.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        Image img = this.image;
        Point extent = this.getTotalSize(img);
        GC gc = event.gc;
        int x = rect.x + this.hIndent;
        if (this.align == 0x1000000) {
            x = (rect.width - extent.x) / 2;
        }
        if (this.align == 131072) {
            x = rect.width - extent.x - this.hIndent;
        }
        if (this.backgroundColor != null) {
            Color oldBackground = gc.getBackground();
            gc.setBackground(this.backgroundColor);
            gc.fillRectangle(0, 0, rect.width, rect.height);
            gc.setBackground(oldBackground);
        } else if ((this.getStyle() & 0x40000) != 0) {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(rect);
        }
        int style = this.getStyle();
        if ((style & 4) != 0 || (style & 8) != 0) {
            this.paintBorder(gc, rect);
        }
        if (img != null) {
            Rectangle imageRect = img.getBounds();
            if (this.isFocusControl()) {
                ImageData data = img.getImageData();
                PaletteData palette = new PaletteData(new RGB[]{this.getDisplay().getSystemColor(1).getRGB(), this.getDisplay().getSystemColor(26).getRGB()});
                ImageData sourceData = new ImageData(data.width, data.height, 1, palette);
                int i = 0;
                while (i < data.width) {
                    int j = 0;
                    while (j < data.height) {
                        if (data.getPixel(i, j) != data.transparentPixel) {
                            sourceData.setPixel(i, j, 1);
                        }
                        ++j;
                    }
                    ++i;
                }
                Image highlightImage = new Image((Device)this.getDisplay(), sourceData);
                gc.drawImage(highlightImage, 0, 0, imageRect.width, imageRect.height, x, (rect.height - imageRect.height) / 2, rect.width - 10, imageRect.height);
                highlightImage.dispose();
            } else {
                gc.drawImage(img, 0, 0, imageRect.width, imageRect.height, x, (rect.height - imageRect.height) / 2, rect.width - 10, imageRect.height);
            }
            x += imageRect.width;
        }
    }

    public void setAlignment(int align) {
        this.checkWidget();
        if (align != 16384 && align != 131072 && align != 0x1000000) {
            SWT.error((int)5);
        }
        if (this.align != align) {
            this.align = align;
            this.redraw();
        }
    }

    public void setBackground(Color color) {
        Color background;
        super.setBackground(color);
        if (color != null && color.equals((Object)(background = this.getBackground()))) {
            return;
        }
        this.backgroundColor = color;
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.image) {
            this.image = image;
            this.redraw();
        }
    }
}

