/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.CompatibilityStatus;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.ICompatibleReportItem;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.IStyleDeclaration;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.validators.ExtensionValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.interfaces.IExtendedItemModel;
import org.eclipse.birt.report.model.elements.interfaces.ISupportThemeElement;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.elements.strategy.ExtendedItemPropSearchStrategy;
import org.eclipse.birt.report.model.extension.DummyPeerExtensibilityProvider;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.extension.PeerExtensibilityProvider;
import org.eclipse.birt.report.model.extension.PeerExtensibilityProviderFactory;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.util.ContentIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedItem
extends ReportItem
implements IExtendableElement,
IExtendedItemModel,
ISupportThemeElement {
    protected String extensionName = null;
    protected String extensionVersion = null;
    protected PeerExtensibilityProvider provider = new DummyPeerExtensibilityProvider(this, null);

    public ExtendedItem() {
        this(null);
    }

    public ExtendedItem(String theName) {
        super(theName);
        this.cachedPropStrategy = ExtendedItemPropSearchStrategy.getInstance();
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitExtendedItem(this);
    }

    @Override
    public String getElementName() {
        return "ExtendedItem";
    }

    @Override
    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public ExtendedItemHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new ExtendedItemHandle(module, this);
            IReportItem item = this.provider.getExtensionElement();
            if (item != null) {
                item.setHandle((ExtendedItemHandle)this.handle);
            }
        }
        return (ExtendedItemHandle)this.handle;
    }

    @Override
    public boolean hasLocalPropertyValues() {
        if (super.hasLocalPropertyValues()) {
            return true;
        }
        return this.provider.hasLocalPropertyValues();
    }

    @Override
    public Object getLocalProperty(Module module, ElementPropertyDefn prop) {
        assert (prop != null);
        if (!prop.isExtended()) {
            return super.getLocalProperty(module, prop);
        }
        return this.provider.getExtensionProperty(module, prop);
    }

    @Override
    public void setProperty(ElementPropertyDefn prop, Object value) {
        assert (prop != null);
        if (!prop.isExtended()) {
            super.setProperty(prop, value);
        } else {
            this.provider.setExtensionProperty(prop, value);
        }
    }

    @Override
    public ElementPropertyDefn getPropertyDefn(String propName) {
        assert (propName != null);
        ElementPropertyDefn propDefn = super.getPropertyDefn(propName);
        if (propDefn != null) {
            return propDefn;
        }
        return this.provider.getPropertyDefn(propName);
    }

    @Override
    public List<IElementPropertyDefn> getPropertyDefns() {
        return this.provider.getPropertyDefns();
    }

    @Override
    public ExtensionElementDefn getExtDefn() {
        return this.provider.getExtDefn();
    }

    public void initializeReportItem(Module module) throws ExtendedElementException {
        this.provider.initializeReportItem(module);
    }

    public PeerExtensibilityProvider getExtensibilityProvider() {
        return this.provider;
    }

    @Override
    protected Object getIntrinsicProperty(String propName) {
        if ("extensionName".equals(propName)) {
            return this.extensionName;
        }
        if ("extensionVersion".equals(propName)) {
            return this.extensionVersion;
        }
        return super.getIntrinsicProperty(propName);
    }

    @Override
    protected void setIntrinsicProperty(String propName, Object value) {
        if ("extensionName".equals(propName)) {
            this.setExtensionName((String)value);
        } else if ("extensionVersion".equals(propName)) {
            this.extensionVersion = (String)value;
        } else {
            super.setIntrinsicProperty(propName, value);
        }
    }

    @Override
    public List<SemanticException> validate(Module module) {
        List<SemanticException> list = super.validate(module);
        list.addAll(ExtensionValidator.getInstance().validate(module, this));
        return list;
    }

    public IReportItem getExtendedElement() {
        return this.provider.getExtensionElement();
    }

    public boolean isExtensionModelProperty(String propName) {
        return this.provider.isExtensionModelProperty(propName);
    }

    public boolean isExtensionXMLProperty(String propName) {
        return this.provider.isExtensionXMLProperty(propName);
    }

    public List<IElementPropertyDefn> getMethods() {
        return this.provider.getModelMethodDefns();
    }

    public String getScriptPropertyName() {
        IPropertyDefinition defn = this.provider.getScriptPropertyDefinition();
        return defn == null ? null : defn.getName();
    }

    private void setExtensionName(String extension) {
        this.extensionName = extension;
        this.provider = PeerExtensibilityProviderFactory.createProvider(this, this.extensionName);
        ExtensionElementDefn defn = this.provider.getExtDefn();
        if (defn != null) {
            this.cachedDefn = defn;
        }
        this.initSlots();
    }

    @Override
    public ContainerSlot getSlot(int slot) {
        assert (slot >= 0 && slot < this.cachedDefn.getSlotCount());
        return this.slots[slot];
    }

    public boolean hasLocalPropertyValuesOnOwnModel() {
        return this.provider.hasLocalPropertyValuesOnOwnModel();
    }

    public List<Object> getReportItemDefinedSelectors(Module module) {
        IReportItem reportItem = this.getExtendedElement();
        try {
            if (reportItem == null) {
                this.initializeReportItem(module);
                reportItem = this.getExtendedElement();
            }
        }
        catch (ExtendedElementException extendedElementException) {}
        if (reportItem == null) {
            return Collections.emptyList();
        }
        return reportItem.getPredefinedStyles();
    }

    @Override
    public String getLocalEncryptionID(ElementPropertyDefn propDefn) {
        if (propDefn == null || !propDefn.isEncryptable()) {
            return null;
        }
        if (!propDefn.isExtended()) {
            return super.getLocalEncryptionID(propDefn);
        }
        return this.provider.getEncryptionHelperID(propDefn);
    }

    @Override
    public void setEncryptionHelper(ElementPropertyDefn propDefn, String encryptionID) {
        if (!propDefn.isExtended()) {
            super.setEncryptionHelper(propDefn, encryptionID);
        }
        this.provider.setEncryptionHelper(propDefn, encryptionID);
    }

    @Override
    protected boolean hasLocalValue(ElementPropertyDefn propDefn) {
        if (propDefn == null) {
            return false;
        }
        if (!propDefn.isExtended()) {
            return super.hasLocalValue(propDefn);
        }
        return this.provider.getExtensionProperty(this.getRoot(), propDefn) != null;
    }

    @Override
    public Object getFactoryProperty(Module module, ElementPropertyDefn prop) {
        if (!prop.enableContextSearch() || !prop.isStyleProperty()) {
            return super.getFactoryProperty(module, prop);
        }
        return ((ExtendedItemPropSearchStrategy)ExtendedItemPropSearchStrategy.getInstance()).getMetaFactoryProperty(module, this, prop);
    }

    public StatusInfo checkCompatibility(Module module) {
        StatusInfo status = this.doCheck(module);
        ArrayList<SemanticException> errors = new ArrayList<SemanticException>();
        boolean hasCompatibilities = false;
        if (status != null) {
            errors.addAll(status.getErrors());
            hasCompatibilities = status.hasCompatibilities();
        }
        if (this.getExtendsElement() != null) {
            ContentIterator iter = new ContentIterator(module, this);
            while (iter.hasNext()) {
                DesignElement content = iter.next();
                if (!(content instanceof ExtendedItem) || (status = ((ExtendedItem)content).doCheck(module)) == null) continue;
                errors.addAll(status.getErrors());
                if (hasCompatibilities || !status.hasCompatibilities()) continue;
                hasCompatibilities = true;
            }
        }
        return new StatusInfo(errors, hasCompatibilities);
    }

    private StatusInfo doCheck(Module module) {
        if (!this.provider.needCheckCompatibility()) {
            return new StatusInfo(new ArrayList<SemanticException>(), false);
        }
        try {
            this.initializeReportItem(module);
        }
        catch (ExtendedElementException extendedElementException) {
            return new StatusInfo(new ArrayList<SemanticException>(), false);
        }
        IReportItem item = this.getExtendedElement();
        if (item instanceof ICompatibleReportItem) {
            CompatibilityStatus status = ((ICompatibleReportItem)((Object)item)).checkCompatibility();
            boolean hasCompatibilities = false;
            List<SemanticException> errors = Collections.emptyList();
            if (status != null) {
                errors = status.getErrors();
                hasCompatibilities = status.getStatusType() != 0;
            }
            return new StatusInfo(errors, hasCompatibilities);
        }
        return new StatusInfo(new ArrayList<SemanticException>(), false);
    }

    @Override
    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        ExtendedItem clonedElement = (ExtendedItem)super.doClone(null);
        clonedElement.provider.copyFromWithElementType(this.provider, policy);
        if (policy != null) {
            policy.execute(this, clonedElement);
        }
        return clonedElement;
    }

    @Override
    protected Object baseClone() throws CloneNotSupportedException {
        ExtendedItem clonedElement = (ExtendedItem)super.baseClone();
        clonedElement.provider = PeerExtensibilityProviderFactory.createProvider(clonedElement, clonedElement.extensionName);
        clonedElement.provider.copyFromWithNonElementType(this.provider);
        return clonedElement;
    }

    @Override
    public List<String> getElementSelectors() {
        ArrayList<String> list = new ArrayList<String>();
        String selector = null;
        ExtensionElementDefn elementDefn = this.getExtDefn();
        if (elementDefn != null) {
            selector = elementDefn.getSelector();
        }
        if (selector != null) {
            list.add(selector);
        }
        List<Object> tmpSelectors = this.getReportItemDefinedSelectors(this.getRoot());
        int i = 0;
        while (i < tmpSelectors.size()) {
            Object styleObject = tmpSelectors.get(i);
            selector = styleObject instanceof IStyleDeclaration ? ((IStyleDeclaration)styleObject).getName() : (String)styleObject;
            if (selector != null) {
                list.add(selector);
            }
            ++i;
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StatusInfo {
        private List<SemanticException> errors;
        private boolean hasCompatibilities = false;

        public StatusInfo(List<SemanticException> errors, boolean hasCompatibilities) {
            this.errors = errors;
            this.hasCompatibilities = hasCompatibilities;
        }

        public List<SemanticException> getErrors() {
            return this.errors == null ? Collections.emptyList() : this.errors;
        }

        public boolean hasCompatibilities() {
            return this.hasCompatibilities;
        }
    }
}

