/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellHelper {
    public static Cell findCell(Module module, GridItem grid, int rowNum, int colNum) {
        if (grid == null) {
            return null;
        }
        if (colNum > grid.findMaxCols(module)) {
            return null;
        }
        ContainerSlot rowSlot = grid.getSlot(1);
        int i = 0;
        while (i < rowSlot.getCount()) {
            TableRow row = (TableRow)rowSlot.getContent(i);
            ContainerSlot cellSlot = row.getSlot(0);
            int j = 0;
            while (j < cellSlot.getCount()) {
                int rowIndex = i;
                Cell cell = (Cell)cellSlot.getContent(j);
                int rowSpan = cell.getIntProperty(module, "rowSpan");
                int n = rowSpan = rowSpan < 1 ? 1 : rowSpan;
                if ((rowIndex += rowSpan) >= rowNum) {
                    int colIndex = 0;
                    int column = grid.getCellPositionInColumn(module, cell);
                    assert (column > 0);
                    int colSpan = cell.getIntProperty(module, "colSpan");
                    colSpan = colSpan < 1 ? 1 : colSpan;
                    colIndex = column + colSpan - 1;
                    if (colIndex >= colNum) {
                        return cell;
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static List<Cell> getCells(ContainerSlot rowSlot) {
        ArrayList<Cell> list = new ArrayList<Cell>();
        List<DesignElement> rowList = rowSlot.getContents();
        int i = 0;
        while (i < rowList.size()) {
            TableRow tableRow = (TableRow)rowList.get(i);
            List<DesignElement> cellList = tableRow.getContentsSlot();
            int j = 0;
            while (j < cellList.size()) {
                Cell cell = (Cell)cellList.get(j);
                list.add(cell);
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static List<Cell> getCellsInTableGroup(ContainerSlot rowSlot) {
        ArrayList<Cell> list = new ArrayList<Cell>();
        List<DesignElement> groupList = rowSlot.getContents();
        int i = 0;
        while (i < groupList.size()) {
            TableGroup group = (TableGroup)groupList.get(i);
            ContainerSlot slot = group.getSlot(0);
            list.addAll(CellHelper.getCells(slot));
            slot = group.getSlot(1);
            list.addAll(CellHelper.getCells(slot));
            ++i;
        }
        return list;
    }
}

