/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.IVersionInfo;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleRuleHandle;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.XPathUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.parser.ActionStructureState;
import org.eclipse.birt.report.model.parser.DesignReader;
import org.eclipse.birt.report.model.parser.GenericModuleReader;
import org.eclipse.birt.report.model.parser.LibraryReader;
import org.eclipse.birt.report.model.parser.ModuleParserErrorHandler;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.DataTypeConversionUtil;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.VersionControlMgr;
import org.eclipse.birt.report.model.util.VersionInfo;
import org.eclipse.birt.report.model.util.VersionUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.eclipse.birt.report.model.writer.IndentableXMLWriter;
import org.eclipse.birt.report.model.writer.ModuleWriter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleUtil {
    public static final int LIBRARY = 0;
    public static final int REPORT_DESIGN = 1;
    public static final int INVALID_MODULE = 2;

    public static ActionHandle deserializeAction(InputStream streamData) throws DesignFileException {
        return ModuleUtil.deserializeAction(streamData, null);
    }

    public static ActionHandle deserializeAction(InputStream streamData, DesignElementHandle element) throws DesignFileException {
        ImageItem image = new ImageItem();
        DesignElement e = element == null ? image : element.getElement();
        ActionParserHandler handler = new ActionParserHandler(image);
        Module module = element == null ? handler.getModule() : element.getModule();
        ElementPropertyDefn propDefn = e.getPropertyDefn("action");
        if (streamData == null) {
            Action action = StructureFactory.createAction();
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.add(action);
            e.setProperty(propDefn, actions);
            action.setContext(new StructureContext(e, propDefn, (Structure)action));
            return ModuleUtil.getActionHandle(e.getHandle(module));
        }
        if (!streamData.markSupported()) {
            streamData = new BufferedInputStream(streamData);
        }
        assert (streamData.markSupported());
        ModuleUtil.parse(handler, streamData, "");
        if (element != null) {
            List actions = (List)((DesignElement)image).getProperty(handler.getModule(), propDefn);
            assert (actions != null && actions.size() == 1);
            Action action = (Action)actions.get(0);
            e.setProperty(propDefn, (Object)actions);
            action.setContext(new StructureContext(e, e.getPropertyDefn("action"), (Structure)action));
        }
        return ModuleUtil.getActionHandle(e.getHandle(module));
    }

    private static ActionHandle getActionHandle(DesignElementHandle element) {
        PropertyHandle propHandle = element.getPropertyHandle("action");
        List actions = (List)propHandle.getValue();
        assert (actions != null && actions.size() == 1);
        Action action = (Action)actions.get(0);
        if (action == null) {
            return null;
        }
        return (ActionHandle)action.getHandle(propHandle);
    }

    private static void parse(XMLParserHandler handler, InputStream streamData, String filename) throws DesignFileException {
        try {
            ModelUtil.checkUTFSignature(streamData, filename);
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser parser = saxParserFactory.newSAXParser();
            InputSource inputSource = new InputSource(streamData);
            inputSource.setEncoding("UTF-8");
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            List<XMLParserException> errors = handler.getErrorHandler().getErrors();
            if (e.getException() instanceof DesignFileException) {
                throw (DesignFileException)((Object)e.getException());
            }
            throw new DesignFileException(null, errors, e);
        }
        catch (ParserConfigurationException e) {
            throw new DesignFileException(null, handler.getErrorHandler().getErrors(), e);
        }
        catch (IOException e) {
            throw new DesignFileException(null, handler.getErrorHandler().getErrors(), e);
        }
    }

    public static ActionHandle deserializeAction(String strData) throws DesignFileException {
        return ModuleUtil.deserializeAction(strData, null);
    }

    public static ActionHandle deserializeAction(String strData, DesignElementHandle element) throws DesignFileException {
        ByteArrayInputStream is;
        block3: {
            is = null;
            String streamToOpen = StringUtil.trimString(strData);
            if (streamToOpen != null) {
                try {
                    is = new ByteArrayInputStream(streamToOpen.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
        return ModuleUtil.deserializeAction(is, element);
    }

    public static String serializeAction(ActionHandle action) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ActionWriter writer = new ActionWriter();
        writer.write(os, (Action)action.getStructure());
        try {
            return os.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return os.toString();
        }
    }

    public static boolean isValidDesign(SessionHandle sessionHandle, String fileName, InputStream is) {
        ReportDesign design = null;
        try {
            ModuleOption options = new ModuleOption();
            options.setSemanticCheck(false);
            design = DesignReader.getInstance().read((DesignSessionImpl)sessionHandle.getSession(), fileName, is, options);
            return design != null;
        }
        catch (DesignFileException designFileException) {
            return false;
        }
    }

    public static boolean isValidLibrary(SessionHandle sessionHandle, String fileName, InputStream is) {
        Library lib = null;
        try {
            ModuleOption options = new ModuleOption();
            options.setSemanticCheck(false);
            lib = LibraryReader.getInstance().read((DesignSessionImpl)sessionHandle.getSession(), fileName, is, options);
            return lib != null;
        }
        catch (DesignFileException designFileException) {
            return false;
        }
    }

    public static int checkModule(SessionHandle sessionHandle, String fileName, InputStream is) {
        Module rtnModule = null;
        try {
            ModuleOption options = new ModuleOption();
            options.setSemanticCheck(false);
            rtnModule = GenericModuleReader.getInstance().read((DesignSessionImpl)sessionHandle.getSession(), fileName, is, options);
        }
        catch (DesignFileException designFileException) {
            return 2;
        }
        return rtnModule instanceof Library ? 0 : 1;
    }

    private static List<IVersionInfo> checkVersion(InputStream streamData, String filename) throws DesignFileException {
        DesignSession session = new DesignSession(ThreadResources.getLocale());
        byte[] buf = new byte[512];
        ByteArrayOutputStream bySteam = new ByteArrayOutputStream();
        byte[] data = null;
        try {
            int len;
            while ((len = streamData.read(buf)) > 0) {
                bySteam.write(buf, 0, len);
                bySteam.flush();
            }
            data = bySteam.toByteArray();
            bySteam.close();
        }
        catch (IOException iOException) {}
        try {
            ByteArrayInputStream inputStreamToParse = new ByteArrayInputStream(data);
            Module module = session.openModule(filename, inputStreamToParse);
            String version = module.getVersionManager().getVersion();
            List<IVersionInfo> retList = ModelUtil.checkVersion(version);
            if (ModuleUtil.hasCompatibilities(module)) {
                retList.add(new VersionInfo(version, 4));
            }
            return retList;
        }
        catch (DesignFileException designFileException) {
            if (data != null) {
                VersionParserHandler handler = new VersionParserHandler();
                InputStream inputStreamToParse = new ByteArrayInputStream(data);
                if (!((InputStream)inputStreamToParse).markSupported()) {
                    inputStreamToParse = new BufferedInputStream(streamData);
                }
                ModuleUtil.parse(handler, inputStreamToParse, filename);
                return ModelUtil.checkVersion(handler.version);
            }
            return Collections.emptyList();
        }
    }

    private static boolean hasCompatibilities(Module module) {
        VersionControlMgr versionMgr = module.getVersionManager();
        if (versionMgr.hasExtensionCompatibilities()) {
            return true;
        }
        List<Library> libs = module.getAllLibraries();
        if (libs != null && !libs.isEmpty()) {
            int i = 0;
            while (i < libs.size()) {
                Library lib = libs.get(i);
                if (lib.getVersionManager().hasExtensionCompatibilities()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static List checkVersion(String fileName) {
        ArrayList<IVersionInfo> rtnList;
        block17: {
            rtnList = new ArrayList<IVersionInfo>();
            InputStream inputStream = null;
            try {
                URL url = ModelUtil.getURLPresentation(fileName);
                inputStream = url.openStream();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                rtnList.add(new VersionInfo(null, 0));
                return rtnList;
            }
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream(fileName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    rtnList.add(new VersionInfo(null, 0));
                    return rtnList;
                }
            }
            try {
                try {
                    inputStream = new BufferedInputStream(inputStream);
                    rtnList.addAll(ModuleUtil.checkVersion(inputStream, fileName));
                }
                catch (DesignFileException designFileException) {
                    rtnList.add(new VersionInfo(null, 0));
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return rtnList;
    }

    public static String getExternalizedValue(DesignElementHandle element, String key, String value, ULocale locale) {
        if (element == null) {
            return value;
        }
        DesignElement tmpElement = element.getElement();
        while (tmpElement != null) {
            Module root = tmpElement.getRoot();
            if (root == null) break;
            String externalizedText = root.getMessage(key, locale);
            if (externalizedText != null) {
                return externalizedText;
            }
            tmpElement = !tmpElement.isVirtualElement() ? tmpElement.getExtendsElement() : tmpElement.getVirtualParent();
        }
        return value;
    }

    public static boolean isEqualHierarchiesForJointCondition(HierarchyHandle conditionHierarchy, HierarchyHandle cubeHierarchy) {
        if (conditionHierarchy == cubeHierarchy) {
            return true;
        }
        if (conditionHierarchy != null && cubeHierarchy != null) {
            if (conditionHierarchy.equals(cubeHierarchy)) {
                return true;
            }
            DesignElement virtualParent = cubeHierarchy.getElement().getVirtualParent();
            if (virtualParent == null) {
                return false;
            }
            return conditionHierarchy.getElement().equals(virtualParent);
        }
        return false;
    }

    public static boolean isValidElementName(DesignElementHandle elementHandle, String propName, String nameValue) {
        ModuleHandle module = elementHandle.getModuleHandle();
        PropertyDefn propDefn = (PropertyDefn)((Object)elementHandle.getPropertyDefn(propName));
        if (propDefn == null) {
            return false;
        }
        PropertyType propType = propDefn.getType();
        if (propType.getTypeCode() != 13) {
            return false;
        }
        ElementDefn metaData = (ElementDefn)elementHandle.getDefn();
        if ((nameValue == null || StringUtil.isEmpty(nameValue)) && metaData.getNameOption() == 2) {
            return false;
        }
        try {
            propType.validateValue(module.getModule(), elementHandle.getElement(), propDefn, nameValue);
            DesignElement existedElement = new NameExecutor(elementHandle.getElement()).getNameSpace(elementHandle.module).getElement(nameValue);
            return existedElement == null;
        }
        catch (PropertyValueException propertyValueException) {
            return false;
        }
    }

    public static boolean isValidElementName(DesignElementHandle elementHandle) {
        return ModuleUtil.isValidElementName(elementHandle, "name", elementHandle.getName());
    }

    public static boolean isListFilterValue(FilterConditionHandle filter) {
        if (filter == null) {
            return false;
        }
        if ("in".equals(filter.getOperator())) {
            return true;
        }
        return "not-in".equals(filter.getOperator());
    }

    public static boolean isListStyleRuleValue(StyleRuleHandle rule) {
        if (rule == null) {
            return false;
        }
        if ("in".equals(rule.getOperator())) {
            return true;
        }
        return "not-in".equals(rule.getOperator());
    }

    public static boolean isListFilterValue(FilterConditionElementHandle filter) {
        if (filter == null) {
            return false;
        }
        if ("in".equals(filter.getOperator())) {
            return true;
        }
        return "not-in".equals(filter.getOperator());
    }

    public static String convertParamTypeToColumnType(String type) {
        return DataTypeConversionUtil.converToColumnDataType(type);
    }

    public static String convertColumnTypeToParamType(String type) {
        return DataTypeConversionUtil.converToParamType(type);
    }

    public static String getScriptUID(Object instance) {
        if (ModuleUtil.isValidScript(instance)) {
            return XPathUtil.getXPath(instance);
        }
        return null;
    }

    public static String getScriptUID(Object instance, int index) {
        if (ModuleUtil.isValidScript(instance)) {
            return XPathUtil.getXPath(instance, index);
        }
        return null;
    }

    public static String getScript(ModuleHandle module, String uid) {
        Object instance = XPathUtil.getInstance(module, uid);
        if (instance == null) {
            return null;
        }
        if (instance instanceof String) {
            return (String)instance;
        }
        if (ModuleUtil.isValidScript(instance)) {
            return ((SimpleValueHandle)instance).getStringValue();
        }
        return null;
    }

    public static Object getScriptObject(ModuleHandle module, String uid) {
        Object instance = XPathUtil.getInstance(module, uid);
        if (ModuleUtil.isValidScript(instance)) {
            return instance;
        }
        return null;
    }

    private static boolean isValidScript(Object instance) {
        SimpleValueHandle temp;
        PropertyDefn defn;
        return instance instanceof PropertyHandle && ((defn = (PropertyDefn)(temp = (SimpleValueHandle)instance).getDefn()).getTypeCode() == 20 ? defn.getSubType().getTypeCode() == 7 : defn.getTypeCode() == 7 || defn.getTypeCode() == 18);
    }

    public static long gerSerializedID(DesignElementHandle element) {
        DesignElementHandle tmpContainer;
        if (element == null) {
            return 0L;
        }
        if ((element instanceof MultiViewsHandle || element.getContainer() instanceof MultiViewsHandle) && (tmpContainer = element.getContainer()) != null) {
            return tmpContainer.getID();
        }
        return element.getID();
    }

    public static String getReportVersion() {
        return "3.2.21";
    }

    public static int compareReportVersion(String version1, String version2) throws IllegalArgumentException {
        int intVersion2;
        int intVersion1 = VersionUtil.parseVersion(version1);
        return intVersion1 < (intVersion2 = VersionUtil.parseVersion(version2)) ? -1 : (intVersion1 == intVersion2 ? 0 : 1);
    }

    public static boolean isInclude(ModuleHandle moduleHandle, String fileName) {
        if (moduleHandle == null || StringUtil.isBlank(fileName)) {
            return false;
        }
        URL fileLocation = ModelUtil.getURLPresentation(fileName);
        if (fileLocation == null) {
            return false;
        }
        return moduleHandle.getModule().getLibraryByLocation(fileLocation.toExternalForm(), Integer.MAX_VALUE) != null;
    }

    public static List<DesignElementHandle> getElementsByType(ModuleHandle moduleHandle, String elementType) {
        if (moduleHandle == null || StringUtil.isBlank(elementType)) {
            return Collections.emptyList();
        }
        IElementDefn elementDefn = MetaDataDictionary.getInstance().getElement(elementType);
        return ModuleUtil.getElementsByType(moduleHandle, elementDefn);
    }

    private static List<DesignElementHandle> getElementsByType(ModuleHandle moduleHandle, IElementDefn elementType) {
        if (moduleHandle == null || elementType == null) {
            return Collections.emptyList();
        }
        ArrayList<DesignElementHandle> retList = new ArrayList<DesignElementHandle>();
        Module module = moduleHandle.getModule();
        List<DesignElement> elements = module.getAllElements();
        if (elements != null) {
            for (DesignElement element : elements) {
                if (element == null || !element.getDefn().isKindOf(elementType)) continue;
                retList.add(element.getHandle(module));
            }
        }
        return retList;
    }

    private static class ActionParserHandler
    extends ModuleParserHandler {
        DesignElement element = null;

        public ActionParserHandler(DesignElement element) {
            super(null, null);
            this.element = element;
            this.module = new ReportDesign(null);
            this.setVersionNumber(3022100);
            this.module.setID(this.module.getNextID());
            this.module.addElementID(this.module);
        }

        public AbstractParseState createStartState() {
            return new StartState();
        }

        class StartState
        extends XMLParserHandler.InnerParseState {
            StartState() {
                super(ActionParserHandler.this);
            }

            public AbstractParseState startElement(String tagName) {
                if ("structure".equalsIgnoreCase(tagName)) {
                    ActionStructureState state = new ActionStructureState(ActionParserHandler.this, ActionParserHandler.this.element);
                    state.setName("action");
                    return state;
                }
                return super.startElement(tagName);
            }
        }
    }

    private static class ActionWriter
    extends ModuleWriter {
        private ActionWriter() {
        }

        public void write(OutputStream os, Action action) throws IOException {
            this.writer = new SectionXMLWriter(os, "UTF-8");
            this.writeAction(action);
        }

        protected Module getModule() {
            return null;
        }
    }

    private static class SectionXMLWriter
    extends IndentableXMLWriter {
        public SectionXMLWriter(OutputStream os, String signature) throws IOException {
            this.out = new PrintStream(os, false, "UTF-8");
        }
    }

    private static class VersionParserHandler
    extends XMLParserHandler {
        private String version = null;

        public VersionParserHandler() {
            super(new ModuleParserErrorHandler());
        }

        public AbstractParseState createStartState() {
            return new StartState();
        }

        class StartState
        extends XMLParserHandler.InnerParseState {
            StartState() {
                super(VersionParserHandler.this);
            }

            public AbstractParseState startElement(String tagName) {
                if ("report".equalsIgnoreCase(tagName) || "library".equalsIgnoreCase(tagName)) {
                    return new VersionState();
                }
                return super.startElement(tagName);
            }
        }

        class VersionState
        extends XMLParserHandler.InnerParseState {
            VersionState() {
                super(VersionParserHandler.this);
            }

            public void parseAttrs(Attributes attrs) throws XMLParserException {
                String version = attrs.getValue("version");
                VersionParserHandler.this.version = version;
            }

            public void end() throws SAXException {
            }
        }
    }
}

