/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareMessages;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaNode;

class JavaTextBufferNode
implements ITypedElement,
IEncodedStreamContentAccessor,
IResourceProvider {
    private IFile fFile;
    private IDocument fDocument;
    private boolean fInEditor;

    JavaTextBufferNode(IFile file, IDocument document, boolean inEditor) {
        this.fFile = file;
        this.fDocument = document;
        this.fInEditor = inEditor;
    }

    public String getName() {
        if (this.fInEditor) {
            return CompareMessages.Editor_Buffer;
        }
        return CompareMessages.Workspace_File;
    }

    public String getType() {
        return "java";
    }

    public Image getImage() {
        return null;
    }

    public InputStream getContents() {
        return new ByteArrayInputStream(JavaCompareUtilities.getBytes(this.fDocument.get(), "UTF-16"));
    }

    public String getCharset() {
        return "UTF-16";
    }

    public IResource getResource() {
        return this.fFile;
    }

    static final ITypedElement[] buildEditions(ITypedElement target, IFile file) {
        IFileState[] states = null;
        try {
            states = file.getHistory(null);
        }
        catch (CoreException ex) {
            JavaScriptPlugin.log(ex);
        }
        int count = 1;
        if (states != null) {
            count += states.length;
        }
        ITypedElement[] editions = new ITypedElement[count];
        editions[0] = new ResourceNode((IResource)file);
        if (states != null) {
            int i = 0;
            while (i < states.length) {
                editions[i + 1] = new HistoryItem(target, states[i]);
                ++i;
            }
        }
        return editions;
    }

    static final int getPlaceHolderType(ITypedElement element) {
        if (element instanceof DocumentRangeNode) {
            JavaNode jn = (JavaNode)element;
            switch (jn.getTypeCode()) {
                case 1: {
                    return 35;
                }
                case 4: 
                case 5: {
                    return 55;
                }
                case 10: 
                case 11: {
                    return 31;
                }
                case 8: {
                    return 23;
                }
                case 9: {
                    return 28;
                }
                case 2: 
                case 3: {
                    return 26;
                }
                case 0: {
                    return 15;
                }
            }
        }
        return -1;
    }
}

