/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.utility.internal.ReflectionTools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistenceUnitProperties
extends AbstractModel
implements PersistenceUnitProperties {
    private PersistenceUnit persistenceUnit;
    private Map<String, String> propertyNames;
    private static final long serialVersionUID = 1L;

    protected AbstractPersistenceUnitProperties(PersistenceUnit parent) {
        this.initialize();
        this.initialize(parent);
        this.postInitialize();
    }

    protected void initialize() {
        this.propertyNames = new HashMap<String, String>();
    }

    protected void initialize(PersistenceUnit parent) {
        this.persistenceUnit = parent;
        this.initializePropertyNames();
        this.initializeProperties();
    }

    protected void initializePropertyNames() {
        this.addPropertyNames(this.propertyNames);
    }

    protected abstract void initializeProperties();

    protected void postInitialize() {
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    @Override
    public JpaProject getJpaProject() {
        return this.persistenceUnit.getJpaProject();
    }

    private Map<String, String> propertyNames() {
        return this.propertyNames;
    }

    protected abstract void addPropertyNames(Map<String, String> var1);

    @Override
    public boolean itemIsProperty(PersistenceUnit.Property item) {
        if (item == null) {
            throw new NullPointerException();
        }
        return this.propertyNames().keySet().contains(item.getName());
    }

    @Override
    public String propertyIdOf(PersistenceUnit.Property property) {
        String propertyId = this.propertyNames().get(property.getName());
        if (propertyId == null) {
            throw new IllegalArgumentException("Illegal property: " + property);
        }
        return propertyId;
    }

    public String propertyIdOf(String eclipseLinkkey) {
        String propertyId = this.propertyNames().get(eclipseLinkkey);
        if (propertyId == null) {
            throw new IllegalArgumentException("Illegal property: " + eclipseLinkkey);
        }
        return propertyId;
    }

    protected String persistenceUnitKeyOf(String propertyId) {
        for (String persistenceUnitKey : this.propertyNames().keySet()) {
            if (!this.propertyNames().get(persistenceUnitKey).equals(propertyId)) continue;
            return persistenceUnitKey;
        }
        throw new IllegalArgumentException("Illegal property ID: " + propertyId);
    }

    protected void putProperty(String key, Object value) {
        this.putProperty(key, value, false);
    }

    protected void putProperty(String key, Object value, boolean allowDuplicates) {
        String persistenceUnitKey = this.persistenceUnitKeyOf(key);
        if (value != null && value.getClass().isEnum()) {
            this.putEnumValue(persistenceUnitKey, (Enum)value, allowDuplicates);
        } else {
            this.putPersistenceUnitProperty(persistenceUnitKey, null, value, allowDuplicates);
        }
    }

    private void putPersistenceUnitProperty(String key, String keySuffix, Object value, boolean allowDuplicates) {
        String persistenceUnitKey = keySuffix == null ? key : String.valueOf(key) + keySuffix;
        String stringValue = value == null ? null : value.toString();
        this.getPersistenceUnit().setProperty(persistenceUnitKey, stringValue, allowDuplicates);
    }

    protected void removeProperty(String key, String value) {
        String persistenceUnitKey = this.persistenceUnitKeyOf(key);
        this.getPersistenceUnit().removeProperty(persistenceUnitKey, value);
    }

    protected boolean persistenceUnitKeyExists(String persistenceUnitKey) {
        return this.getStringValue(persistenceUnitKey) != null;
    }

    protected String getStringValue(String persistenceUnitKey) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(persistenceUnitKey);
        return p == null ? null : p.getValue();
    }

    protected String getStringValue(String key, String keySuffix) {
        return this.getStringValue(keySuffix == null ? key : String.valueOf(key) + keySuffix);
    }

    protected void putStringValue(String key, String newValue) {
        this.putStringValue(key, null, newValue, false);
    }

    protected void putStringValue(String key, String newValue, boolean allowDuplicate) {
        this.putStringValue(key, null, newValue, allowDuplicate);
    }

    protected void putStringValue(String key, String keySuffix, String newValue, boolean allowDuplicate) {
        this.putPersistenceUnitProperty(key, keySuffix, newValue, allowDuplicate);
    }

    protected Integer getIntegerValue(String persistenceUnitKey) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(persistenceUnitKey);
        return p == null ? null : AbstractPersistenceUnitProperties.getIntegerValueOf(p.getValue());
    }

    protected Integer getIntegerValue(String key, String keySuffix) {
        return this.getIntegerValue(keySuffix == null ? key : String.valueOf(key) + keySuffix);
    }

    protected void putIntegerValue(String key, Integer newValue) {
        this.putIntegerValue(key, null, newValue, false);
    }

    protected void putIntegerValue(String key, Integer newValue, boolean allowDuplicate) {
        this.putIntegerValue(key, null, newValue, allowDuplicate);
    }

    protected void putIntegerValue(String key, String keySuffix, Integer newValue, boolean allowDuplicate) {
        this.putPersistenceUnitProperty(key, keySuffix, newValue, allowDuplicate);
    }

    protected Boolean getBooleanValue(String persistenceUnitKey) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(persistenceUnitKey);
        return p == null ? null : AbstractPersistenceUnitProperties.getBooleanValueOf(p.getValue());
    }

    protected Boolean getBooleanValue(String key, String keySuffix) {
        return this.getBooleanValue(keySuffix == null ? key : String.valueOf(key) + keySuffix);
    }

    protected void putBooleanValue(String key, Boolean newValue) {
        this.putBooleanValue(key, null, newValue, false);
    }

    protected void putBooleanValue(String key, Boolean newValue, boolean allowDuplicate) {
        this.putBooleanValue(key, null, newValue, allowDuplicate);
    }

    protected void putBooleanValue(String key, String keySuffix, Boolean newValue, boolean allowDuplicate) {
        this.putPersistenceUnitProperty(key, keySuffix, newValue, allowDuplicate);
    }

    protected <T extends Enum<T>> T getEnumValue(String persistenceUnitKey, T[] enumValues) {
        PersistenceUnit.Property p = this.getPersistenceUnit().getProperty(persistenceUnitKey);
        return (T)(p == null ? null : AbstractPersistenceUnitProperties.getEnumValueOf((String)p.getValue(), enumValues));
    }

    protected <T extends Enum<T>> T getEnumValue(String key, String keySuffix, T[] enumValues) {
        return (T)this.getEnumValue(keySuffix == null ? key : String.valueOf(key) + keySuffix, (Enum[])enumValues);
    }

    protected <T extends Enum<T>> void putEnumValue(String key, T newValue) {
        this.putEnumValue(key, null, newValue, false);
    }

    protected <T extends Enum<T>> void putEnumValue(String key, T newValue, boolean allowDuplicate) {
        this.putEnumValue(key, null, newValue, allowDuplicate);
    }

    protected <T extends Enum<T>> void putEnumValue(String key, String keySuffix, T newValue, boolean allowDuplicate) {
        this.putPersistenceUnitProperty(key, keySuffix, AbstractPersistenceUnitProperties.getPropertyStringValueOf(newValue), allowDuplicate);
    }

    public static Boolean getBooleanValueOf(String puStringValue) {
        if (puStringValue == null) {
            return null;
        }
        return Boolean.valueOf(puStringValue);
    }

    public static Integer getIntegerValueOf(String puStringValue) {
        if (puStringValue == null) {
            return null;
        }
        return Integer.valueOf(puStringValue);
    }

    public static <T extends Enum<T>> T getEnumValueOf(String puStringValue, T[] enumValues) {
        T[] TArray = enumValues;
        int n = enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            T enumValue = TArray[n2];
            if (AbstractPersistenceUnitProperties.getPropertyStringValueOf(enumValue).equals(puStringValue)) {
                return enumValue;
            }
            ++n2;
        }
        return null;
    }

    public static String getPropertyStringValueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isEnum()) {
            return (String)ReflectionTools.getStaticFieldValue(value.getClass(), (String)value.toString().toUpperCase(Locale.ENGLISH));
        }
        return value.toString();
    }
}

