/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmPrimaryKeyJoinColumnJoiningStrategy
extends AbstractOrmXmlContextNode
implements OrmPrimaryKeyJoinColumnJoiningStrategy {
    protected XmlOneToOne resource;
    protected final Vector<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns = new Vector();
    protected final OrmJoinColumn.Owner joinColumnOwner;

    public GenericOrmPrimaryKeyJoinColumnJoiningStrategy(OrmPrimaryKeyJoinColumnEnabledRelationshipReference parent, XmlOneToOne resource) {
        super(parent);
        this.resource = resource;
        this.joinColumnOwner = this.buildJoinColumnOwner();
        this.initializePrimaryKeyJoinColumns();
    }

    protected OrmJoinColumn.Owner buildJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    protected void initializePrimaryKeyJoinColumns() {
        if (this.resource != null) {
            for (XmlPrimaryKeyJoinColumn resourceJoinColumn : this.resource.getPrimaryKeyJoinColumns()) {
                this.primaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(resourceJoinColumn));
            }
        }
    }

    protected OrmPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(XmlPrimaryKeyJoinColumn resourceJoinColumn) {
        return this.getXmlContextNodeFactory().buildOrmPrimaryKeyJoinColumn(this, this.joinColumnOwner, resourceJoinColumn);
    }

    @Override
    public OrmJoinColumnEnabledRelationshipReference getParent() {
        return (OrmJoinColumnEnabledRelationshipReference)super.getParent();
    }

    @Override
    public OrmJoinColumnEnabledRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    public OrmRelationshipMapping getRelationshipMapping() {
        return this.getRelationshipReference().getRelationshipMapping();
    }

    @Override
    public String getTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public String getColumnTableNotValidDescription() {
        return JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY;
    }

    protected TypeMapping getTypeMapping() {
        return this.getRelationshipMapping().getTypeMapping();
    }

    @Override
    public void addStrategy() {
        if (this.primaryKeyJoinColumnsSize() == 0) {
            this.addPrimaryKeyJoinColumn(0);
        }
    }

    @Override
    public void removeStrategy() {
        for (PrimaryKeyJoinColumn each : CollectionTools.iterable(this.primaryKeyJoinColumns())) {
            this.removePrimaryKeyJoinColumn(each);
        }
    }

    @Override
    public boolean isOverridableAssociation() {
        return false;
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return new CloneListIterator(this.primaryKeyJoinColumns);
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.primaryKeyJoinColumns.size();
    }

    @Override
    public boolean hasPrimaryKeyJoinColumns() {
        return !this.primaryKeyJoinColumns.isEmpty();
    }

    @Override
    public OrmPrimaryKeyJoinColumn addPrimaryKeyJoinColumn(int index) {
        XmlPrimaryKeyJoinColumn resourcePkJoinColumn = OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn();
        OrmPrimaryKeyJoinColumn contextPkJoinColumn = this.buildPrimaryKeyJoinColumn(resourcePkJoinColumn);
        this.primaryKeyJoinColumns.add(index, contextPkJoinColumn);
        this.resource.getPrimaryKeyJoinColumns().add(index, (Object)resourcePkJoinColumn);
        this.fireItemAdded("primaryKeyJoinColumns", index, contextPkJoinColumn);
        return contextPkJoinColumn;
    }

    protected void addPrimaryKeyJoinColumn(int index, OrmPrimaryKeyJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumns");
    }

    protected void addPrimaryKeyJoinColumn(OrmPrimaryKeyJoinColumn joinColumn) {
        this.addPrimaryKeyJoinColumn(this.primaryKeyJoinColumns.size(), joinColumn);
    }

    @Override
    public void removePrimaryKeyJoinColumn(PrimaryKeyJoinColumn pkJoinColumn) {
        this.removePrimaryKeyJoinColumn(this.primaryKeyJoinColumns.indexOf(pkJoinColumn));
    }

    @Override
    public void removePrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn removedPkJoinColumn = this.primaryKeyJoinColumns.remove(index);
        this.resource.getPrimaryKeyJoinColumns().remove(index);
        this.fireItemRemoved("primaryKeyJoinColumns", index, removedPkJoinColumn);
    }

    protected void removePrimaryKeyJoinColumn_(OrmPrimaryKeyJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.primaryKeyJoinColumns, "primaryKeyJoinColumns");
    }

    @Override
    public void movePrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.primaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.resource.getPrimaryKeyJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("primaryKeyJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public void update() {
        this.updatePrimaryKeyJoinColumns();
    }

    protected void updatePrimaryKeyJoinColumns() {
        CloneIterator xmlPkJoinColumns = new CloneIterator(this.resource.getPrimaryKeyJoinColumns());
        ListIterator<OrmPrimaryKeyJoinColumn> contextPkJoinColumns = this.primaryKeyJoinColumns();
        while (contextPkJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn contextPkJoinColumn = (OrmPrimaryKeyJoinColumn)contextPkJoinColumns.next();
            if (xmlPkJoinColumns.hasNext()) {
                contextPkJoinColumn.update((XmlPrimaryKeyJoinColumn)xmlPkJoinColumns.next());
                continue;
            }
            this.removePrimaryKeyJoinColumn_(contextPkJoinColumn);
        }
        while (xmlPkJoinColumns.hasNext()) {
            this.addPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn((XmlPrimaryKeyJoinColumn)xmlPkJoinColumns.next()));
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getRelationshipReference().getValidationTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JoinColumnOwner
    implements OrmJoinColumn.Owner {
        protected JoinColumnOwner() {
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmPrimaryKeyJoinColumnJoiningStrategy.this.getTableName();
        }

        @Override
        public Entity getRelationshipTarget() {
            return GenericOrmPrimaryKeyJoinColumnJoiningStrategy.this.getRelationshipMapping().getResolvedTargetEntity();
        }

        @Override
        public String getAttributeName() {
            return GenericOrmPrimaryKeyJoinColumnJoiningStrategy.this.getRelationshipMapping().getName();
        }

        @Override
        public PersistentAttribute getPersistentAttribute() {
            return GenericOrmPrimaryKeyJoinColumnJoiningStrategy.this.getRelationshipMapping().getPersistentAttribute();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        public boolean tableIsAllowed() {
            return true;
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return this.getTypeMapping().associatedTableNamesIncludingInherited();
        }

        @Override
        public TypeMapping getTypeMapping() {
            return GenericOrmPrimaryKeyJoinColumnJoiningStrategy.this.getTypeMapping();
        }

        @Override
        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        @Override
        public Table getReferencedColumnDbTable() {
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
        }

        @Override
        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return false;
        }

        @Override
        public String getDefaultColumnName() {
            return null;
        }

        @Override
        public int joinColumnsSize() {
            return GenericOrmPrimaryKeyJoinColumnJoiningStrategy.this.primaryKeyJoinColumnsSize();
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericOrmPrimaryKeyJoinColumnJoiningStrategy.this.getValidationTextRange();
        }

        @Override
        public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet");
        }

        @Override
        public IMessage buildTableNotValidMessage(BaseColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet");
        }

        @Override
        public IMessage buildUnresolvedReferencedColumnNameMessage(BaseJoinColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet");
        }

        @Override
        public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet");
        }

        @Override
        public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet");
        }
    }
}

