/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmJoinTableJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmOwnableRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmPrimaryKeyJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOneToOneRelationshipReference2_0;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumnsMapping;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmOneToOneRelationshipReference
extends AbstractOrmRelationshipReference
implements OrmOneToOneRelationshipReference2_0 {
    protected OrmMappedByJoiningStrategy mappedByJoiningStrategy;
    protected OrmJoinColumnJoiningStrategy joinColumnJoiningStrategy;
    protected OrmPrimaryKeyJoinColumnJoiningStrategy primaryKeyJoinColumnJoiningStrategy;
    protected OrmJoinTableJoiningStrategy joinTableJoiningStrategy;

    protected AbstractOrmOneToOneRelationshipReference(OrmOneToOneMapping parent, XmlOneToOne resource) {
        super(parent, resource);
    }

    @Override
    protected void initializeJoiningStrategies() {
        this.mappedByJoiningStrategy = this.buildMappedByJoiningStrategy();
        this.primaryKeyJoinColumnJoiningStrategy = this.buildPrimaryKeyJoinColumnJoiningStrategy();
        this.joinTableJoiningStrategy = this.buildJoinTableJoiningStrategy();
        this.joinColumnJoiningStrategy = this.buildJoinColumnJoiningStrategy();
    }

    protected OrmMappedByJoiningStrategy buildMappedByJoiningStrategy() {
        return new GenericOrmMappedByJoiningStrategy(this, this.getResourceMapping());
    }

    protected OrmJoinColumnJoiningStrategy buildJoinColumnJoiningStrategy() {
        return new GenericOrmJoinColumnJoiningStrategy(this, (XmlJoinColumnsMapping)this.getResourceMapping());
    }

    protected OrmPrimaryKeyJoinColumnJoiningStrategy buildPrimaryKeyJoinColumnJoiningStrategy() {
        return new GenericOrmPrimaryKeyJoinColumnJoiningStrategy(this, this.getResourceMapping());
    }

    protected abstract OrmJoinTableJoiningStrategy buildJoinTableJoiningStrategy();

    @Override
    public void initializeOn(OrmRelationshipReference newRelationshipReference) {
        newRelationshipReference.initializeFromOwnableRelationshipReference(this);
        newRelationshipReference.initializeFromJoinColumnEnabledRelationshipReference(this);
    }

    @Override
    public void initializeFromOwnableRelationshipReference(OrmOwnableRelationshipReference oldRelationshipReference) {
        this.mappedByJoiningStrategy.setMappedByAttribute(oldRelationshipReference.getMappedByJoiningStrategy().getMappedByAttribute());
    }

    @Override
    public void initializeFromJoinColumnEnabledRelationshipReference(OrmJoinColumnEnabledRelationshipReference oldRelationshipReference) {
        int index = 0;
        for (JoinColumn joinColumn : CollectionTools.iterable(oldRelationshipReference.getJoinColumnJoiningStrategy().specifiedJoinColumns())) {
            OrmJoinColumn newJoinColumn = this.getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(index++);
            newJoinColumn.initializeFrom(joinColumn);
        }
    }

    @Override
    public OrmOneToOneMapping getRelationshipMapping() {
        return (OrmOneToOneMapping)this.getParent();
    }

    @Override
    public XmlOneToOne getResourceMapping() {
        return this.getRelationshipMapping().getResourceAttributeMapping();
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.mappedByJoiningStrategy.getMappedByAttribute() == null;
    }

    @Override
    public boolean isOwnedBy(RelationshipMapping mapping) {
        return this.mappedByJoiningStrategy.relationshipIsOwnedBy(mapping);
    }

    @Override
    public OrmMappedByJoiningStrategy getMappedByJoiningStrategy() {
        return this.mappedByJoiningStrategy;
    }

    @Override
    public boolean usesMappedByJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.mappedByJoiningStrategy;
    }

    @Override
    public void setMappedByJoiningStrategy() {
        this.mappedByJoiningStrategy.addStrategy();
        this.joinColumnJoiningStrategy.removeStrategy();
        this.primaryKeyJoinColumnJoiningStrategy.removeStrategy();
        this.joinTableJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public void unsetMappedByJoiningStrategy() {
        this.mappedByJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public boolean mayBeMappedBy(AttributeMapping mappedByMapping) {
        return mappedByMapping.getKey() == "oneToOne";
    }

    @Override
    public OrmJoinColumnJoiningStrategy getJoinColumnJoiningStrategy() {
        return this.joinColumnJoiningStrategy;
    }

    @Override
    public boolean usesJoinColumnJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.joinColumnJoiningStrategy;
    }

    @Override
    public void setJoinColumnJoiningStrategy() {
        this.mappedByJoiningStrategy.removeStrategy();
        this.primaryKeyJoinColumnJoiningStrategy.removeStrategy();
        this.joinTableJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public void unsetJoinColumnJoiningStrategy() {
        this.joinColumnJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public boolean mayHaveDefaultJoinColumn() {
        return this.getMappedByJoiningStrategy().getMappedByAttribute() == null && this.getPrimaryKeyJoinColumnJoiningStrategy().primaryKeyJoinColumnsSize() == 0 && this.getJoinTableJoiningStrategy().getJoinTable() == null;
    }

    @Override
    public OrmPrimaryKeyJoinColumnJoiningStrategy getPrimaryKeyJoinColumnJoiningStrategy() {
        return this.primaryKeyJoinColumnJoiningStrategy;
    }

    @Override
    public boolean usesPrimaryKeyJoinColumnJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.primaryKeyJoinColumnJoiningStrategy;
    }

    @Override
    public void setPrimaryKeyJoinColumnJoiningStrategy() {
        this.primaryKeyJoinColumnJoiningStrategy.addStrategy();
        this.mappedByJoiningStrategy.removeStrategy();
        this.joinColumnJoiningStrategy.removeStrategy();
        this.joinTableJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public void unsetPrimaryKeyJoinColumnJoiningStrategy() {
        this.primaryKeyJoinColumnJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public boolean mayHaveDefaultPrimaryKeyJoinColumn() {
        return false;
    }

    @Override
    public OrmJoinTableJoiningStrategy getJoinTableJoiningStrategy() {
        return this.joinTableJoiningStrategy;
    }

    @Override
    public boolean usesJoinTableJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.joinTableJoiningStrategy;
    }

    @Override
    public final void setJoinTableJoiningStrategy() {
        this.joinTableJoiningStrategy.addStrategy();
        this.mappedByJoiningStrategy.removeStrategy();
        this.joinColumnJoiningStrategy.removeStrategy();
        this.primaryKeyJoinColumnJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public final void unsetJoinTableJoiningStrategy() {
        this.unsetJoinTableJoiningStrategy_();
        this.setPredominantJoiningStrategy();
    }

    protected void unsetJoinTableJoiningStrategy_() {
        this.joinTableJoiningStrategy.removeStrategy();
    }

    @Override
    public boolean mayHaveDefaultJoinTable() {
        return false;
    }

    @Override
    protected void updateJoiningStrategies() {
        this.mappedByJoiningStrategy.update();
        this.primaryKeyJoinColumnJoiningStrategy.update();
        this.joinTableJoiningStrategy.update();
        this.joinColumnJoiningStrategy.update();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.mappedByJoiningStrategy.validate(messages, reporter);
        this.primaryKeyJoinColumnJoiningStrategy.validate(messages, reporter);
        this.joinColumnJoiningStrategy.validate(messages, reporter);
        this.joinTableJoiningStrategy.validate(messages, reporter);
    }
}

