/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkTransformerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceEclipseLinkTransformerAnnotation
extends SourceAnnotation<Attribute>
implements EclipseLinkTransformerAnnotation {
    final DeclarationAnnotationElementAdapter<String> transformerClassDeclarationAdapter;
    final AnnotationElementAdapter<String> transformerClassAdapter;
    String transformerClass;
    final DeclarationAnnotationElementAdapter<String> methodDeclarationAdapter;
    final AnnotationElementAdapter<String> methodAdapter;
    String method;

    SourceEclipseLinkTransformerAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, DeclarationAnnotationAdapter daa) {
        super((JavaResourceNode)parent, (Member)attribute, daa);
        this.transformerClassDeclarationAdapter = new ConversionDeclarationAnnotationElementAdapter(daa, this.getTransformerClassElementName(), false, SimpleTypeStringExpressionConverter.instance());
        this.transformerClassAdapter = new MemberAnnotationElementAdapter((Member)attribute, this.transformerClassDeclarationAdapter);
        this.methodDeclarationAdapter = ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)this.getMethodElementName(), (boolean)false);
        this.methodAdapter = new MemberAnnotationElementAdapter((Member)attribute, this.methodDeclarationAdapter);
    }

    public void initialize(CompilationUnit astRoot) {
        this.transformerClass = this.buildTransformerClass(astRoot);
        this.method = this.buildMethod(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncTransformerClass(this.buildTransformerClass(astRoot));
        this.syncMethod(this.buildMethod(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.transformerClass);
    }

    @Override
    public String getTransformerClass() {
        return this.transformerClass;
    }

    @Override
    public void setTransformerClass(String transformerClass) {
        if (this.attributeValueHasChanged(this.transformerClass, transformerClass)) {
            this.transformerClass = transformerClass;
            this.transformerClassAdapter.setValue((Object)transformerClass);
        }
    }

    private void syncTransformerClass(String astTransformerClass) {
        String old = this.transformerClass;
        this.transformerClass = astTransformerClass;
        this.firePropertyChanged("transformerClass", old, astTransformerClass);
    }

    private String buildTransformerClass(CompilationUnit astRoot) {
        return (String)this.transformerClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTransformerClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.transformerClassDeclarationAdapter, astRoot);
    }

    abstract String getTransformerClassElementName();

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String method) {
        if (this.attributeValueHasChanged(this.method, method)) {
            this.method = method;
            this.methodAdapter.setValue((Object)method);
        }
    }

    private void syncMethod(String astMethod) {
        String old = this.method;
        this.method = astMethod;
        this.firePropertyChanged("method", old, astMethod);
    }

    private String buildMethod(CompilationUnit astRoot) {
        return (String)this.methodAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getMethodTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.methodDeclarationAdapter, astRoot);
    }

    abstract String getMethodElementName();
}

