/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkPrivateOwned;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkPrivateOwnedAnnotation;

public class JavaEclipseLinkPrivateOwned
extends AbstractJavaJpaContextNode
implements EclipseLinkPrivateOwned {
    protected boolean privateOwned;
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;

    public JavaEclipseLinkPrivateOwned(JavaAttributeMapping parent) {
        super((JpaContextNode)parent);
    }

    protected String getPrivateOwnedAnnotationName() {
        return "org.eclipse.persistence.annotations.PrivateOwned";
    }

    protected EclipseLinkPrivateOwnedAnnotation getResourcePrivateOwned() {
        return (EclipseLinkPrivateOwnedAnnotation)this.resourcePersistentAttribute.getAnnotation(this.getPrivateOwnedAnnotationName());
    }

    protected void addResourcePrivateOwned() {
        this.resourcePersistentAttribute.addAnnotation(this.getPrivateOwnedAnnotationName());
    }

    protected void removeResourcePrivateOwned() {
        this.resourcePersistentAttribute.removeAnnotation(this.getPrivateOwnedAnnotationName());
    }

    public boolean isPrivateOwned() {
        return this.privateOwned;
    }

    public void setPrivateOwned(boolean newPrivateOwned) {
        if (this.privateOwned == newPrivateOwned) {
            return;
        }
        boolean oldPrivateOwned = this.privateOwned;
        this.privateOwned = newPrivateOwned;
        if (newPrivateOwned) {
            this.addResourcePrivateOwned();
        } else if (this.getResourcePrivateOwned() != null) {
            this.removeResourcePrivateOwned();
        }
        this.firePropertyChanged("privateOwned", oldPrivateOwned, newPrivateOwned);
    }

    protected void setPrivateOwned_(boolean newPrivateOwned) {
        boolean oldPrivateOwned = this.privateOwned;
        this.privateOwned = newPrivateOwned;
        this.firePropertyChanged("privateOwned", oldPrivateOwned, newPrivateOwned);
    }

    public void initialize(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.privateOwned = this.privateOwned();
    }

    public void update(JavaResourcePersistentAttribute jrpa) {
        this.resourcePersistentAttribute = jrpa;
        this.setPrivateOwned_(this.privateOwned());
    }

    private boolean privateOwned() {
        return this.getResourcePrivateOwned() != null;
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        EclipseLinkPrivateOwnedAnnotation resourcePrivateOwned = this.getResourcePrivateOwned();
        return resourcePrivateOwned == null ? null : resourcePrivateOwned.getTextRange(astRoot);
    }
}

