/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.jpt.utility.Command;

public class SynchronizedBoolean
implements Cloneable,
Serializable {
    private boolean value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedBoolean(boolean value, Object mutex) {
        this.value = value;
        this.mutex = mutex;
    }

    public SynchronizedBoolean(boolean value) {
        this.value = value;
        this.mutex = this;
    }

    public SynchronizedBoolean(Object mutex) {
        this(false, mutex);
    }

    public SynchronizedBoolean() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getValue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean is(boolean v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNot(boolean v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value ^ v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTrue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFalse() {
        Object object = this.mutex;
        synchronized (object) {
            return !this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(boolean value) {
        Object object = this.mutex;
        synchronized (object) {
            this.setValue_(value);
        }
    }

    private void setValue_(boolean v) {
        if (this.value != v) {
            this.value = v;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flip() {
        Object object = this.mutex;
        synchronized (object) {
            boolean v = !this.value;
            this.setValue_(v);
            return v;
        }
    }

    public void setNot(boolean v) {
        this.setValue(!v);
    }

    public void setTrue() {
        this.setValue(true);
    }

    public void setFalse() {
        this.setValue(false);
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIs(boolean v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs_(v);
        }
    }

    private void waitUntilValueIs_(boolean v) throws InterruptedException {
        while (this.value != v) {
            this.mutex.wait();
        }
    }

    public void waitUntilValueIsNot(boolean v) throws InterruptedException {
        this.waitUntilValueIs(!v);
    }

    public void waitUntilTrue() throws InterruptedException {
        this.waitUntilValueIs(true);
    }

    public void waitUntilFalse() throws InterruptedException {
        this.waitUntilValueIs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetValue(boolean v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs_(!v);
            this.setValue_(v);
        }
    }

    public void waitToSetTrue() throws InterruptedException {
        this.waitToSetValue(true);
    }

    public void waitToSetFalse() throws InterruptedException {
        this.waitToSetValue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIs(boolean v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs_(v, timeout);
        }
    }

    private boolean waitUntilValueIs_(boolean v, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilValueIs_(v);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (this.value != v && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.value == v;
    }

    public void waitUntilValueIsNot(boolean v, long timeout) throws InterruptedException {
        this.waitUntilValueIs(!v, timeout);
    }

    public boolean waitUntilTrue(long timeout) throws InterruptedException {
        return this.waitUntilValueIs(true, timeout);
    }

    public boolean waitUntilFalse(long timeout) throws InterruptedException {
        return this.waitUntilValueIs(false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetValue(boolean v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilValueIs_(!v, timeout);
            if (success) {
                this.setValue_(v);
            }
            return success;
        }
    }

    public boolean waitToSetTrue(long timeout) throws InterruptedException {
        return this.waitToSetValue(true, timeout);
    }

    public boolean waitToSetFalse(long timeout) throws InterruptedException {
        return this.waitToSetValue(false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedBoolean clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                return (SynchronizedBoolean)super.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        return o instanceof SynchronizedBoolean && this.getValue() == ((SynchronizedBoolean)o).getValue();
    }

    public int hashCode() {
        return this.getValue() ? 1 : 0;
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.getValue()) + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            s.defaultWriteObject();
        }
    }
}

