/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.eclipse.ant.internal.launching.debug.model.AntProperty;
import org.eclipse.ant.internal.launching.debug.model.AntStackFrame;
import org.eclipse.ant.internal.launching.debug.model.AntValue;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.AntEditorSourceViewerConfiguration;
import org.eclipse.ant.internal.ui.editor.text.AntEditorTextMessages;
import org.eclipse.ant.internal.ui.editor.text.FileScanner;
import org.eclipse.ant.internal.ui.editor.text.XMLProblemAnnotation;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntPropertyNode;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class XMLTextHover
implements ITextHover,
ITextHoverExtension,
IInformationProviderExtension2 {
    private AntEditor fEditor;
    static /* synthetic */ Class class$0;

    public XMLTextHover(AntEditor editor) {
        this.fEditor = editor;
    }

    private String formatMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog((StringBuffer)buffer);
        HTMLPrinter.addParagraph((StringBuffer)buffer, (String)message);
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        return buffer.toString();
    }

    private String formatPathMessage(String[] list) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog((StringBuffer)buffer);
        HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)AntEditorTextMessages.XMLTextHover_4);
        HTMLPrinter.startBulletList((StringBuffer)buffer);
        int i = 0;
        while (i < list.length) {
            HTMLPrinter.addBullet((StringBuffer)buffer, (String)list[i]);
            ++i;
        }
        HTMLPrinter.endBulletList((StringBuffer)buffer);
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        return buffer.toString();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String message;
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        ISourceViewer sourceViewer = (ISourceViewer)textViewer;
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        if (model != null && (message = this.getAnnotationModelHoverMessage(model, hoverRegion)) != null) {
            return message;
        }
        AntModel antModel = this.fEditor.getAntModel();
        if (antModel == null) {
            return null;
        }
        return this.getAntModelHoverMessage(antModel, hoverRegion, textViewer);
    }

    private String getAntModelHoverMessage(AntModel antModel, IRegion hoverRegion, ITextViewer textViewer) {
        try {
            String value;
            IDocument document = textViewer.getDocument();
            int offset = hoverRegion.getOffset();
            int length = hoverRegion.getLength();
            String text = document.get(offset, length);
            AntElementNode node = antModel.getNode(offset, false);
            if (document.get(offset - 2, 2).equals("${") || node instanceof AntPropertyNode) {
                AntProperty property;
                AntStackFrame frame = this.getFrame();
                if (frame != null && (property = frame.findProperty(text)) != null) {
                    return ((AntValue)property.getValue()).getValueString();
                }
                value = antModel.getPropertyValue(text);
                if (value != null) {
                    return this.formatMessage(HTMLPrinter.convertToHTMLContent((String)value));
                }
            }
            if ((value = antModel.getTargetDescription(text)) != null) {
                return this.formatMessage(HTMLPrinter.convertToHTMLContent((String)value));
            }
            Object referencedObject = antModel.getReferenceObject(text);
            if (referencedObject != null) {
                if (referencedObject instanceof Path) {
                    return this.formatPathMessage(((Path)referencedObject).list());
                }
                if (referencedObject instanceof PatternSet) {
                    return this.formatPatternSetMessage((PatternSet)referencedObject);
                }
                if (referencedObject instanceof AbstractFileSet) {
                    return this.formatFileSetMessage((AbstractFileSet)referencedObject);
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BuildException be) {
            return be.getMessage();
        }
        return null;
    }

    private String getAnnotationModelHoverMessage(IAnnotationModel model, IRegion hoverRegion) {
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            String msg;
            Position p;
            Annotation a = (Annotation)e.next();
            if (!(a instanceof XMLProblemAnnotation) || !(p = model.getPosition(a)).overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = a.getText()) == null || msg.trim().length() <= 0) continue;
            return this.formatMessage(msg);
        }
        return null;
    }

    private String formatFileSetMessage(AbstractFileSet set) {
        FileScanner fileScanner = new FileScanner();
        AntModel antModel = this.fEditor.getAntModel();
        Project project = antModel.getProjectNode().getProject();
        set.setupDirectoryScanner((org.apache.tools.ant.FileScanner)fileScanner, project);
        String[] excludedPatterns = fileScanner.getExcludesPatterns();
        String[] includesPatterns = fileScanner.getIncludePatterns();
        return this.formatSetMessage(includesPatterns, excludedPatterns);
    }

    private String formatPatternSetMessage(PatternSet set) {
        AntModel antModel = this.fEditor.getAntModel();
        Project project = antModel.getProjectNode().getProject();
        String[] includes = set.getIncludePatterns(project);
        String[] excludes = set.getExcludePatterns(project);
        return this.formatSetMessage(includes, excludes);
    }

    private String formatSetMessage(String[] includes, String[] excludes) {
        int i;
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog((StringBuffer)buffer);
        if (includes != null && includes.length > 0) {
            HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)AntEditorTextMessages.XMLTextHover_5);
            i = 0;
            while (i < includes.length) {
                HTMLPrinter.addBullet((StringBuffer)buffer, (String)includes[i]);
                ++i;
            }
        }
        HTMLPrinter.addParagraph((StringBuffer)buffer, (String)"");
        HTMLPrinter.addParagraph((StringBuffer)buffer, (String)"");
        if (excludes != null && excludes.length > 0) {
            HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)AntEditorTextMessages.XMLTextHover_6);
            i = 0;
            while (i < excludes.length) {
                HTMLPrinter.addBullet((StringBuffer)buffer, (String)excludes[i]);
                ++i;
            }
        }
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        return buffer.toString();
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            return XMLTextHover.getRegion(textViewer, offset);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static IRegion getRegion(ITextViewer textViewer, int offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IRegion cleanRegionForNonProperty(int offset, IDocument document, IRegion region) throws BadLocationException {
        StringTokenizer tokenizer;
        String text = document.get(region.getOffset(), region.getLength());
        if (text.startsWith("/")) {
            text = text.substring(1);
            region = new Region(region.getOffset() + 1, region.getLength() - 1);
        }
        if ((tokenizer = new StringTokenizer(text, " ")).countTokens() != 1) {
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int index = text.indexOf(token);
                if (region.getOffset() + index > offset || region.getOffset() + index + token.length() < offset) continue;
                region = new Region(region.getOffset() + index, token.length());
                break;
            }
        }
        return region;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    private AntStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ant.internal.launching.debug.model.AntStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (AntStackFrame)adaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return AntEditorSourceViewerConfiguration.getInformationPresenterControlCreator();
    }
}

